/******************************************************************************
 * Header file for Rage 128 Chapter 3 sample code                             *
 * Includes structures, prototypes, and globals.                              *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#include <stdio.h>
#include <io.h>

#ifndef _MAIN_H
#define _MAIN_H

#ifdef BOOL
    #undef BOOL
#endif
#ifdef BYTE
    #undef BYTE
#endif
#ifdef WORD
    #undef WORD
#endif
#ifdef DWORD
    #undef DWORD
#endif

typedef int BOOL;
typedef unsigned char BYTE;
typedef unsigned short int WORD;
typedef unsigned long int DWORD;

// Structures.

typedef struct
{
    WORD PCI_Vendor_ID;
    WORD PCI_Device_ID;
    DWORD memsize;
    BYTE bus_num;
    BYTE dev_num;
    BYTE FLAGS;
    BYTE PCI_Revision_ID;
    DWORD MEM_BASE;
    DWORD virtual_MEM_BASE;
    DWORD IO_BASE;
    DWORD REG_BASE;
    DWORD virtual_REG_BASE;
    DWORD BIOS_SEG;
    WORD xres;
    WORD yres;
    BYTE bpp;
    BYTE bytepp;
    WORD pitch;

} AdapterInfo;

typedef struct
{
    WORD video_mode;
    WORD refresh_bit_mask;
    WORD flags;
    WORD crtc_h_disp__h_total;
    WORD crtc_h_sync_wid__strt;
    WORD crtc_v_total;
    WORD crtc_v_disp;
    WORD crtc_v_sync_strt;
    WORD crtc_h_disp__v_sync_width;
    WORD dot_clock;
    WORD crtc_h_sync_dly__ovr_wid_right__left;
    WORD ovr_wid_top__bottom;
    WORD ovr_clr_g__b;
    WORD ovr_clr_r;
} CRTParameterTable;

typedef struct
{
    WORD red;
    WORD green;
    WORD blue;
} palette;

typedef struct
{
    WORD fb_div;
    WORD post_div;
} pllinfo;

// Structs for nbmode.c
typedef struct
{
    WORD offset;
    DWORD value;
} offset_value_struct;

typedef struct
{
    WORD HorizTotal;
    WORD HorizSyncStart;
    WORD HorizSyncEnd;
    WORD VertTotal;
    WORD VertSyncStart;
    WORD VertSyncEnd;
    WORD CRTCInfoFlags;
    WORD PixelClock;
} CRTCInfoBlock;

#pragma pack(1)
typedef struct
{
    BYTE clock_chip_type;
    BYTE struct_size;
    BYTE acclerator_entry;
    BYTE VGA_entry;
    WORD VGA_table_offset;
    WORD POST_table_offset;
    WORD XCLK;
    WORD MCLK;
    BYTE num_PLL_blocks;
    BYTE size_PLL_blocks;
    WORD PCLK_ref_freq;
    WORD PCLK_ref_divider;
    DWORD PCLK_min_freq;
    DWORD PCLK_max_freq;
    WORD MCLK_ref_freq;
    WORD MCLK_ref_divider;
    DWORD MCLK_min_freq;
    DWORD MCLK_max_freq;
    WORD XCLK_ref_freq;
    WORD XCLK_ref_divider;
    DWORD XCLK_min_freq;
    DWORD XCLK_max_freq;
} _PLL_BLOCK;


typedef struct
{
    WORD xres;
    WORD yres;
    WORD pclock;
    WORD H_nonvisible;
    WORD H_overplus;
    WORD H_syncwidth;
    WORD V_nonvisible;
    WORD V_overplus;
    WORD V_syncwidth;
} panelinf;

#pragma pack()

// Prototypes.

// Functions in ch3lib.c
void R128_ShutDown (void);
void process_command_line (int argc, char *argv[]);
WORD get_old_mode (void);
WORD set_old_mode (void);
DWORD phys_to_virt (DWORD physical, DWORD size);
void R128_PrintInfoStruct (void);
void R128_PrintInfoStruct2File (void);
BYTE R128_Detect (void);
BYTE R128_FindRom (void);
BYTE R128_RegTest (void);
DWORD R128_GetBPPValue (WORD bpp);
WORD R128_GetBPPFromValue (DWORD value);
void R128_Delay (WORD ticks);

// Functions in REGRDWRT.C
DWORD regr (WORD);
WORD regr16 (WORD);
BYTE regr8 (WORD);
DWORD PLL_regr (WORD);
WORD PLL_regr16 (WORD);
BYTE PLL_regr8 (WORD);
void regw (WORD regindex, DWORD data);
void regw16 (WORD regindex, WORD data);
void regw8 (WORD regindex, BYTE data);
void PLL_regw (WORD regindex, DWORD data);
void PLL_regw16 (WORD regindex, WORD data);
void PLL_regw8 (WORD regindex, BYTE data);
void iow8 (DWORD, BYTE);
BYTE ior8 (DWORD);

// Functions in setmode.c
BYTE R128_SetMode (WORD xres, WORD yres, BYTE bpp);

// Functions in initeng.c
void R128_InitEngine (void);
void R128_WaitForIdle (void);
void R128_WaitForFifo (DWORD entries);
void R128_ResetEngine (void);
void R128_FlushPixelCache (void);


// Functions in PCICFG.C
WORD PCIInstallCheck (void);
BYTE GetPCIByte (WORD bus, WORD dev, WORD reg);
WORD GetPCIWord (WORD bus, WORD dev, WORD reg);
DWORD GetPCIDword (WORD bus, WORD dev, WORD reg);
void SetPCIByte (WORD bus, WORD dev, WORD reg, BYTE data);
void SetPCIWord (WORD bus, WORD dev, WORD reg, WORD data);
void SetPCIDword (WORD bus, WORD dev, WORD reg, DWORD data);

// functions in DPMIMEM.C
DWORD DPMI_allocdosmem (DWORD paragraphs, DWORD *segment, DWORD *selector);
DWORD DPMI_freedosmem (DWORD selector);
DWORD DPMI_allocatelogicalregion (DWORD, DWORD);
WORD DPMI_freelogicalregion (DWORD);
WORD DPMI_allocatememory (DWORD, DWORD *, DWORD *);
WORD DPMI_freememory (DWORD);

// Functions in STARTUP.C
void R128_StartUp ( int argc, char *argv[]);

// Functions in COLOUR.C
DWORD R128_GetColourCode (WORD );

// Functions in PALETTE.C
void R128_SetPaletteEntry (WORD, palette);
palette R128_GetPaletteEntry (WORD);
void R128_SavePalette (palette *);
void R128_RestorePalette (palette *);
void R128_InitPalette (void);
void R128_InitGamma (void);

// functions in R128PLL.C
DWORD RoundDiv (DWORD Numerator, DWORD Denominator);
DWORD Minimum (DWORD Value1, DWORD Value2);
DWORD Maximum (DWORD Value1, DWORD Value2);
DWORD MinBitsRequired (DWORD Value);
DWORD R128_VClockValue (void);
BYTE R128_ProgramDDAFifo (DWORD BitsPerPixel);
BYTE GetPostDividerBitValue (BYTE PostDivider);
void R128_PLLWriteUpdate (void);
BYTE R128_PLLReadUpdateComplete (void);
void R128_ProgramPLL (void);
void R128_PLLGetDividers (WORD Frequency);
void R128_DisableAtomicUpdate (void);

// Functions in NBMODE.C
void set_common_regs (void);
void video_off (void);
void video_on (void);
BYTE R128_SetModeNB (WORD, WORD, WORD, CRTCInfoBlock *);
void R128_GetPLLInfo (void);

// Functions in DPMS.C
void R128_SetDPMS (WORD);
WORD R128_GetDPMS (void);

// Globals.
extern AdapterInfo R128_AdapterInfo;
extern DWORD OLD_MODE;
extern pllinfo PLL_INFO;
extern _PLL_BLOCK PLL_BLOCK;
extern panelinf P;

// Globals for NOBIOS mode setting
extern CRTCInfoBlock mode320_60, mode640_60, mode800_60, mode1024_60, mode1280_60;
extern CRTCInfoBlock mode512, mode1600_60, mode320_75, mode864_60, mode848_88;
extern CRTCInfoBlock mode1152_60, mode1920_60, mode400_75, mode720_60;
extern CRTCInfoBlock mode1280_75;
extern offset_value_struct common_regs_table[12];

#endif // _MAIN_H
