/******************************************************************************
 * modeparm.c - Chapter 3 mode parameter file                                 *
 *                                                                            *
 * This module defines the mode table parameters used when setting a          *
 * display mode without using the BIOS.                                       *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#include "defines.h"
#include "main.h"

/***************************************
    This structure is defined in MAIN.H
    It is reprinted here for convenience.

typedef struct {
    WORD HorizTotal; // htotal (pixels)
    WORD HorizSyncStart; // hsyncstart (pixels)
    WORD HorizSyncEnd; // syncend (pixels)
    WORD VertTotal; // vtotal (lines)
    WORD VertSyncStart; // vsyncstart (lines)
    WORD VertSyncEnd; // vsyncend (lines)
    WORD CRTCInfoFlags;  //   flags (bits 0-3 = dblscan, interlace,
                         //   hpolarity (1=neg), vpolarity (1=neg))
    WORD PixelClock; // pixel clock (Hz/10000)
} CRTCInfoBlock;
*****************************************/

CRTCInfoBlock mode320x200 = {   // 320x200 (70 Hz)
    400, 328, 376,  449, 413, 415,  4|CI_DBLSCAN,  1259
    };


CRTCInfoBlock mode320_60 = {    // 320x240, 60 Hz
    400, 328, 376,  525, 491, 493,  0xC|CI_DBLSCAN,  1260
    };

CRTCInfoBlock mode320_72 = {    // 320x240, 72 Hz
    416, 332, 356,  526, 492, 495,  0xC|CI_DBLSCAN,  1575
    };

CRTCInfoBlock mode320_75 = {    // 320x240, 75 Hz
    424, 330, 362,  500, 481, 484,  0xC|CI_DBLSCAN,  1590
    };

CRTCInfoBlock mode320_85 = {    // 320x240, 85 Hz
    416, 348, 380,  509, 481, 484,  0xC|CI_DBLSCAN,  1800
    };

CRTCInfoBlock mode400_75 = {    // 400x300, 75 Hz
    528, 408, 435, 625, 601, 611, 0xC | CI_DBLSCAN, 2475
    };

CRTCInfoBlock mode512 = {   // 512x384 (70 Hz)
    640, 524, 604,  449, 405, 407,  4,  2014
    };


CRTCInfoBlock mode640x400 = {   // 640x400 (70 Hz)
    800, 656, 752,  449, 413, 415,  4,  2518
    };


CRTCInfoBlock mode640_60 = {    // 640x480, 60 Hz
    800, 656, 752,  525, 491, 513,  0xC,  2518
    };

CRTCInfoBlock mode640_72 = {    // 640x480, 72 Hz
    832, 664, 704,  526, 492, 495,  0xC,  3150
    };

CRTCInfoBlock mode640_75 = {    // 640x480, 75 Hz
    840, 656, 720,  500, 481, 484,  0xC,  3150
    };

CRTCInfoBlock mode640_85 = {    // 640x480, 85 Hz
    832, 696, 752,  509, 481, 484,  0xC,  3600
    };

CRTCInfoBlock mode720_60 = {    // 720x480, 60 Hz
    1000, 752, 815, 525, 491, 499, 0x0, 3150
    };

CRTCInfoBlock mode800_60 = {    // 800x600, 60 Hz
    1056, 840, 968,  628, 601, 605,  0x0,  4000
    };

CRTCInfoBlock mode800_72 = {    // 800x600, 72 Hz
    1040, 856, 976,  666, 637, 643,  0,  5000
    };

CRTCInfoBlock mode800_75 = {    // 800x600, 75 Hz
    1056, 816, 896,  625, 601, 604,  0,  4950
    };

CRTCInfoBlock mode800_85 = {    // 800x600, 85 Hz
    1048, 832, 896,  631, 601, 604,  0,  5625
    };

CRTCInfoBlock mode848_88 = {    // 848x640, 88 Hz
    1088, 904, 1024, 520, 489, 492, 0xC, 5000
    };

CRTCInfoBlock mode864_60 = {    // 864x480, 60 Hz
    1120, 904, 968, 525, 487, 489, 0, 3538
    };

CRTCInfoBlock mode1024_i = {    // 1024x768, interlaced (43 Hz)
    1264, 1032, 1192,  817, 770, 778,  0x0 | CI_INTERLACE,  4490
    };

CRTCInfoBlock mode1024_60 = {   // 1024x768, 60 Hz
    1344, 1048, 1184,  806, 771, 777,  0xC,  6500
    };

CRTCInfoBlock mode1024_70 = {   // 1024x768, 70 Hz
    1328, 1048, 1184,  806, 771, 777,  0xC,  7500
    };

CRTCInfoBlock mode1024_75 = {   // 1024x768, 75 Hz
    1312, 1040, 1136,  800, 769, 772,  0,  7875
    };

CRTCInfoBlock mode1024_85 = {   // 1024x768, 85 Hz
    1376, 1072, 1168,  808, 769, 772,  0,  9450
    };

CRTCInfoBlock mode1152_60 = {   // 1152x864, 60 Hz
    1456, 1152, 1264,  914, 868, 873,  0,  8000
    };

CRTCInfoBlock mode1280_i = {    // 1280x1024, interlaced (43 Hz)
    1664, 1336, 1552,  1105, 1042, 1050,  CI_INTERLACE,  8000
    };

CRTCInfoBlock mode1280_60 = {   // 1280x1024, 60 Hz
    1712, 1340, 1440,  1066, 1025, 1028,  0,  11000
    };

CRTCInfoBlock mode1280_75 = {   // 1280x1024, 75 Hz
    1688, 1296, 1440,  1066, 1025, 1028,  0,  13500
    };

CRTCInfoBlock mode1280_85 = {   // 1280x1024, 85 Hz
    1728, 1344, 1504,  1072, 1025, 1028,  0,  15750
    };

CRTCInfoBlock mode1600_i = {    // 1600x1200, interlaced (47 Hz)
    2112, 1664, 1856,  1263, 1202, 1208,  CI_INTERLACE,  12600
    };

CRTCInfoBlock mode1600_60 = {   // 1600x1200, 60 Hz
    2160, 1664, 1856,  1250, 1201, 1204,  0,  16200
    };

CRTCInfoBlock mode1600_65 = {   // 1600x1200, 65 Hz
    2160, 1664, 1856,  1250, 1201, 1204,  0,  17550
    };

CRTCInfoBlock mode1600_75 = {   // 1600x1200, 75 Hz
    2160, 1664, 1856,  1250, 1201, 1204,  0,  20250
    };

CRTCInfoBlock mode1600_85 = {   // 1600x1200, 85 Hz
    2160, 1664, 1856,  1250, 1201, 1204,  0,  22950
    };

CRTCInfoBlock mode1920_60 = {   // 1920x1440, 60 Hz
    2600, 2048, 2256, 1500, 1441, 1444, 4, 23400
    };


