/****************************************************************************
 * STARTUP.C                                                                *
 *  This file contains source code used for setting up sample applications. *
 *  This code will process the command line, detect the R128, set a display *
 *  mode, and then initializae the GUI engine.  The appropriate global      *
 *  variables are also set (R128_AdapterInfo, MODE_INFO).                   *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "defines.h"
#include "main.h"

void R128_StartUp (int argc, char *argv[])
{
    BYTE test;

    // First, let's make sure that a Rage 128 is installed.
    if (!R128_Detect ())
    {
        R128_ShutDown ();
        printf ("\nCannot detect a Rage 128 based graphics adapter.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    // Next, let's process the command line to confirm valid mode
    // information was passed.
    process_command_line (argc, argv);

    // Set the bytes per pixel and pitch value
    R128_AdapterInfo.bytepp = (R128_AdapterInfo.bpp+1)/8;
    if (R128_AdapterInfo.bpp == 24)
    {
        (R128_AdapterInfo.pitch = R128_AdapterInfo.xres * 3) / 8;
    }
    else
    {
        R128_AdapterInfo.pitch = R128_AdapterInfo.xres / 8;
    }

    test = R128_FindRom ();
    if (test == 0)
    {
        R128_ShutDown ();
        printf ("\nCannot find a Rage 128 BIOS.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    test = R128_RegTest ();
    if (test == 0)
    {
        R128_ShutDown ();
        printf ("\nRage 128 Register Test Failed!");
        printf ("\nProgram terminated.");
        exit (1);
    }

    // retain the previous display mode.
    get_old_mode ();

    if (!R128_SetMode (R128_AdapterInfo.xres, R128_AdapterInfo.yres,
                        R128_AdapterInfo.bpp))
    {
        R128_ShutDown ();
        printf ("\nUnable to set requested display mode: %d x %d, %d.",
                        R128_AdapterInfo.xres, R128_AdapterInfo.yres,
                        R128_AdapterInfo.bpp);
        printf ("\nProgram terminated.");
        exit (1);
    }

    if (R128_AdapterInfo.bpp == 8)
    {
        R128_InitPalette ();
    }
    else
    {
        R128_InitGamma ();
    }

    // Reset the engine in case it's stuck
    R128_ResetEngine ();

    // Initialize the GUI engine
    R128_InitEngine ();

    return;
}  // R128_StartUp


