/****************************************************************************
 * Rage 128 Chapter 4 sample code                                           *
 *                                                                          *
 * brtext.c - This program uses the brush data registers to draw text       *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc. All rights reserved.            *
 ****************************************************************************/
#include <stdio.h>
#include <i86.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"

/****************************************************************************
 * Main Program to demonstrate drawing text using the brush data registers  *
 *  Function: Three strings are drawn repeatedly to the screen              *
 *    Inputs: Arguments for mode spatial and colour resolution              *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void main (int argc, char *argv[])
{
    WORD xpos, ypos, loop, frgd, bkgd;
    char *str[] = { "The quick brown fox jumps over the lazy dog",
                     "x:X:x",
                     "01234",
                     "56789",
                     NULL
                    };
    WORD len[4];

    R128_StartUp (argc, argv);

    // clear screen.
    R128_ClearScreen (BLACK);

    // Load the text data, determine what size font to use.
    R128_LoadText ();

    // the R128_PrintText function requires a string, x position, y position,
    // foreground colour, background colour, and a transparency byte.
    // For transparency, 0 - use supplied background colour
    //                   1 - use the current screen background colour

    for (loop = 0; loop < 4; loop++)
    {
        len[loop] = strlen (str[loop]);
    }

    while (!kbhit ())
    //while (getch ()!=32)
    {
        for (loop = 0; loop < 4; loop++)
        {
            xpos = rand()%(R128_AdapterInfo.xres - (len[loop] * TEXT_INFO.actual_width));
            ypos = rand()%(R128_AdapterInfo.yres - TEXT_INFO.height);
            frgd = rand()%NUM_COLOURS;
            bkgd = rand()%NUM_COLOURS;

            // the R128_PrintText function requires a string, x position, y position,
            // foreground colour, background colour, and a transparency byte.
            // For transparency, 0 - use supplied background colour
            //                   1 - use the current screen background colour
            R128_PrintText (str[loop], xpos, ypos, frgd, bkgd, loop%2);
        }
        R128_Delay (10);
    }

    // Wait for a carriage return.
    getch ();

    // Batch command to restore old mode.
    R128_ShutDown ();

    exit (0);                           // No errors.

} // main

