/******************************************************************************
 * Rage 128 Chapter 4 sample code                                             *
 *                                                                            *
 * patline.c - This program uses the Rage 128 engine to draw patterned lines. *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <i86.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"

#define NUM_BRUSHES 5

/****************************************************************************
 * Main Program to demonstrate accelerated pattern line drawing             *
 *  Function: bresenham lines are repeatedly drawn on the screen.           *
 *    Inputs: Arguments for mode spatial and colour resolution              *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void main (int argc, char *argv[])
{
    DWORD x1, y1, x2, y2, temp;
    DWORD brushtype[NUM_BRUSHES] = { 2, 3, 6, 7, 11 };
    DWORD data[64] = {  0xFF00FFCC,
                        0x000000FF,
                        0x000000FF,
                        0x000000FF,
                        0x00FF0000,
                        0x00FF0000,
                        0x00FF0000,
                        0x00FF0000,
                        0x0000FF00,
                        0x0000FF00,
                        0x0000FF00,
                        0x0000FF00,
                        0x00FFFF00,
                        0x00FFFF00,
                        0x00FFFF00,
                        0x00FFFF00,
                        0x0000FFFF,
                        0x0000FFFF,
                        0x0000FFFF,
                        0x0000FFFF,
                        0x00FF00FF,
                        0x00FF00FF,
                        0x00FF00FF,
                        0x00FF00FF,
                        0x00000000,
                        0x00000000,
                        0x00000000,
                        0x00000000,
                        0x00FFFFFF,
                        0x00FFFFFF,
                        0x00FFFFFF,
                        0x00FFFFFF,
                        0x000000FF,
                        0x000000FF,
                        0x000000FF,
                        0x000000FF,
                        0x00FF0000,
                        0x00FF0000,
                        0x00FF0000,
                        0x00FF0000,
                        0x0000FF00,
                        0x0000FF00,
                        0x0000FF00,
                        0x0000FF00,
                        0x00FFFF00,
                        0x00FFFF00,
                        0x00FFFF00,
                        0x00FFFF00,
                        0x0000FFFF,
                        0x0000FFFF,
                        0x0000FFFF,
                        0x0000FFFF,
                        0x00FF00FF,
                        0x00FF00FF,
                        0x00FF00FF,
                        0x00FF00FF,
                        0x00000000,
                        0x00000000,
                        0x00000000,
                        0x00000000,
                        0x00FFFFFF,
                        0x00FFFFFF,
                        0x00FFFFFF,
                        0x00FFFFFF
                     };


    R128_StartUp (argc, argv);

    R128_ClearScreen (BLACK);

    temp = 0;

    R128_WaitForFifo (2);
    regw (DP_BRUSH_FRGD_CLR, R128_GetColourCode (LIGHTRED));
    regw (DP_BRUSH_BKGD_CLR, R128_GetColourCode (YELLOW));

    while (!kbhit())
    //while (getch ()!=32)
    {
        // Setup parameters.
        x1 = rand()%R128_AdapterInfo.xres;
        y1 = rand()%R128_AdapterInfo.yres;
        x2 = rand()%R128_AdapterInfo.xres;
        y2 = rand()%R128_AdapterInfo.yres;


        R128_WaitForFifo (2);
        regw (DP_BRUSH_FRGD_CLR, R128_GetColourCode (rand()%16));
        regw (DP_BRUSH_BKGD_CLR, R128_GetColourCode (rand()%16));

        // Draw line.
        R128_DrawPatternLine (x1, y1, x2, y2, (brushtype[temp] << 8), &data);
        temp ++;
        if (temp == NUM_BRUSHES)
        {
            temp = 0;
        }

        R128_Delay (2);

    } // while

    // Wait for user to press a key.
    getch ();

    // Batch command to restore old mode.
    R128_ShutDown ();

    exit (0);                           // No errors.

} // main





