/******************************************************************************
 * Header file for Rage128 Chapter 4 sample code                              *
 * Includes structures, prototypes, and globals.                              *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#ifndef _MAIN4_H
#define _MAIN4_H

#include "..\..\chap3\util\main.h"

typedef struct
{
    WORD x;
    WORD y;
    WORD h;
    WORD w;
    WORD frgd;
    WORD bkgd;
} blt_data;

typedef struct
{
    WORD x;
    WORD y;
    WORD buttons;
} mouse_pos;

typedef struct
{
    WORD x;
    WORD y;
} cursor_pos;

typedef struct
{
    WORD width;
    WORD height;
    DWORD cur_offset;
    BYTE cursorxor[512];
    BYTE cursorand[512];
} hwcursor;

typedef struct
{
    WORD width;
    WORD height;
    WORD bpp;
    WORD bytepp;
    DWORD size;
    char name [256];
    char * location;
} _img_info;

// Structures for VIEWIMG.C
#pragma pack(1)

typedef struct                      /* VT image file header structure */
{
    char     img_code[5];           // set to "_IMG" terminated with 0
    short    format_id;             // see FORMAT_TYPE_???? defines
    short    bytes_per_pixel;       // bytes per pixel (per format)
    short    width;                 // width of image in pixels
    short    height;                // height of image in lines
    unsigned long u_offset;         // byte offset to start of U data for
                                    //   YUV9 and YUV12 formats
    unsigned long v_offset;         // byte offset to start of V data for
                                    //   YUV9 and YUV12 formats
    char     filler[11];            // set to 0 (sets header to 32 bytes);
                                    //   regular data and Y data follows
                                    //   header
} img_header;

typedef struct
{
    char *filespec;
    img_header *image;
} img_handle;

typedef struct
{
    WORD width;
    WORD height;
    WORD actual_width;
    char *data;
} _TEXT_INFO;

typedef struct
{
    WORD src_cmp_fcn;
    WORD dst_cmp_fcn;
    WORD cmp_src;
    WORD src_clr;
    WORD dst_clr;
    WORD dst_x;
    WORD dst_y;
    WORD src_x;
    WORD src_y;
    WORD src_width;
    WORD src_height;
} _tbltdata;

// functions in viewimg.c
img_handle *get_img_header (char *);
WORD load_img (img_handle *, WORD, WORD);

// Functions in DRAWPRIM.C
void R128_DrawLine (WORD x1, WORD y1, WORD x2, WORD y2, DWORD colour);
void R128_ClearScreen (DWORD colour);
void R128_DrawRectangle (DWORD, DWORD, DWORD, DWORD, DWORD);
void R128_DrawBox (WORD x, WORD y, WORD width, WORD height, DWORD colour);
void R128_DrawBorder (DWORD colour);
void R128_LoadPatternData (DWORD brushtype, DWORD *data);
void R128_DrawPatternLine (WORD x1, WORD y1, WORD x2, WORD y2,
                            DWORD brushtype, DWORD *data);

// Functions in loadbmap.c
_img_info Load_Image (BYTE trajectory, DWORD bpp, WORD x, WORD y);
void R128_LoadImageIntoSystemMemory (_img_info IMG_DATA);
_img_info R128_GetImageFileHeaderInfo (DWORD bpp);

// functions in TEXT.C
void R128_LoadText (void);
void PrintChar (char, WORD, WORD);
void R128_PrintText (char *, WORD, WORD, DWORD, DWORD, BYTE);
void PrintSpace (WORD, WORD);
void PrintColon (WORD, WORD);

// functions in MOUSE.C
BYTE MOUSE_InitMouse (void);
void MOUSE_UpdatePosition (mouse_pos *mp);

// Globals
extern _TEXT_INFO TEXT_INFO;
extern img_handle *ReturnPtr;

#endif // _MAIN_4H

