/******************************************************************************
 * RAGE128 Chapter 5 Sample Code                                              *
 *                                                                            *
 * type0.c -  This program demonstrates the Concurrent Command Execution      *
 * (CCE) programming model by drawing a series of rectangles using CCE        *
 * Programmed I/O mode and Type-0 packets.                                    *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <conio.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"
#include "..\util\cce.h"


/******************************************************************************
 * main                                                                       *
 *  Function: Main loop.                                                      *
 *    Inputs: none                                                            *
 *   Outputs: none                                                            *
 ******************************************************************************/

void main (int argc, char *argv[])
{
    int test;
    DWORD Buf[20];
    DWORD x, y, width, height, colour;

    printf ("Rage 128 Sample Code, Chapter 5.\n"
            "TYPE0.EXE\n\n"
            "This program will demonstrate using Type-0 packets with the CCE\n"
            "microengine of the Rage 128.\n\n"
            "Mode resolution (eg 640 480) and colour depth (8, 15, 16, 24, 32)\n"
            "should be passed as command line arguments.\n"
            "Default resolution and colour depth is 640x480, 8bpp.\n\n"
            "Press any key to continue.\n\n");
    getch ();

    // First, run StartUp function to set up the application

    R128_StartUp (argc, argv);

    // Clear the screen

    R128_ClearScreen (BLACK);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192PIO) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

    while (!kbhit ())
    {
        x = (rand () % (R128_AdapterInfo.xres));
        y = (rand () % (R128_AdapterInfo.yres));
        width = rand () % (R128_AdapterInfo.xres - x);
        height = rand () % (R128_AdapterInfo.yres - y);
        colour = R128_GetColourCode (rand () % NUM_COLOURS);

        // Set up a packet for the brush colour.  Using a packet to
        // send out only one register write is very inefficient, but
        // is used here for illustrative purposes.

        Buf[0] = CCE_PACKET0 | (0 << 16) | (DP_BRUSH_FRGD_CLR >> 2);
        Buf[1] = colour;

        // Set up the packet for the rectangle draw.  Since DST_Y_X and
        // DST_HEIGHT_WIDTH are contiguous, using a Type-0 packet to send
        // out the register data is straightforward.

        Buf[2] = CCE_PACKET0 | (1 << 16) | (DST_Y_X >> 2);
        Buf[3] = x + (y << 16);
        Buf[4] = width + (height << 16);

        test = R128_CCESubmitPackets (Buf, 5);
    } // while

    getch ();

    // Shut down the microengine.

    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

    return;
} // main
