/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * point.c - This program demonstrates how to draw a point using CCE        *
 * Type-3 command packets.                                                  *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <i86.h>
#include <conio.h>
#include "..\..\util\regdef.h"
#include "..\..\util\defines.h"
#include "..\..\util\main.h"
#include "..\..\util\cce.h"
#include "..\util\cntx3d.h"
#include "..\util\prim.h"

#define NUM_POINTS 300

char gErrMsg [64] = {0};

extern BOOL BPPOverride; // Override default 8bpp mode in Chap 3 lib.


/****************************************************************************
 * main                                                                     *
 *  Function: Main loop.                                                    *
 *    Inputs: none                                                          *
 *   Outputs: none                                                          *
 ****************************************************************************/

void main (int argc, char *argv[])
{
    int i, exitcode = 0;
    PRIMDATA pointlist;

    printf ("Rage 128 Sample Code, Chapter 6.\n"
        "POINT.EXE\n\n"
        "This program demonstrates how to draw point primitives using Rage 128\n"
        "CCE Type-3 command packets.\n\n"
        "Mode resolution (eg 640 480) and colour depth (15, 16, 32)\n"
        "should be passed as command line arguments.\n"
        "Default resolution and colour depth is 640x480, 32bpp.\n\n"
        "Press any key to continue.\n\n");

    getch ();

    // Inspect arguments for invalid color depth.

    for (i = 1; i < argc; i++)
    {
        if ((strcmp (argv[i], "8") == 0) || (strcmp (argv[i], "24") == 0))
		{
			printf ("\nThis program does not operate at 8 or 24 bpp.");
			printf ("\nProgram terminated.");
			exit (1);
		}
	}

    // Override default 8bpp mode in Chap 3 lib.

    BPPOverride = 32;

    // First, run StartUp function to set up the application.

    R128_StartUp (argc, argv);

    // Clear the screen.

    R128_ClearScreen (BLACK);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

	// Set the default 3D context.

    R128_Init3DContext ();

	// Allocate a buffer for point vertices.

    pointlist.verts = (TLVERTEX2*) malloc (NUM_POINTS * sizeof (TLVERTEX2));
	if (pointlist.verts == NULL)
	{
        sprintf (gErrMsg, "pointlist malloc failed!!");
        exitcode = 1;
		goto exit_app;
	}

	// Set count of vertices.

    pointlist.numverts = NUM_POINTS;

    // Seed the random number generator.

	srand(rand());

	// Set the vertex parameters.

	for (i = 0; i < pointlist.numverts; i++)
	{
		pointlist.verts[i].x = rand() % R128_AdapterInfo.xres;
		pointlist.verts[i].y = rand() % R128_AdapterInfo.yres;
		pointlist.verts[i].z = 0.5f;
		pointlist.verts[i].rhw = 1.0;
		pointlist.verts[i].diffuse = (rand() % 256) | ((rand() % 256) << 8) |
			((rand() % 256) << 16);
		pointlist.verts[i].specular = 0x00000000;
		pointlist.verts[i].s2 = pointlist.verts[i].s1 =
		pointlist.verts[i].t2 = pointlist.verts[i].t1 = 0.0f;
	}

	// Draw the point list.

	ATTEMPT (R128_DrawPointList (&pointlist), "DrawPointList failed!!")

	// Wait for key press to exit.

    getch ();

exit_app:

	// Free the vertex buffer.

	if (pointlist.verts)
		free (pointlist.verts);

	// Close 3D context, shut down micro-engine and restore original mode.

	R128_Close3DContext ();
    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

	// print error message if any.

	if (exitcode == 1)
		printf ("%s\n", gErrMsg);

	exit (exitcode);
} // main


