/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * alphtest.c - Function for setting alpha testing states.                  * 
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <string.h>
#include "..\..\util\regdef.h"
#include "..\..\util\defines.h"
#include "..\..\util\main.h"
#include "..\..\util\cce.h"
#include "cntx3d.h"
#include "alphtest.h"
#include "zbuffer.h"

extern CONTEXT3D gContext3D;
extern DWORD gCommandBuf[];


/****************************************************************************
 * R128_SetAlphaTestState                                                   *
 *  Function: set an enumerated alpha testing state.                        *
 *    Inputs: eAlphaTestState - EALPHATESTSTATE enum of state to be set.	*
 *			  data - state-sepcific data to be set.							*
 *   Outputs: TRUE - successful.                                            *
 *			  FALSE - unsuccessful.											*
 ****************************************************************************/

BOOL R128_SetAlphaTestState (EALPHATESTSTATE eAlphaTestState, DWORD data)
{
	int i=0;
	DWORD tex_cntl_state;

	switch (eAlphaTestState)
	{

	// Enable alpha testing.

	case ALPHATESTSTATE_ENABLE:
		if ((BOOL)data == FALSE)
		{
			tex_cntl_state = TEX_CNTL_ALPHA_TEST_EN_OFF;
		}
		else
		{
			tex_cntl_state = TEX_CNTL_ALPHA_TEST_EN_ON;
		}

		// Set TEX_CNTL_C:ALPHA_TEST_EN field.

		gContext3D.regTEX_CNTL_C &= ~(0x00000001 << 10);
		gContext3D.regTEX_CNTL_C |= tex_cntl_state;
		gCommandBuf[i++] = CCE_PACKET0 | (TEX_CNTL_C >> 2);
		gCommandBuf[i++] = gContext3D.regTEX_CNTL_C;
		R128_CCESubmitPackets (gCommandBuf, i);
		break;

	// Set alpha testing comapre function.

	case ALPHATESTSTATE_CMP:
        switch ((ECMP)data)
		{
		case CMP_NEVER:
		case CMP_LESS:
		case CMP_LEQUAL:
		case CMP_EQUAL:
		case CMP_GREATER:
		case CMP_GEQUAL:
		case CMP_NEQUAL:
		case CMP_ALWAYS:
			break;

		default:
			return FALSE;
		}

        // Set MISC_3D_STATE_CNTL_REG:ALPHA_TEST_OP field.

        gContext3D.regMISC_3D_STATE_CNTL_REG &= ~(0x00000007 << 24);
        gContext3D.regMISC_3D_STATE_CNTL_REG |= (data << 24);
        gCommandBuf[i++] = CCE_PACKET0 | (MISC_3D_STATE_CNTL_REG >> 2);
        gCommandBuf[i++] = gContext3D.regMISC_3D_STATE_CNTL_REG;
		R128_CCESubmitPackets (gCommandBuf, i);
		break;

	// Set reference alpha value.

	case ALPHATESTSTATE_REF:

        // Set MISC_3D_STATE_CNTL_REG:REF_ALPHA field.

        gContext3D.regMISC_3D_STATE_CNTL_REG &= ~(0x000000ff);
        gContext3D.regMISC_3D_STATE_CNTL_REG |= (data & 0x000000ff);
        gCommandBuf[i++] = CCE_PACKET0 | (MISC_3D_STATE_CNTL_REG >> 2);
        gCommandBuf[i++] = gContext3D.regMISC_3D_STATE_CNTL_REG;
		R128_CCESubmitPackets (gCommandBuf, i);
		break;

	default:
		return FALSE;
	} // switch

	return TRUE;
}
