/******************************************************************************
 * fog.h																      *
 * Header file for Rage 128 Chapter 6 sample code                             *
 * Data type definitions and function declarations for fog.c.			      *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include "..\..\util\main.h"

#ifndef _FOG_H
#define _FOG_H

// Fog state enumeration.

typedef enum {
	FOGSTATE_ENABLE = 0,
	FOGSTATE_MODE,
	FOGSTATE_COLOR,
	FOGSTATE_TABLE,
	FOGSTATE_START,
	FOGSTATE_END,
	FOGSTATE_DENSITY,
	FOGSTATE_FORCE_DWORD = 0xffffffff
} EFOGSTATE;

// Fog mode enumeration.

typedef enum {
	FOGMODE_VERTEX = 0,
	FOGMODE_TABLE,
	FOGMODE_FORCE_DWORD = 0xffffffff
} EFOGMODE;

// Functions.

BOOL R128_SetFogState (EFOGSTATE efogstate, DWORD data);

#endif // _FOG_H
