/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * key.c - Functions for handling keyboard input.                           *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <bios.h>
#include "key.h"


/****************************************************************************
 * R128_GetKey                                                              *
 *  Function: Gets scan and ASCII code for pressed key.                     *
 *    Inputs: none.                                                         *
 *   Outputs: WORD - scan code in upper byte, ASCII code in lower byte.     *
 ****************************************************************************/

WORD R128_GetKey (void)
{
	if (_bios_keybrd (_KEYBRD_READY))
		return ((WORD)_bios_keybrd(_KEYBRD_READ));
	else
		return (0);
}
