/******************************************************************************
 * prim.h																      *
 * Header file for Rage 128 Chapter 6 sample code                             *
 * Data type definitions and function declarations for prim.c.			      *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include "..\..\util\main.h"
#include "..\..\util\cce.h"

#ifndef _PRIM_H
#define _PRIM_H

// Defines.

#define VC_FORMAT_TLVERTEX2		CCE_VC_FRMT_RHW |\
								CCE_VC_FRMT_DIFFUSE_ARGB |\	
								CCE_VC_FRMT_SPEC_FRGB |\
                                CCE_VC_FRMT_S_T |\
                                CCE_VC_FRMT_S2_T2;

// Vertex structure.

typedef struct {
	float x, y, z;
	float rhw;
	DWORD diffuse;
	DWORD specular;
	float s1, t1;
    float s2, t2;
} TLVERTEX2, *LPTLVERTEX2;

// Primitive data structure.

typedef struct {
    DWORD numverts;
    LPTLVERTEX2 verts;
} PRIMDATA, *LPPRIMDATA;

// Functions.

BOOL R128_DrawTriangle (LPTLVERTEX2 ptriverts);
BOOL R128_DrawTriangleList (LPPRIMDATA ptrilist);
BOOL R128_DrawTriangleStrip (LPPRIMDATA ptristrip);
BOOL R128_DrawTriangleFan (LPPRIMDATA ptrifan);
BOOL R128_DrawPointList (LPPRIMDATA ppointlist);
BOOL R128_DrawLineList (LPPRIMDATA plinelist);
BOOL R128_DrawPolyLine (LPPRIMDATA ppolyline);

#endif // _PRIM_H
