/****************************************************************************
 * rendstat.h																*
 * Header file for Rage 128 Chapter 6 sample code                           *
 * Data type definitions and function declarations for rendstat.c.			*
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include "..\..\util\regdef.h"
#include "..\..\util\cce.h"
#include "..\..\util\main.h"

#ifndef _RENDSTAT_H
#define _RENDSTAT_H

// Render state enumeration.

typedef enum {
	RENDERSTATE_SHADEMODE = 0,
    RENDERSTATE_FLATSHADEVERTEX,
	RENDERSTATE_SOLIDCOLOR,
	RENDERSTATE_DITHERMODE,
	RENDERSTATE_FRONTDIR,
	RENDERSTATE_FRONTFACE_CULL_FCN,
	RENDERSTATE_BACKFACE_CULL_FCN,
	RENDERSTATE_DSTOFFSET,
	RENDERSTATE_FORCE_DWORD = 0xffffffff
} ERENDERSTATE;

// Shading mode enumeration.

typedef enum {
	SHADE_SOLIDCOLOR = 0,
    SHADE_FLAT,
#if 0
	SHADE_FLAT_VERTEX1,
	SHADE_FLAT_VERTEX2,
	SHADE_FLAT_VERTEX3,
#endif
	SHADE_GOURAUD,
	SHADE_FORCE_DWORD = 0xffffffff
} ESHADEMODE;

// Flat shade vertex enumeration.

typedef enum {
    FLATSHADEVERTEX_D3D = 0,
    FLATSHADEVERTEX_OPENGL,
    FLATSHADEVERTEX_FORCE_DWORD = 0xffffffff
} EFLATSHADEVERTEX;

// Front face direction enumeration.

typedef enum {
	FRONTDIR_CW = 0,
	FRONTDIR_CCW,
	FRONTDIR_FORCE_DWORD = 0xffffffff
} EFRONTDIR;

// Culling function enumeration.

typedef enum {
	CULLFCN_CULL = 0,
	CULLFCN_DRAW_POINT,
	CULLFCN_DRAW_LINE,
	CULLFCN_DRAW_REV_SOLID,
	CULLFCN_FORCE_DWORD = 0xffffffff
} ECULLFCN;

// Functions.

BOOL R128_SetRenderState (ERENDERSTATE eRenderState, DWORD data);

#endif // _RENDSTAT_H


