/******************************************************************************
 * texture.h																  *
 * Header file for Rage 128 Chapter 6 sample code                             *
 * Data type definitions and function declarations for texture.c.			  *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include "..\..\util\regdef.h"
#include "..\..\util\cce.h"
#include "..\..\util\main.h"

#ifndef _TEXTURE_H
#define _TEXTURE_H

// Defines.

#define BI_RGB 0L

// Texture state enumeration.

typedef enum {
	TEXSTATE_ENABLE = 0,
	TEXSTATE_SEC_ENABLE,
	TEXSTATE_CHROMAKEY_ENABLE,
	TEXSTATE_ALPHAMASK_ENABLE,
	TEXSTATE_SELECTST, 
    TEXSTATE_SELECTW, 
	TEXSTATE_MINBLEND,
	TEXSTATE_MAGBLEND,
	TEXSTATE_MIMAP_ENABLE,
	TEXSTATE_SCLAMP_MODE,
	TEXSTATE_SWRAP_MODE,
	TEXSTATE_TCLAMP_MODE,
    TEXSTATE_TWRAP_MODE,
    TEXSTATE_PERSP_CORR_ENABLE,
	TEXSTATE_PAL_OFF,
	TEXSTATE_PSUEDO_DATATYPE,
	TEXSTATE_COMB_FNC,
	TEXSTATE_COLOR_FACTOR,
	TEXSTATE_INPUT_FACTOR,
	TEXSTATE_COMB_FNC_ALPHA,
	TEXSTATE_ALPHA_FACTOR,
	TEXSTATE_INPUT_FACTOR_ALPHA,
	TEXSTATE_BORDER_COLOR,
	TEXSTATE_TEX_LIGHT_FCN,
	TEXSTATE_ALPHA_LIGHT_FCN,
	TEXSTATE_FORCE_DWORD = 0xffffffff
} ETEXSTATE;


// Texture stage enumeration.

typedef enum {
	SELECTST_PRIM = 0,
	SELECTST_SEC,
	SELECTST_FORCE_DWORD = 0xffffffff
} ESELECTST;


// Texture w select enumeration.

typedef enum {
    SELECTW_PRIM = 0,
    SELECTW_SEC,
    SELECTW_FORCE_DWORD = 0xffffffff
} ESELECTW;


// Texture stage enumeration.

typedef enum {
	MINBLEND_NEAREST = 0,
	MINBLEND_BILINEAR,
	MINBLEND_MIPNEAREST,
	MINBLEND_MIPLINEAR,
	MINBLEND_1X1,
	MINBLEND_TRILINEAR,
	MINBLEND_FORCE_DWORD = 0xffffffff
} EMINBLEND;


// Texture filtering mode enumeration.

typedef enum {
	MAGBLEND_NEAREST = 0,
	MAGBLEND_BILINEAR,
	MAGBLEND_FORCE_DWORD = 0xffffffff
} EMAGBLEND;


// Texture addressing mode enumeration.

typedef enum {
	CLAMP_WRAP = 0,
	CLAMP_MIRROR,
	CLAMP_CLAMP,
	CLAMP_BORDER_COLOR,
	CLAMP_FORCE_DWORD = 0xffffffff
} ECLAMP;


// Texture format enumeration.

typedef enum {
	TEXFORMAT_VQ = 0,		
	TEXFORMAT_CI4,		
	TEXFORMAT_CI8,		
	TEXFORMAT_ARGB1555,	
	TEXFORMAT_RGB565,	
	TEXFORMAT_RGB888,	
	TEXFORMAT_ARGB8888,	
	TEXFORMAT_RGB332,	
	TEXFORMAT_Y8,		
	TEXFORMAT_RGB8,		
	TEXFORMAT_CI16,		
	TEXFORMAT_YUV422,	
	TEXFORMAT_YUV422_2,	
	TEXFORMAT_AYUV444 = 14,	
	TEXFORMAT_ARGB4444,	
	TEXFORMAT_FORCE_DWORD = 0xffffffff
} ETEXFORMAT;


// Texture palette enumeration.

typedef enum {
	PALETTE_EITHER = 0,
	PALETTE_1,
	PALETTE_2,
	PALETTE_FORCE_DWORD = 0xffffffff
} EPALETTE;


// Texture psuedo color enumeration.

typedef enum {
	PSUEDOCOLOR_RGB565 = 0,
	PSUEDOCOLOR_RGBA1555,
	PSUEDOCOLOR_RGBA4444,
	PSUEDOCOLOR_FORCE_DWORD = 0xffffffff
} EPSUEDOCOLOR;


// Texture combine function enumeration.

typedef enum {
	TEXCOMBFNC_DISABLE = 0,
	TEXCOMBFNC_COPY,
	TEXCOMBFNC_COPYINPUT,
	TEXCOMBFNC_MODULATE,
	TEXCOMBFNC_MODULATE2X,
	TEXCOMBFNC_MODULATE4X,
	TEXCOMBFNC_ADD,
	TEXCOMBFNC_ADDSIGNED,
	TEXCOMBFNC_BLEND_VERTEX,
	TEXCOMBFNC_BLEND_TEXTURE,
	TEXCOMBFNC_BLEND_CONSTANT,
	TEXCOMBFNC_BLEND_PREMULTIPLY,
	TEXCOMBFNC_BLEND_PREVIOUS,
	TEXCOMBFNC_BLEND_PREMULTIPLY_INVERSE,
	TEXCOMBFNC_ADDSIGNED2X,
	TEXCOMBFNC_BLEND_CONSTANTCOLOR,
	TEXCOMBFNC_FORCE_DWORD = 0xffffffff
} ETEXCOMBFNC;


// Texture color factor enumeration.

typedef enum {
	FACTOR_TEXTURECOLOR = 4,
	FACTOR_NTEXTURECOLOR,
	FACTOR_TEXTUREALPHA,
	FACTOR_NTEXTUREALPHA,
	FACTOR_FORCE_DWORD = 0xffffffff
} EFACTOR;


// Texture input factor enumeration.

typedef enum {
	INPUTFACTOR_CONSTANTCOLOR = 2,
	INPUTFACTOR_CONSTANTALPHA,
	INPUTFACTOR_INTERPCOLOR,
	INPUTFACTOR_INTERPALPHA,
	INPUTFACTOR_PREVCOLOR = 8,
	INPUTFACTOR_PREVALPHA,
	INPUTFACTOR_FORCE_DWORD = 0xffffffff
} EINPUTFACTOR;


// Texture input factor alpha enumeration.

typedef enum {
	INPUTFACTORALPHA_CONSTANTALPHA = 1,
	INPUTFACTORALPHA_INTERPALPHA,
	INPUTFACTORALPHA_PREVALPHA = 4,
	INPUTFACTORALPHA_FORCE_DWORD = 0xffffffff
} EINPUTFACTORALPHA;


// Texture information structure.

typedef struct tageTEXINFO {
	char  filename [16];	// bitmap file name.
	ETEXFORMAT Format;		// texel format enumeration.
	DWORD Flags;			// texture flags.
	DWORD Log2X;			// log2 of texture width.
	DWORD Log2Y;			// log2 of texture height.
	DWORD Pitch;			// texture pitch.
	DWORD Offset[11];		// texture addresses. 0: base map, 1 - 11: mipmaps
} TEXINFO, *LPTEXINFO;


// Windows BITMAP structures.

#include <pshpack2.h>
typedef struct tagBITMAPFILEHEADER {
    WORD bfType;
    DWORD bfSize;
    WORD bfReserved1;
    WORD bfReserved2;
    DWORD bfOffBits;
} BITMAPFILEHEADER;
#include <poppack.h>

typedef struct tagBITMAPINFOHEADER{
    DWORD biSize;
    DWORD biWidth;
    DWORD biHeight;
    WORD biPlanes;
    WORD biBitCount;
    DWORD biCompression;
    DWORD biSizeImage;
    DWORD biXPelsPerMeter;
    DWORD biYPelsPerMeter;
    DWORD biClrUsed;
    DWORD biClrImportant;
} BITMAPINFOHEADER;

// Targa header info.

#include <pshpack1.h>
typedef struct {
	BYTE idlen;			//length of optional identification sequence
	BYTE cmtype;		//indicates whether a palette is present
	BYTE imtype;		//image data type (e.g., uncompressed RGB)
	WORD cmorg;			//first palette index, if present
	WORD cmcnt;			//number of palette entries, if present
	BYTE cmsize;		//number of bits per palette entry
	WORD imxorg;		//horiz pixel coordinate of lower left of image
	WORD imyorg;		//vert pixel coordinate of lower left of image
	WORD imwidth;		//image width in pixels
	WORD imheight;		//image height in pixels
	BYTE imdepth;		//image color depth (bits per pixel)
	BYTE imdesc;		//image attribute flags
} TGAHEADERINFO;
#include <poppack.h>

// Functions.

BOOL R128_SetTexture (DWORD stage, LPTEXINFO ptexinfo);
BOOL R128_SetTextureState (DWORD stage, ETEXSTATE eTexState, DWORD data);
BOOL R128_LoadTextureBMP_ARGB8888 (const char* texfile, LPTEXINFO ptexinfo);
BOOL R128_LoadTextureTGA_ARGB8888 (const char* texfile, LPTEXINFO ptexinfo);
BOOL R128_FreeTexture (LPTEXINFO ptexinfo);

#endif // _TEXTURE_H


