/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * bitblt.c - This program demonstrates how to use Rage 128 Type-3 command  *
 * packets to blit rectangles from a source area to a destination area.     *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <conio.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"
#include "..\util\cce.h"

extern DWORD BPPOverride;


/****************************************************************************
 * main                                                                     *
 *  Function: Main loop.                                                    *
 *    Inputs: none                                                          *
 *   Outputs: none                                                          *
 ****************************************************************************/

void main (int argc, char *argv[])
{
    DWORD Buf[20];
    WORD srcx, srcy, dstx, dsty, bpp;
    int test;
    int i, j;
    _img_info IMG_DATA;

    printf ("Rage 128 Sample Code, Chapter 6.\n"
        "BITBLT.EXE\n\n"
        "This program demonstrates how to use Rage 128 Type-3 command packets\n"
        "to blit rectangles.\n\n"
        "Mode resolution (eg 640 480) and colour depth (8, 15, 16, 24, 32)\n"
        "should be passed as command line arguments.\n"
        "Default resolution and colour depth is 640x480, 8bpp.\n\n"
        "Press any key to continue.\n\n");

    getch ();

    // Set 32 BPP colour depth.

    BPPOverride = 32; 

    // First, run StartUp function to set up the application

    R128_StartUp (argc, argv);

    if (R128_AdapterInfo.xres <= 320)
    {
        R128_ShutDown ();
        printf ("\nThis program requires a resolution of at least 400x300.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    // Clear the screen

    R128_ClearScreen (BLACK);

    // Set up the source data co-ordinates.
    srcx = 0;
    srcy = R128_AdapterInfo.yres;
    bpp = R128_GetBPPValue (R128_AdapterInfo.bpp);

    // Load the source image file into offscreen memory.

    IMG_DATA = Load_Image (TRAJECTORY_RECTANGULAR, bpp, srcx, srcy);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

    i = 0;

    // Set up a rectangle packet and fill the header with packet size
    // Note that packet size is two less than total number of packets sent

    Buf[i++] = CCE_PACKET3_CNTL_BITBLT;

    // N.B. With the current microcode CCE_PACKET3_CNTL_BITBLT_MULTI
    // does exactly the same operation as CCE_PACKET3_CNTL_BITBLT,
    // i.e., the packet parameters are source-x, source-y (1st packet),
    // dest-x, dest-y (2nd packet), and width, height (3rd packet).

    // Compose GUI_CONTROL

    Buf[i++] = CCE_GC_BRUSH_NONE | CCE_GC_SRC_DSTCOLOR | ROP3_SRCCOPY |
               CCE_GC_DP_SRC_RECT | (R128_GetBPPValue (R128_AdapterInfo.bpp) << 8);

    dstx = 0;
    dsty = 0;

    // Fill rectangle data into packet

    Buf[i++] = (srcx << 16) + srcy;
    Buf[i++] = (dstx << 16) + dsty;
    Buf[i++] = (IMG_DATA.width << 16) + IMG_DATA.height;

    dstx = IMG_DATA.width;
    dsty = 0;

    // Fill rectangle data into packet

    Buf[i++] = (srcx << 16) + srcy;
    Buf[i++] = (dstx << 16) + dsty;
    Buf[i++] = (IMG_DATA.width << 16) + IMG_DATA.height;

    dstx = 0;
    dsty = IMG_DATA.height;

    // Fill rectangle data into packet

    Buf[i++] = (srcx << 16) + srcy;
    Buf[i++] = (dstx << 16) + dsty;
    Buf[i++] = (IMG_DATA.width << 16) + IMG_DATA.height;

    dstx = IMG_DATA.width;
    dsty = IMG_DATA.height;

    // Fill rectangle data into packet

    Buf[i++] = (srcx << 16) + srcy;
    Buf[i++] = (dstx << 16) + dsty;
    Buf[i++] = (IMG_DATA.width << 16) + IMG_DATA.height;

    Buf[0] |= ((i - 2) << 16);
    test = R128_CCESubmitPackets (Buf, i);

    getch ();

    // Shut down the microengine.

    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

    return;
} // main
