/******************************************************************************
 * Header file for Rage 128 Chapter 7 sample code                             *
 * Includes structures, prototypes, and globals.                              *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#ifndef _MAIN7_H
#define _MAIN7_H

// use chap6 main.h
#include "..\..\chap6\util\main.h"

// structure for bmaster.c

typedef struct
{
    unsigned long int FRAME_BUF_OFFSET;
    unsigned long int SYSTEM_MEM_ADDR;
    unsigned long int COMMAND;
    unsigned long int RESERVED;
} BM_LIST_DESCRIPTOR;

typedef struct
{
    DWORD count;
    WORD entries;
} _bm_info;

WORD R128_BMGetQueueEntries (WORD queue);
WORD R128_BMWaitForEntry (WORD queue);
void R128_BMWaitForQueueIdle (void);
DWORD R128_BMGetTimeoutCount (DWORD ticks);
WORD R128_BMGetQueueStatus (WORD queue);

extern _bm_info BM_INFO;

#endif // MAIN7_H

