/****************************************************************************
 * Rage 128 Chapter 7 sample code                                           *
 *                                                                          *
 * ov1wrfld.c - This module writes the overlay registers, based on values   *
 *              previously set in the OVERLAY_REG_FIELDS structure.         *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc. All rights reserved.            *
 ****************************************************************************/
#include "overlay.h"

void R128_WriteOverlayFields (OVERLAY_REG_FIELDS *OverlayRegFields)
{
   regw (OV0_Y_X_START, (OverlayRegFields->val_OVERLAY_X_START |
            (OverlayRegFields->val_OVERLAY_Y_START << 16)));
   regw (OV0_Y_X_END,   (OverlayRegFields->val_OVERLAY_X_END   |
            (OverlayRegFields->val_OVERLAY_Y_END   << 16)));

   regw (OV0_SCALE_CNTL,
      (((OverlayRegFields->val_OV0_PIX_EXPAND           & 0x1)  << 0 )  |
       ((OverlayRegFields->val_OV0_Y2R_TEMP             & 0x1)  << 1 )  |
       ((OverlayRegFields->val_OV0_HORZ_PICK_NEAREST    & 0x1)  << 2 )  |
       ((OverlayRegFields->val_OV0_VERT_PICK_NEAREST    & 0x1)  << 3 )  |
       ((OverlayRegFields->val_OV0_SIGNED_UV            & 0x1)  << 4 )  |
       ((OverlayRegFields->val_OV0_GAMMA_SEL            & 0x3)  << 5 )  |
       ((OverlayRegFields->val_OV0_COMCORE_SHIFT_UP_ONE & 0x1)  << 7 )  |
       ((OverlayRegFields->val_OV0_SURFACE_FORMAT       & 0xf)  << 8 )  |
       ((OverlayRegFields->val_OV0_SMART_SWITCH         & 0x1)  << 15)  |
       ((OverlayRegFields->val_OV0_BURST_PER_PLANE      & 0xff) << 16)  |
       ((OverlayRegFields->val_OV0_DOUBLE_BUFFER_REGS   & 0x1)  << 24)  |
       ((OverlayRegFields->val_OV0_IGNORE_REPEAT_FIELD  & 0x1)  << 25)  |
       ((OverlayRegFields->val_OV0_DIS_LIMIT            & 0x1)  << 27)  |
       ((OverlayRegFields->val_OV0_PROGMBL_LOAD_START   & 0x1)  << 28)  |
       ((OverlayRegFields->val_OV0_INT_EMU              & 0x1)  << 29)  |
       ((0                          & 0x1)  << 30)  |
       ((0                                      & 0x1)  << 31)) );

   regw (OV0_V_INC, ((OverlayRegFields->val_OV0_V_INC & 0x3ffff) << 8));

   regw (OV0_P1_V_ACCUM_INIT,
     (((OverlayRegFields->val_OV0_P1_MAX_LN_IN_PER_LN_OUT & 0x3)   << 0 ) |
      ((OverlayRegFields->val_OV0_P1_V_ACCUM_INIT         & 0x7ff) << 15)) );

   regw (OV0_P23_V_ACCUM_INIT,
     (((OverlayRegFields->val_OV0_P23_MAX_LN_IN_PER_LN_OUT & 0x3)  << 0 ) |
      ((OverlayRegFields->val_OV0_P23_V_ACCUM_INIT         & 0x3ff) << 15)) );

   regw (OV0_P1_BLANK_LINES_AT_TOP,
     (((OverlayRegFields->val_OV0_P1_BLNK_LN_AT_TOP_M1 & 0xfff) << 0 ) |
      ((OverlayRegFields->val_OV0_P1_ACTIVE_LINES_M1   & 0xfff) << 16)) );

   regw (OV0_P23_BLANK_LINES_AT_TOP,
     (((OverlayRegFields->val_OV0_P23_BLNK_LN_AT_TOP_M1 & 0x7ff) << 0 ) |
      ((OverlayRegFields->val_OV0_P23_ACTIVE_LINES_M1   & 0x7ff) << 16)) );

   regw (OV0_VID_BUF0_BASE_ADRS,
      (((OverlayRegFields->val_OV0_VID_BUF0_PITCH_SEL  & 0x1)       << 0 )  |
       ((OverlayRegFields->val_OV0_VID_BUF0_TILED_ADRS & 0x1)       << 1 )  |
       ((OverlayRegFields->val_OV0_VID_BUF0_BASE_ADRS  & 0x3fffff)  << 4 )  |
       ((OverlayRegFields->val_OV0_BUF0_1ST_LINE_LSBS  & 0x1f)      << 27)) );

   regw (OV0_VID_BUF1_BASE_ADRS,
      (((OverlayRegFields->val_OV0_VID_BUF1_PITCH_SEL  & 0x1)       << 0 )  |
       ((OverlayRegFields->val_OV0_VID_BUF1_TILED_ADRS & 0x1)       << 1 )  |
       ((OverlayRegFields->val_OV0_VID_BUF1_BASE_ADRS  & 0x3fffff)  << 4 )  |
       ((OverlayRegFields->val_OV0_BUF1_1ST_LINE_LSBS  & 0x1f)      << 27)) );

   regw (OV0_VID_BUF2_BASE_ADRS,
      (((OverlayRegFields->val_OV0_VID_BUF2_PITCH_SEL  & 0x1)       << 0 )  |
       ((OverlayRegFields->val_OV0_VID_BUF2_TILED_ADRS & 0x1)       << 1 )  |
       ((OverlayRegFields->val_OV0_VID_BUF2_BASE_ADRS  & 0x3fffff)  << 4 )  |
       ((OverlayRegFields->val_OV0_BUF2_1ST_LINE_LSBS  & 0x1f)      << 27)) );

   regw (OV0_VID_BUF3_BASE_ADRS,
      (((OverlayRegFields->val_OV0_VID_BUF3_PITCH_SEL  & 0x1)       << 0 )  |
       ((OverlayRegFields->val_OV0_VID_BUF3_TILED_ADRS & 0x1)       << 1 )  |
       ((OverlayRegFields->val_OV0_VID_BUF3_BASE_ADRS  & 0x3fffff)  << 4 )  |
       ((OverlayRegFields->val_OV0_BUF3_1ST_LINE_LSBS  & 0x1f)      << 27)) );

   regw (OV0_VID_BUF4_BASE_ADRS,
      (((OverlayRegFields->val_OV0_VID_BUF4_PITCH_SEL  & 0x1)       << 0 )  |
       ((OverlayRegFields->val_OV0_VID_BUF4_TILED_ADRS & 0x1)       << 1 )  |
       ((OverlayRegFields->val_OV0_VID_BUF4_BASE_ADRS  & 0x3fffff)  << 4 )  |
       ((OverlayRegFields->val_OV0_BUF4_1ST_LINE_LSBS  & 0x1f)      << 27)) );

   regw (OV0_VID_BUF5_BASE_ADRS,
      (((OverlayRegFields->val_OV0_VID_BUF5_PITCH_SEL  & 0x1)       << 0 )  |
       ((OverlayRegFields->val_OV0_VID_BUF5_TILED_ADRS & 0x1)       << 1 )  |
       ((OverlayRegFields->val_OV0_VID_BUF5_BASE_ADRS  & 0x3fffff)  << 4 )  |
       ((OverlayRegFields->val_OV0_BUF5_1ST_LINE_LSBS  & 0x1f)      << 27)) );

   regw (OV0_VID_BUF_PITCH0_VALUE,
      (((OverlayRegFields->val_OV0_PITCH0_VALUE          & 0x3fffff) << 4 )  |
       ((OverlayRegFields->val_OV0_PITCH0_SKIP_LINES     & 0x3)      << 26)  |
       ((OverlayRegFields->val_OV0_PITCH0_IN_TILES_LSBS  & 0xf)      << 28)) );

   regw (OV0_VID_BUF_PITCH1_VALUE,
      (((OverlayRegFields->val_OV0_PITCH1_VALUE          & 0x3fffff) << 4 )  |
       ((OverlayRegFields->val_OV0_PITCH1_SKIP_LINES     & 0x3)      << 26)  |
       ((OverlayRegFields->val_OV0_PITCH1_IN_TILES_LSBS  & 0xf)      << 28)) );

   regw (OV0_AUTO_FLIP_CNTRL,
      (((OverlayRegFields->val_OV0_SOFT_BUF_NUM       & 0x7) << 0 )  |
       ((OverlayRegFields->val_OV0_SOFT_BUF_ODD       & 0x1) << 4 )  |
       ((OverlayRegFields->val_OV0_SOFT_EOF_TOGGLE    & 0x1) << 6 )  |
       ((OverlayRegFields->val_OV0_VID_PORT_SELECT    & 0x3) << 8 )  |
       ((OverlayRegFields->val_OV0_P1_FIRST_LINE_EVEN & 0x1) << 16)  |
       ((OverlayRegFields->val_OV0_SHIFT_EVEN_DOWN    & 0x1) << 18)  |
       ((OverlayRegFields->val_OV0_SHIFT_ODD_DOWN     & 0x1) << 19)) );

   regw (OV0_DEINTERLACE_PATTERN, (((OverlayRegFields->val_OV0_DEINT_PAT & 0xfffff) << 0 )) );

   regw (OV0_H_INC,
      (((OverlayRegFields->val_OV0_P1_H_INC  & 0x3fff) << 0 )  |
       ((OverlayRegFields->val_OV0_P23_H_INC & 0x3fff) << 16)) );

   regw (OV0_STEP_BY,
      (((OverlayRegFields->val_OV0_P1_H_STEP_BY  & 0x7) << 0 )  |
       ((OverlayRegFields->val_OV0_P23_H_STEP_BY & 0x7) << 8)) );

   regw (OV0_P1_H_ACCUM_INIT,
      (((OverlayRegFields->val_OV0_P1_H_ACCUM_INIT & 0x1f) << 15 )  |
       ((OverlayRegFields->val_OV0_PRESHIFT_P1_TO  & 0xf)  << 28)) );

   regw (OV0_P23_H_ACCUM_INIT,
      (((OverlayRegFields->val_OV0_P23_H_ACCUM_INIT & 0x1f) << 15 )  |
       ((OverlayRegFields->val_OV0_PRESHIFT_P23_TO  & 0xf)  << 28)) );

   regw (OV0_P1_X_START_END,
      (((OverlayRegFields->val_OV0_P1_X_END    & 0x7ff) << 0 )  |
       ((OverlayRegFields->val_OV0_P1_X_START  & 0x7ff) << 16)) );
       /* Changed according to v. 1.362 */

   regw (OV0_P2_X_START_END,
      (((OverlayRegFields->val_OV0_P2_X_END    & 0x7ff) << 0 )  |
       ((OverlayRegFields->val_OV0_P2_X_START  & 0x7ff) << 16)) );
           /* Changed according to v. 1.362 */

   regw (OV0_P3_X_START_END,
      (((OverlayRegFields->val_OV0_P3_X_END    & 0x7ff) << 0 )  |
       ((OverlayRegFields->val_OV0_P3_X_START  & 0x7ff) << 16)) );
           /* Changed according to v. 1.362 */

   regw (OV0_FILTER_CNTL,
      (((OverlayRegFields->val_OV0_HC_COEF_ON_HORZ_Y  & 0x1) << 0 )  |
       ((OverlayRegFields->val_OV0_HC_COEF_ON_HORZ_UV & 0x1) << 1 )  |
       ((OverlayRegFields->val_OV0_HC_COEF_ON_VERT_Y  & 0x1) << 2 )  |
       ((OverlayRegFields->val_OV0_HC_COEF_ON_VERT_UV & 0x1) << 3 )) );

   regw (OV0_FOUR_TAP_COEF_0,
      (((OverlayRegFields->val_OV0_COEF_0_0TH_TAP & 0xf)  << 0  )  |
       ((OverlayRegFields->val_OV0_COEF_0_1ST_TAP & 0x7f) << 8  )  |
       ((OverlayRegFields->val_OV0_COEF_0_2ND_TAP & 0x7f) << 16 )  |
       ((OverlayRegFields->val_OV0_COEF_0_3RD_TAP & 0xf)  << 24 )) );

   regw (OV0_FOUR_TAP_COEF_1,
      (((OverlayRegFields->val_OV0_COEF_1_0TH_TAP & 0xf)  << 0  )  |
       ((OverlayRegFields->val_OV0_COEF_1_1ST_TAP & 0x7f) << 8  )  |
       ((OverlayRegFields->val_OV0_COEF_1_2ND_TAP & 0x7f) << 16 )  |
       ((OverlayRegFields->val_OV0_COEF_1_3RD_TAP & 0xf)  << 24 )) );

   regw (OV0_FOUR_TAP_COEF_2,
      (((OverlayRegFields->val_OV0_COEF_2_0TH_TAP & 0xf)  << 0  )  |
       ((OverlayRegFields->val_OV0_COEF_2_1ST_TAP & 0x7f) << 8  )  |
       ((OverlayRegFields->val_OV0_COEF_2_2ND_TAP & 0x7f) << 16 )  |
       ((OverlayRegFields->val_OV0_COEF_2_3RD_TAP & 0xf)  << 24 )) );

   regw (OV0_FOUR_TAP_COEF_3,
      (((OverlayRegFields->val_OV0_COEF_3_0TH_TAP & 0xf)  << 0  )  |
       ((OverlayRegFields->val_OV0_COEF_3_1ST_TAP & 0x7f) << 8  )  |
       ((OverlayRegFields->val_OV0_COEF_3_2ND_TAP & 0x7f) << 16 )  |
       ((OverlayRegFields->val_OV0_COEF_3_3RD_TAP & 0xf)  << 24 )) );

   regw (OV0_FOUR_TAP_COEF_4,
      (((OverlayRegFields->val_OV0_COEF_4_0TH_TAP & 0xf)  << 0  )  |
       ((OverlayRegFields->val_OV0_COEF_4_1ST_TAP & 0x7f) << 8  )  |
       ((OverlayRegFields->val_OV0_COEF_4_2ND_TAP & 0x7f) << 16 )  |
       ((OverlayRegFields->val_OV0_COEF_4_3RD_TAP & 0xf)  << 24 )) );

   regw (OV0_COLOR_CNTL,
      (((OverlayRegFields->val_OV0_BRIGHTNESS   & 0x7f) << 0  )  |
       ((OverlayRegFields->val_OV0_SATURATION_U & 0x1f) << 8  )  |
       ((OverlayRegFields->val_OV0_SATURATION_V & 0x1f) << 16 )) );

   regw (OV0_VIDEO_KEY_CLR, (((OverlayRegFields->val_OV0_VIDEO_KEY_CLR & 0xffffff) << 0)) );

   regw (OV0_VIDEO_KEY_MASK, (((OverlayRegFields->val_OV0_VIDEO_KEY_MSK & 0xff) << 0  )) );

   regw (OV0_GRAPHICS_KEY_CLR,
        (((OverlayRegFields->val_OV0_GRAPHICS_KEY_CLR & 0xffffffff) << 0  )) );

   regw (OV0_GRAPHICS_KEY_MASK,
    (((OverlayRegFields->val_OV0_GRAPHICS_KEY_MSK & 0xffffffff) << 0  )) );

   regw (OV0_KEY_CNTL,
        (((OverlayRegFields->val_OV0_VIDEO_KEY_FN    & 0x7) << 0 ) |
         ((OverlayRegFields->val_OV0_GRAPHICS_KEY_FN & 0x7) << 4 ) |
         ((OverlayRegFields->val_OV0_COMPARE_MIX     & 0x1) << 8 )) );

   regw (OV0_TEST,
    (((OverlayRegFields->val_OV0_SCALE_Y2R_DIS & 0x1) << 0 ) |
     ((OverlayRegFields->val_OV0_SUBPIC_ONLY   & 0x1) << 3 ) |
     ((OverlayRegFields->val_OV0_EXTSENSE     & 0x1) << 4 )) );
}

