/****************************************************************************
 * I2C.C                                                                    *
 *                                                                          *
 * Purpose:     To provide a skeleton I2C driver for implemetation on       *
 *              other I2C HW environments.                                  *
 *                                                                          *
 * Copyright (C) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "..\util\main.h"
#include "..\util\defines.h"
#include "..\util\regdef.h"

extern DWORD nacks, halts;
extern _I2C_INFO I2C_INFO;

/****************************************************************************
 * Main Program to demonstrate I2C access for the Rage 128                  *
 *  Function: The Bt8x9 decoder is addressed, and all registers are read    *
 *    Inputs: Arguments for mode spatial and colour resolution              *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void main (int argc, char *argv[])
{
    BYTE retval;
    BYTE test = 0;
    BYTE data[16];
    BYTE counter;
    _I2C_PACKET Packet;

    R128_Detect ();
    R128_FindRom ();
    R128_RegTest ();
    R128_GetPLLInfo ();

    // set up the default values.
    R128_SetI2CInfo (10000);

    // enable I2C hardware
    I2C_Enable ();

    R128_GetI2CAddressInfo ();
    GetCaptureCardType ();

    data[0] = 0x0;
    Packet.start = 1;
    Packet.stop = 1;
    Packet.number_of_bytes = 1;
    Packet.address = 0x70;
    Packet.data = data;
    counter = 0;

    do
    {
        retval = I2C_Set (&Packet);
        counter++;
    }
    while ((retval != I2C_DONE) && (counter < 5));

    // reset the decoder by writing to register 0x1F
    data[0] = 0x1F;
    data[1] = 0x00;
    Packet.start = 1;
    Packet.stop = 1;
    Packet.number_of_bytes = 2;
    Packet.address = AddressInfo.Decoder;
    counter = 0;
    do
    {
        retval = I2C_Set (&Packet);
        counter++;
    }
    while ((retval != I2C_DONE) && (counter < 5));

    if (counter >=5)
    {
        printf ("\nCould not reset video decoder.\nShutting down.");
        exit (1);
    }

    while (getch ()!=27)
    //while (!kbhit ())
    {
        // we want to set the Bt8x9 to register 'test'
        data [0] = test;
        Packet.number_of_bytes = 1;
        Packet.address = AddressInfo.Decoder;
        counter = 0;
        do
        {
            retval = I2C_Set (&Packet);
            counter++;
        }
        while ((retval != I2C_DONE) && (counter < 5));

        if (counter >=5)
        {
            printf ("\nCould not set video decoder address %2.2X.", test);
            printf ("\nShutting down.");
            exit (1);
        }

        // Now let's read the contents of register 'test' on the Bt8x9
        Packet.address = AddressInfo.Decoder | 0x1;
        Packet.number_of_bytes = 1;
        counter = 0;
        do
        {
            retval = I2C_Get (&Packet);
            counter++;
        }
        while (retval != I2C_DONE);

        if (counter >=5)
        {
            printf ("\nCould not read video decoder address %2.2X.", test);
            printf ("\nShutting down.");
            exit (1);
        }

        printf ("\nData read from register %2.2X: %2.2X", test, Packet.data[0]);
        printf ("\n");

        test += 1;
        if (test >= 0x1F) test = 0;

    }

    printf ("\n\nBoard ID: %2.2X", AddressInfo.BoardID);
    printf ("\nVideo Decoder Address: %2.2X", AddressInfo.Decoder);
    printf ("\nTuner Address: %2.2X", AddressInfo.Tuner);

    DisableDecoder ();

    I2C_Stop ();
    I2C_Disable ();

    printf ("\nNacks: %d, Halts: %d", nacks, halts);

    exit (0);
} // main ()...

