/******************************************************************************
 * defines.h file for Rage 128 Chapter 8 sample code                          *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#ifndef _DEFINES8_H
#define _DEFINES8_H

// use chapter 7 defines.h
#include "..\..\chap7\util\defines.h"

#define BT819_READ 0x89
#define BT819_WRITE 0x88
#define TDA9850 0xB4
#define AIW_BT829_READ 0x8B
#define AIW_BT829_WRITE 0x8A
#define BOARD_ID 0x70
#define TUNER_ADDRESS 0xC0

#define I2C_DONE            0x00000001
#define I2C_NACK            0x00000002
#define I2C_HALT            0x00000004
#define I2C_SOFT_RST        0x00000020
#define I2C_START           0x00000100
#define I2C_STOP            0x00000200
#define I2C_GO              0x00001000
#define I2C_DRIVE_EN        0x00000040
#define I2C_DRIVE_SEL       0x00000080
#define I2C_RECEIVE         0x00000400

#define I2C_DATA_COUNT_MASK 0x0000000F
#define I2C_ADDR_COUNT_MASK 0x00000700
#define I2C_SEL_HW          0x00000000
#define I2C_SEL_SW          0x00010000
#define I2C_EN              0x00020000

#define IGNORE_VBI 22 // skip 21 lines for VBI
#define DEC_SRC_COMPOSITE 0x1
#define DEC_SRC_SVIDEO 0x3
#define DEC_SRC_TUNER 0x2
#define CAP_MODE_CONTINUOUS 0x1
#define CAP_MODE_ONE_SHOT 0x0
#define CAP_BUF_TYPE_FIELD 0x00000000
#define CAP_BUF_TYPE_ALTERNATING 0x00000010
#define CAP_BUF_TYPE_FRAME 0x00000020
#define CAP_BUF_MODE_SINGLE 0x00000000
#define CAP_BUF_MODE_DOUBLE 0x00000080
#define CAP_BUF_MODE_TRIPLE 0x00000100
#define CAP_STREAM_FORMAT_BT 0x00000000
#define CAP_STREAM_FORMAT_CCIR656 0x00800000
#define CAP_STREAM_FORMAT_ZV 0x01000000
#define CAP_STREAM_FORMAT_VIP 0x01800000
#define CAP_HDWNS_DEC_DOWNSCALER 0x00000000
#define CAP_HDWNS_DEC_DECIMATE 0x04000000
#define CAP_VDWNS_DEC_DOWNSCALER 0x00000000
#define CAP_VDWNS_DEC_DECIMATE 0x08000000
#define CAP_VIDEO_IN_FORMAT_YVYU422 0x00000000
#define CAP_VIDEO_IN_FORMAT_VYUY422 0x20000000

#define LOW_BAND 91
#define MID_BAND 209
#define MID_HIGH_BAND 497
#define HIGH_BAND 509

#endif // _DEFINES8_H

