/******************************************************************************
 * Header file for Rage 128 Chapter 8 sample code                             *
 * Includes structures, prototypes, and globals.                              *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#ifndef _MAIN8_H
#define _MAIN8_H

// use chap7 main.h
#include "..\..\chap7\util\main.h"
#include "..\..\chap7\util\overlay.h"


#pragma pack(1)
typedef struct
{
    BYTE table_revision;
    BYTE table_size;
    BYTE tuner_type;
    BYTE audio_chip;
    BYTE product_id;
    BYTE tuner_voltage_teletext_fm;
    BYTE i2c_config;
    BYTE video_decoder_type;
    BYTE video_decoder_host_config;
    BYTE input[5];
} _MMTABLE;
#pragma pack()

typedef struct
{
    BYTE Mfactor;
    BYTE Nfactor;
    DWORD ClockRate;
    BYTE TimeLimit;
} _I2C_INFO;

typedef struct
{
    BYTE BoardID;
    BYTE Decoder;
    BYTE Tuner;
    BYTE Audio;
} _I2C_ADDRESS_INFO;

typedef struct
{
    BYTE number_of_bytes;
    BYTE address;
    BYTE *data;
    BYTE start;
    BYTE stop;
} _I2C_PACKET;

typedef struct
{
    BYTE div1;
    BYTE div2;
    BYTE control;
    BYTE band;
} _tuner_data;

typedef struct
{
    WORD channel_min;
    WORD channel_max;
    float freq_base;
    WORD increment;
} crange;

typedef struct
{
    char * name;
    WORD offset;
} _reg_name_offset;

typedef struct
{
    DWORD buf0_offset;
    DWORD buf0_even_offset;
    DWORD buf1_offset;
    DWORD buf1_even_offset;
    DWORD vbi_odd_offset;
    DWORD vbi_even_offset;
    DWORD one_shot_buf_offset;
    DWORD buf_pitch;
    DWORD width;
    DWORD height;
    DWORD input_mode;
    DWORD start_field;
    DWORD start_buf;
    DWORD buf_type;
    DWORD one_shot_mode;
    DWORD buf_mode;
    DWORD mirror_en;
    DWORD one_shot_mirror_en;
    DWORD video_signed_uv;
    DWORD horz_down;
    DWORD vert_down;
    DWORD stream_format;
    DWORD hdwns_dec;
    DWORD vdwns_dec;
    DWORD video_in_format;
} CAPTURE_DESCRIPTOR;

// Prototypes

// Functions in I2CUTIL.C
void I2C_Disable (void);
void I2C_Enable (void);
void I2C_Stop (void);
void I2C_Reset (void);
BYTE I2C_Set (_I2C_PACKET *Packet);
BYTE I2C_Get (_I2C_PACKET *Packet);
BYTE I2C_WaitForAck (void);
void R128_SetI2CInfo (DWORD clock_rate);

// Functions in CAPUTIL.C
void R128_InitCapture (CAPTURE_DESCRIPTOR *cap);
void R128_InitCaptureDescriptor (CAPTURE_DESCRIPTOR *cap);
void R128_SetCaptureConfig (CAPTURE_DESCRIPTOR *cap);
void R128_EnableCapture (void);
void R128_DisableCapture (void);

// Functions in TUNER.C
void R128_SetTunerChannel (WORD channel);

// Functions in DECODER.C
void R128_SetDecoderSource (BYTE src);
void R128_SetDecoderDefaults (BYTE format, BYTE input);
void R128_SetDecoderFormat (BYTE fmt);

// Functions in CH8LIB.C
void ReadOverlayRegs (void);
void ReadBTRegs (void);
void ReadTunerRegs (void);
void ReadCaptureRegs (void);
void ReadOverlayRegs (void);
void R128_GetMMTable (_MMTABLE *mmtable);
void R128_SetOverlayDetailedSurface (void);
void ReadRTRegs (void);
void ReadRT_VINregs (void);
void ReadRTFields (void);
void R128_GetI2CAddressInfo (void);
void GetCaptureCardType (void);
void EnableDecoder(void);
void DisableDecoder (void);
BYTE R128_IsTVTunerInstalled (void);

extern _I2C_ADDRESS_INFO AddressInfo;
extern OVERLAY_DESCRIPTOR OverlayDescriptor;
extern OVERLAY_REG_FIELDS OverlayRegFields;

#endif // MAIN8_H

