/******************************************************************************
 * regdef.h file for Rage 128 Chapter 8 sample code                           *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#ifndef _REGDEF8_H
#define _REGDEF8_H

// use chapter 7 regdef.h
#include "..\..\chap7\util\regdef.h"

#define	I2C_CNTL_0								   0x0090
#define I2C_DATA								   0x0098


#define AMCGPIO_MASK								0x0194
#define	AMCGPIO_A_REG								0x01A0


#if 0
#define VIPH_CH0_DATA                              0x0c00
#define VIPH_CH1_DATA                              0x0c04
#define VIPH_CH2_DATA                              0x0c08
#define VIPH_CH3_DATA                              0x0c0c
#define VIPH_CH0_ADDR                              0x0c10
#define VIPH_CH1_ADDR                              0x0c14
#define VIPH_CH2_ADDR                              0x0c18
#define VIPH_CH3_ADDR                              0x0c1c
#define VIPH_CH0_SBCNT                             0x0c20
#define VIPH_CH1_SBCNT                             0x0c24
#define VIPH_CH2_SBCNT                             0x0c28
#define VIPH_CH3_SBCNT                             0x0c2c
#define VIPH_CH0_ABCNT                             0x0c30
#define VIPH_CH1_ABCNT                             0x0c34
#define VIPH_CH2_ABCNT                             0x0c38
#define VIPH_CH3_ABCNT                             0x0c3c
#define VIPH_CONTROL                               0x0c40
#define VIPH_DV_LAT                                0x0c44
#define VIPH_BM_CHUNK                              0x0c48
#define VIPH_DV_INT                                0x0c4c
#define VIPH_TIMEOUT_STAT                          0x0c50

#define VIPH_REG_DATA                               0x0084
#define VIPH_REG_ADDR                               0x0080


// Address Space Ripper Registers (VIP Access)

#define VIP_VIP_VENDOR_DEVICE_ID                 0x0000
#define VIP_VIP_SUB_VENDOR_DEVICE_ID             0x0004
#define VIP_VIP_COMMAND_STATUS                   0x0008
#define VIP_VIP_REVISION_ID                      0x000c
#define VIP_HW_DEBUG                             0x0010
#define VIP_SW_SCRATCH                           0x0014
#define VIP_I2C_CNTL_0                           0x0020
#define VIP_I2C_CNTL_1                           0x0024
#define VIP_I2C_DATA                             0x0028
#define VIP_INT_CNTL                             0x002c
#define VIP_GPIO_INOUT                           0x0030
#define VIP_GPIO_CNTL                            0x0034
#define VIP_CLKOUT_GPIO_CNTL                     0x0038
#define VIP_RIPINTF_PORT_CNTL                    0x003c
#define VIP_ADC_CNTL                             0x0400
#define VIP_ADC_DEBUG                            0x0404
#define VIP_STANDARD_SELECT                      0x0408
#define VIP_THERMO2BIN_STATUS                    0x040c
#define VIP_COMB_CNTL0                           0x0440
#define VIP_COMB_CNTL1                           0x0444
#define VIP_COMB_CNTL2                           0x0448
#define VIP_COMB_LINE_LENGTH                     0x044c
#define VIP_NOISE_CNTL0                          0x0450
#define VIP_HS_PLINE                             0x0480
#define VIP_HS_DTOINC                            0x0484
#define VIP_HS_PLLGAIN                           0x0488
#define VIP_HS_MINMAXWIDTH                       0x048c
#define VIP_HS_GENLOCKDELAY                      0x0490
#define VIP_HS_WINDOW_LIMIT                      0x0494
#define VIP_HS_WINDOW_OC_SPEED                   0x0498
#define VIP_HS_PULSE_WIDTH                       0x049c
#define VIP_HS_PLL_ERROR                         0x04a0
#define VIP_HS_PLL_FS_PATH                       0x04a4
#define VIP_SG_BLACK_GATE                        0x04c0
#define VIP_SG_SYNCTIP_GATE                      0x04c4
#define VIP_SG_UVGATE_GATE                       0x04c8
#define VIP_LP_AGC_CLAMP_CNTL0                   0x0500
#define VIP_LP_AGC_CLAMP_CNTL1                   0x0504
#define VIP_LP_BRIGHTNESS                        0x0508
#define VIP_LP_CONTRAST                          0x050c
#define VIP_LP_SLICE_LIMIT                       0x0510
#define VIP_LP_WPA_CNTL0                         0x0514
#define VIP_LP_WPA_CNTL1                         0x0518
#define VIP_LP_BLACK_LEVEL                       0x051c
#define VIP_LP_SLICE_LEVEL                       0x0520
#define VIP_LP_SYNCTIP_LEVEL                     0x0524
#define VIP_LP_VERT_LOCKOUT                      0x0528
#define VIP_VS_DETECTOR_CNTL                     0x0540
#define VIP_VS_BLANKING_CNTL                     0x0544
#define VIP_VS_FIELD_ID_CNTL                     0x0548
#define VIP_VS_COUNTER_CNTL                      0x054c
#define VIP_VS_FRAME_TOTAL                       0x0550
#define VIP_VS_LINE_COUNT                        0x0554
#define VIP_CP_PLL_CNTL0                         0x0580
#define VIP_CP_PLL_CNTL1                         0x0584
#define VIP_CP_HUE_CNTL                          0x0588
#define VIP_CP_BURST_GAIN                        0x058c
#define VIP_CP_AGC_CNTL                          0x0590
#define VIP_CP_ACTIVE_GAIN                       0x0594
#define VIP_CP_PLL_STATUS0                       0x0598
#define VIP_CP_PLL_STATUS1                       0x059c
#define VIP_CP_PLL_STATUS2                       0x05a0
#define VIP_CP_PLL_STATUS3                       0x05a4
#define VIP_CP_PLL_STATUS4                       0x05a8
#define VIP_CP_PLL_STATUS5                       0x05ac
#define VIP_CP_PLL_STATUS6                       0x05b0
#define VIP_CP_PLL_STATUS7                       0x05b4
#define VIP_CP_DEBUG_FORCE                       0x05b8
#define VIP_CP_VERT_LOCKOUT                      0x05bc
#define VIP_H_ACTIVE_WINDOW                      0x05c0
#define VIP_V_ACTIVE_WINDOW                      0x05c4
#define VIP_H_VBI_WINDOW                         0x05c8
#define VIP_V_VBI_WINDOW                         0x05cc
#define VIP_VBI_CONTROL                          0x05d0
#define VIP_DECODER_DEBUG_CNTL                   0x05d4
#define VIP_SINGLE_STEP_DATA                     0x05d8
#define VIP_MASTER_CNTL                          0x0040
#define VIP_RGB_CNTL                             0x0048
#define VIP_CLKOUT_CNTL                          0x004c
#define VIP_SYNC_CNTL                            0x0050
#define VIP_I2C_CNTL                             0x0054
#define VIP_HTOTAL                               0x0080
#define VIP_HDISP                                0x0084
#define VIP_HSIZE                                0x0088
#define VIP_HSTART                               0x008c
#define VIP_HCOUNT                               0x0090
#define VIP_VTOTAL                               0x0094
#define VIP_VDISP                                0x0098
#define VIP_VCOUNT                               0x009c
#define VIP_VFTOTAL                              0x00a0
#define VIP_DFCOUNT                              0x00a4
#define VIP_DFRESTART                            0x00a8
#define VIP_DHRESTART                            0x00ac
#define VIP_DVRESTART                            0x00b0
#define VIP_SYNC_SIZE                            0x00b4
#define VIP_TV_PLL_FINE_CNTL                     0x00b8
#define VIP_CRT_PLL_FINE_CNTL                    0x00bc
#define VIP_TV_PLL_CNTL                          0x00c0
#define VIP_CRT_PLL_CNTL                         0x00c4
#define VIP_PLL_CNTL0                            0x00c8
#define VIP_PLL_TEST_CNTL                        0x00cc
#define VIP_CLOCK_SEL_CNTL                       0x00d0
#define VIP_VIN_PLL_CNTL                         0x00d4
#define VIP_VIN_PLL_FINE_CNTL                    0x00d8
#define VIP_AUD_PLL_CNTL                         0x00e0
#define VIP_AUD_PLL_FINE_CNTL                    0x00e4
#define VIP_AUD_CLK_DIVIDERS                     0x00e8
#define VIP_AUD_DTO_INCREMENTS                   0x00ec
#define VIP_L54_PLL_CNTL                         0x00f0
#define VIP_L54_PLL_FINE_CNTL                    0x00f4
#define VIP_L54_DTO_INCREMENTS                   0x00f8
#define VIP_PLL_CNTL1                            0x00fc
#define VIP_FRAME_LOCK_CNTL                      0x0100
#define VIP_SYNC_LOCK_CNTL                       0x0104
#define VIP_TVO_SYNC_PAT_ACCUM                   0x0108
#define VIP_TVO_SYNC_THRESHOLD                   0x010c
#define VIP_TVO_SYNC_PAT_EXPECT                  0x0110
#define VIP_DELAY_ONE_MAP_A                      0x0114
#define VIP_DELAY_ONE_MAP_B                      0x0118
#define VIP_DELAY_ZERO_MAP_A                     0x011c
#define VIP_DELAY_ZERO_MAP_B                     0x0120
#define VIP_TVO_DATA_DELAY_A                     0x0140
#define VIP_TVO_DATA_DELAY_B                     0x0144
#define VIP_HOST_READ_DATA                       0x0180
#define VIP_HOST_WRITE_DATA                      0x0184
#define VIP_HOST_RD_WT_CNTL                      0x0188
#define VIP_VSCALER_CNTL1                        0x01c0
#define VIP_TIMING_CNTL                          0x01c4
#define VIP_VSCALER_CNTL2                        0x01c8
#define VIP_Y_FALL_CNTL                          0x01cc
#define VIP_Y_RISE_CNTL                          0x01d0
#define VIP_Y_SAW_TOOTH_CNTL                     0x01d4
#define VIP_UPSAMP_AND_GAIN_CNTL                 0x01e0
#define VIP_GAIN_LIMIT_SETTINGS                  0x01e4
#define VIP_LINEAR_GAIN_SETTINGS                 0x01e8
#define VIP_MODULATOR_CNTL1                      0x0200
#define VIP_MODULATOR_CNTL2                      0x0204
#define VIP_MV_MODE_CNTL                         0x0208
#define VIP_MV_STRIPE_CNTL                       0x020c
#define VIP_MV_LEVEL_CNTL1                       0x0210
#define VIP_MV_LEVEL_CNTL2                       0x0214
#define VIP_PRE_DAC_MUX_CNTL                     0x0240
#define VIP_TV_DAC_CNTL                          0x0280
#define VIP_CRC_CNTL                             0x02c0
#define VIP_VIDEO_PORT_SIG                       0x02c4
#define VIP_VBI_CC_CNTL                          0x02c8
#define VIP_VBI_EDS_CNTL                         0x02cc
#define VIP_VBI_20BIT_CNTL                       0x02d0
#define VIP_VBI_DTO_CNTL                         0x02d4
#define VIP_VBI_LEVEL_CNTL                       0x02d8
#define VIP_UV_ADR                               0x0300
#define VIP_MV_STATUS                            0x0330
#define VIP_UPSAMP_COEFF0_0                      0x0340
#define VIP_UPSAMP_COEFF0_1                      0x0344
#define VIP_UPSAMP_COEFF0_2                      0x0348
#define VIP_UPSAMP_COEFF1_0                      0x034c
#define VIP_UPSAMP_COEFF1_1                      0x0350
#define VIP_UPSAMP_COEFF1_2                      0x0354
#define VIP_UPSAMP_COEFF2_0                      0x0358
#define VIP_UPSAMP_COEFF2_1                      0x035c
#define VIP_UPSAMP_COEFF2_2                      0x0360
#define VIP_UPSAMP_COEFF3_0                      0x0364
#define VIP_UPSAMP_COEFF3_1                      0x0368
#define VIP_UPSAMP_COEFF3_2                      0x036c
#define VIP_UPSAMP_COEFF4_0                      0x0370
#define VIP_UPSAMP_COEFF4_1                      0x0374
#define VIP_UPSAMP_COEFF4_2                      0x0378
#define VIP_TV_DTO_INCREMENTS                    0x0390
#define VIP_CRT_DTO_INCREMENTS                   0x0394
#define VIP_VSYNC_DIFF_CNTL                      0x03a0
#define VIP_VSYNC_DIFF_LIMITS                    0x03a4
#define VIP_VSYNC_DIFF_RD_DATA                   0x03a8
#define VIP_SCALER_IN_WINDOW                     0x0618
#define VIP_SCALER_OUT_WINDOW                    0x061c
#define VIP_H_SCALER_CONTROL                     0x0600
#define VIP_V_SCALER_CONTROL                     0x0604
#define VIP_V_DEINTERLACE_CONTROL                0x0608
#define VIP_VBI_SCALER_CONTROL                   0x060c
#define VIP_DVS_PORT_CTRL                        0x0610
#define VIP_DVS_PORT_READBACK                    0x0614
#define VIP_FIFOA_CONFIG                         0x0800
#define VIP_FIFOB_CONFIG                         0x0804
#define VIP_FIFOC_CONFIG                         0x0808
#define VIP_SPDIF_PORT_CNTL                      0x080c
#define VIP_SPDIF_CHANNEL_STAT                   0x0810
#define VIP_SPDIF_AC3_PREAMBLE                   0x0814
#define VIP_I2S_TRANSMIT_CNTL                    0x0818
#define VIP_I2S_RECEIVE_CNTL                     0x081c
#define VIP_SPDIF_TX_CNT_REG                     0x0820
#define VIP_IIS_TX_CNT_REG                       0x0824
#endif


#endif // _REGDEF8_H

