/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.combinationlookup;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupData;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupMeta;
import org.pentaho.di.trans.steps.combinationlookup.Messages;

public class CombinationLookup
extends BaseStep
implements StepInterface {
    private static final int CREATION_METHOD_AUTOINC = 1;
    private static final int CREATION_METHOD_SEQUENCE = 2;
    private static final int CREATION_METHOD_TABLEMAX = 3;
    private int techKeyCreation;
    private CombinationLookupMeta meta = (CombinationLookupMeta)this.getStepMeta().getStepMetaInterface();
    private CombinationLookupData data;

    public CombinationLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (CombinationLookupData)stepDataInterface;
    }

    private void setTechKeyCreation(int method) {
        this.techKeyCreation = method;
    }

    private int getTechKeyCreation() {
        return this.techKeyCreation;
    }

    private void determineTechKeyCreation() {
        String keyCreation = this.meta.getTechKeyCreation();
        if (this.meta.getDatabaseMeta().supportsAutoinc() && CombinationLookupMeta.CREATION_METHOD_AUTOINC.equals(keyCreation)) {
            this.setTechKeyCreation(1);
        } else if (this.meta.getDatabaseMeta().supportsSequences() && CombinationLookupMeta.CREATION_METHOD_SEQUENCE.equals(keyCreation)) {
            this.setTechKeyCreation(2);
        } else {
            this.setTechKeyCreation(3);
        }
    }

    private Long lookupInCache(RowMetaInterface rowMeta, Object[] row) {
        if (this.meta.getCacheSize() == -1) {
            return null;
        }
        Long tk = this.data.cache.get(new RowMetaAndData(rowMeta, row));
        return tk;
    }

    private void addToCache(RowMetaInterface rowMeta, Object[] row, Long tk) throws KettleValueException {
        if (this.meta.getCacheSize() == -1) {
            return;
        }
        this.data.cache.put(new RowMetaAndData(rowMeta, row), tk);
        int tenPercent = this.meta.getCacheSize() / 10;
        if (this.meta.getCacheSize() > 0 && this.data.cache.size() > this.meta.getCacheSize() + tenPercent) {
            Long value;
            RowMetaAndData key;
            int i;
            ArrayList<RowMetaAndData> keys = new ArrayList<RowMetaAndData>(this.data.cache.keySet());
            int sizeBefore = keys.size();
            ArrayList<Long> samples = new ArrayList<Long>();
            int stepsize = keys.size() / 5;
            if (stepsize < 1) {
                stepsize = 1;
            }
            for (i = 0; i < keys.size(); i += stepsize) {
                key = (RowMetaAndData)keys.get(i);
                value = this.data.cache.get(key);
                if (value == null) continue;
                samples.add(value);
            }
            Collections.sort(samples);
            this.data.smallestCacheKey = samples.size() > 1 ? ((Long)samples.get(1)).longValue() : ((Long)samples.get(0)).longValue();
            for (i = 0; i < keys.size(); ++i) {
                key = (RowMetaAndData)keys.get(i);
                value = this.data.cache.get(key);
                if (value == null || value > this.data.smallestCacheKey) continue;
                this.data.cache.remove(key);
            }
            int sizeAfter = this.data.cache.size();
            this.logDetailed("Reduced the lookup cache from " + sizeBefore + " to " + sizeAfter + " rows.");
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Cache store: key=" + rowMeta.getString(row) + "    key=" + tk);
        }
    }

    private boolean isAutoIncrement() {
        return this.techKeyCreation == 1;
    }

    private Object[] lookupValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        int i;
        Long val_key = null;
        Long val_hash = null;
        Object[] hashRow = null;
        Object[] lookupRow = new Object[this.data.lookupRowMeta.size()];
        int lookupIndex = 0;
        if (this.meta.useHash() || this.meta.getCacheSize() >= 0) {
            hashRow = new Object[this.data.hashRowMeta.size()];
            for (i = 0; i < this.meta.getKeyField().length; ++i) {
                hashRow[i] = row[this.data.keynrs[i]];
            }
            if (this.meta.useHash()) {
                val_hash = new Long(this.data.hashRowMeta.oldXORHashCode(hashRow));
                lookupRow[lookupIndex] = val_hash;
                ++lookupIndex;
            }
        }
        for (i = 0; i < this.meta.getKeyField().length; ++i) {
            lookupRow[lookupIndex] = row[this.data.keynrs[i]];
            lookupRow[++lookupIndex] = row[this.data.keynrs[i]];
            ++lookupIndex;
        }
        val_key = this.lookupInCache(this.data.hashRowMeta, hashRow);
        if (val_key == null) {
            this.data.db.setValues(this.data.lookupRowMeta, lookupRow, this.data.prepStatementLookup);
            Object[] add = this.data.db.getLookup(this.data.prepStatementLookup);
            this.incrementLinesInput();
            if (add == null) {
                switch (this.getTechKeyCreation()) {
                    case 3: {
                        val_key = this.data.db.getNextValue(this.getTransMeta().getCounters(), this.data.realSchemaName, this.data.realTableName, this.meta.getTechnicalKeyField());
                        break;
                    }
                    case 1: {
                        val_key = new Long(0L);
                        break;
                    }
                    case 2: {
                        val_key = this.data.db.getNextSequenceValue(this.data.realSchemaName, this.meta.getSequenceFrom(), this.meta.getTechnicalKeyField());
                        if (val_key == null || !this.log.isRowLevel()) break;
                        this.logRowlevel(Messages.getString("CombinationLookup.Log.FoundNextSequenceValue") + val_key.toString());
                    }
                }
                val_key = this.combiInsert(rowMeta, row, val_key, val_hash);
                this.incrementLinesOutput();
                if (this.log.isRowLevel()) {
                    this.logRowlevel(Messages.getString("CombinationLookup.Log.AddedDimensionEntry") + val_key);
                }
                this.addToCache(this.data.hashRowMeta, hashRow, val_key);
            } else {
                val_key = this.data.db.getReturnRowMeta().getInteger(add, 0);
                this.addToCache(this.data.hashRowMeta, hashRow, val_key);
            }
        }
        Object[] outputRow = new Object[this.data.outputRowMeta.size()];
        int outputIndex = 0;
        if (this.meta.replaceFields()) {
            for (int i2 = 0; i2 < rowMeta.size(); ++i2) {
                if (this.data.removeField[i2]) continue;
                outputRow[outputIndex] = row[i2];
                ++outputIndex;
            }
        } else {
            for (outputIndex = 0; outputIndex < rowMeta.size(); ++outputIndex) {
                outputRow[outputIndex] = row[outputIndex];
            }
        }
        outputRow[outputIndex] = val_key;
        return outputRow;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.realSchemaName, this.data.realTableName);
            this.determineTechKeyCreation();
            this.data.keynrs = new int[this.meta.getKeyField().length];
            for (i = 0; i < this.meta.getKeyField().length; ++i) {
                this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyField()[i]);
                if (this.data.keynrs[i] >= 0) continue;
                throw new KettleStepException(Messages.getString("CombinationLookup.Exception.FieldNotFound", this.meta.getKeyField()[i]));
            }
            this.data.removeField = new boolean[this.getInputRowMeta().size()];
            for (i = 0; i < this.getInputRowMeta().size(); ++i) {
                ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(i);
                int idx = Const.indexOfString((String)valueMeta.getName(), (String[])this.meta.getKeyField());
                this.data.removeField[i] = idx >= 0;
            }
            this.data.hashRowMeta = new RowMeta();
            for (i = 0; i < this.meta.getKeyField().length; ++i) {
                this.data.hashRowMeta.addValueMeta(this.getInputRowMeta().getValueMeta(this.data.keynrs[i]));
            }
            this.setCombiLookup(this.getInputRowMeta());
        }
        try {
            Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
            this.putRow(this.data.outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(Messages.getString("CombinationLookup.Log.LineNumber") + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError(Messages.getString("CombinationLookup.Log.ErrorInStepRunning") + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public void setCombiLookup(RowMetaInterface inputRowMeta) throws KettleDatabaseException {
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        String sql = "";
        this.data.lookupRowMeta = new RowMeta();
        sql = sql + "SELECT " + databaseMeta.quoteField(this.meta.getTechnicalKeyField()) + Const.CR;
        sql = sql + "FROM " + this.data.schemaTable + Const.CR;
        sql = sql + "WHERE ";
        boolean comma = false;
        if (this.meta.useHash()) {
            sql = sql + databaseMeta.quoteField(this.meta.getHashField()) + " = ? " + Const.CR;
            comma = true;
            this.data.lookupRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getHashField(), 5));
        } else {
            sql = sql + "( ( ";
        }
        for (int i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (comma) {
                sql = sql + " AND ( ( ";
            } else {
                comma = true;
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ? ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            this.data.lookupRowMeta.addValueMeta(inputRowMeta.getValueMeta(this.data.keynrs[i]));
            sql = sql + " IS NULL AND ";
            sql = databaseMeta.getDatabaseType() == 6 || databaseMeta.getDatabaseType() == 34 ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
            this.data.lookupRowMeta.addValueMeta(inputRowMeta.getValueMeta(this.data.keynrs[i]).clone());
            sql = sql + " ) )";
            sql = sql + Const.CR;
        }
        try {
            if (this.log.isDebug()) {
                this.logDebug("preparing combi-lookup statement:" + Const.CR + sql);
            }
            this.data.prepStatementLookup = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
            if (databaseMeta.supportsSetMaxRows()) {
                this.data.prepStatementLookup.setMaxRows(1);
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare combi-lookup statement", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long combiInsert(RowMetaInterface rowMeta, Object[] row, Long val_key, Long val_crc) throws KettleDatabaseException {
        String debug = "Combination insert";
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        try {
            if (this.data.prepStatementInsert == null) {
                int i;
                debug = "First: construct prepared statement";
                this.data.insertRowMeta = new RowMeta();
                String sql = "";
                sql = sql + "INSERT INTO " + this.data.schemaTable + "( ";
                boolean comma = false;
                if (!this.isAutoIncrement()) {
                    sql = sql + databaseMeta.quoteField(this.meta.getTechnicalKeyField());
                    this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getTechnicalKeyField(), 5));
                    comma = true;
                } else if (databaseMeta.needsPlaceHolder()) {
                    sql = sql + "0";
                    this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getTechnicalKeyField(), 5));
                    comma = true;
                }
                if (this.meta.useHash()) {
                    if (comma) {
                        sql = sql + ", ";
                    }
                    sql = sql + databaseMeta.quoteField(this.meta.getHashField());
                    this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getHashField(), 5));
                    comma = true;
                }
                if (!Const.isEmpty((String)this.meta.getLastUpdateField())) {
                    if (comma) {
                        sql = sql + ", ";
                    }
                    sql = sql + databaseMeta.quoteField(this.meta.getLastUpdateField());
                    this.data.insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getLastUpdateField(), 3));
                    comma = true;
                }
                for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
                    if (comma) {
                        sql = sql + ", ";
                    }
                    sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
                    this.data.insertRowMeta.addValueMeta(rowMeta.getValueMeta(this.data.keynrs[i]));
                    comma = true;
                }
                sql = sql + ") VALUES (";
                comma = false;
                if (!this.isAutoIncrement()) {
                    sql = sql + '?';
                    comma = true;
                }
                if (this.meta.useHash()) {
                    if (comma) {
                        sql = sql + ',';
                    }
                    sql = sql + '?';
                    comma = true;
                }
                if (!Const.isEmpty((String)this.meta.getLastUpdateField())) {
                    if (comma) {
                        sql = sql + ',';
                    }
                    sql = sql + '?';
                    comma = true;
                }
                for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
                    if (comma) {
                        sql = sql + ',';
                    } else {
                        comma = true;
                    }
                    sql = sql + '?';
                }
                String sqlStatement = sql = sql + " )";
                try {
                    debug = "First: prepare statement";
                    if (this.isAutoIncrement()) {
                        this.logDetailed("SQL with return keys: " + sqlStatement);
                        this.data.prepStatementInsert = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sqlStatement), 1);
                    } else {
                        this.logDetailed("SQL without return keys: " + sqlStatement);
                        this.data.prepStatementInsert = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sqlStatement));
                    }
                }
                catch (SQLException ex) {
                    throw new KettleDatabaseException("Unable to prepare combi insert statement : " + Const.CR + sqlStatement, (Throwable)ex);
                }
                catch (Exception ex) {
                    throw new KettleDatabaseException("Unable to prepare combi insert statement : " + Const.CR + sqlStatement, (Throwable)ex);
                }
            }
            debug = "Create new insert row rins";
            Object[] insertRow = new Object[this.data.insertRowMeta.size()];
            int insertIndex = 0;
            if (!this.isAutoIncrement()) {
                insertRow[insertIndex] = val_key;
                ++insertIndex;
            }
            if (this.meta.useHash()) {
                insertRow[insertIndex] = val_crc;
                ++insertIndex;
            }
            if (!Const.isEmpty((String)this.meta.getLastUpdateField())) {
                insertRow[insertIndex] = new Date();
                ++insertIndex;
            }
            for (int i = 0; i < this.data.keynrs.length; ++insertIndex, ++i) {
                insertRow[insertIndex] = row[this.data.keynrs[i]];
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel("rins=" + this.data.insertRowMeta.getString(insertRow));
            }
            debug = "Set values on insert";
            this.data.db.setValues(this.data.insertRowMeta, insertRow, this.data.prepStatementInsert);
            debug = "Insert row";
            this.data.db.insertRow(this.data.prepStatementInsert);
            debug = "Retrieve key";
            if (!this.isAutoIncrement()) return val_key;
            ResultSet keys = null;
            try {
                try {
                    keys = this.data.prepStatementInsert.getGeneratedKeys();
                    if (!keys.next()) throw new KettleDatabaseException("Unable to retrieve auto-increment of combi insert key : " + this.meta.getTechnicalKeyField() + ", no fields in resultset");
                    val_key = new Long(keys.getLong(1));
                    Object var12_17 = null;
                }
                catch (SQLException ex) {
                    throw new KettleDatabaseException("Unable to retrieve auto-increment of combi insert key : " + this.meta.getTechnicalKeyField(), (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                try {
                    if (keys == null) throw throwable;
                    keys.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new KettleDatabaseException("Unable to retrieve auto-increment of combi insert key : " + this.meta.getTechnicalKeyField(), (Throwable)ex);
                }
            }
            try {}
            catch (SQLException ex) {
                throw new KettleDatabaseException("Unable to retrieve auto-increment of combi insert key : " + this.meta.getTechnicalKeyField(), (Throwable)ex);
            }
            if (keys == null) return val_key;
            keys.close();
            return val_key;
        }
        catch (Exception e) {
            this.logError(Const.getStackTracker((Throwable)e));
            throw new KettleDatabaseException("Unexpected error in combination insert in part [" + debug + "] : " + e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface sii, StepDataInterface sdi) {
        if (super.init(sii, sdi)) {
            this.data.realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
            this.data.realTableName = this.environmentSubstitute(this.meta.getTablename());
            this.data.cache = this.meta.getCacheSize() > 0 ? new HashMap<RowMetaAndData, Long>((int)((double)this.meta.getCacheSize() * 1.5)) : new HashMap<RowMetaAndData, Long>();
            this.data.db = new Database(this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("CombinationLookup.Log.ConnectedToDB"));
                }
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (KettleDatabaseException dbe) {
                this.logError(Messages.getString("CombinationLookup.Log.UnableToConnectDB") + dbe.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block9: {
            this.meta = (CombinationLookupMeta)smi;
            this.data = (CombinationLookupData)sdi;
            try {
                block8: {
                    try {
                        if (this.data.db.isAutoCommit()) break block8;
                        if (this.getErrors() == 0L) {
                            this.data.db.commit();
                        } else {
                            this.data.db.rollback();
                        }
                    }
                    catch (KettleDatabaseException e) {
                        this.logError(Messages.getString("CombinationLookup.Log.UnexpectedError") + " : " + e.toString());
                        Object var5_4 = null;
                        if (this.data.db != null) {
                            this.data.db.disconnect();
                        }
                        break block9;
                    }
                }
                Object var5_3 = null;
                if (this.data.db == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
                throw throwable;
            }
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

