/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class RepositoryPolicy
implements Serializable,
Cloneable,
InputLocationTracker {
    private String enabled;
    private String updatePolicy;
    private String checksumPolicy;
    private Map<Object, InputLocation> locations;

    public RepositoryPolicy clone() {
        try {
            RepositoryPolicy copy2 = (RepositoryPolicy)super.clone();
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public String getEnabled() {
        return this.enabled;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public boolean isEnabled() {
        return this.enabled != null ? Boolean.parseBoolean(this.enabled) : true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = String.valueOf(enabled);
    }
}

