/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ir.ArgumentsNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;

public class NewArrayNode
extends ArgumentsNode {
    private boolean initialize;

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public boolean getInitialize() {
        return this.initialize;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitNewArray(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (ExpressionNode argumentNode : this.getArgumentNodes()) {
            argumentNode.visit(irTreeVisitor, scope);
        }
    }

    public NewArrayNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.initialize) {
            methodWriter.push(this.getArgumentNodes().size());
            methodWriter.newArray(MethodWriter.getType(this.getExpressionType().getComponentType()));
            for (int index = 0; index < this.getArgumentNodes().size(); ++index) {
                ExpressionNode argumentNode = this.getArgumentNodes().get(index);
                methodWriter.dup();
                methodWriter.push(index);
                argumentNode.write(classWriter, methodWriter, writeScope);
                methodWriter.arrayStore(MethodWriter.getType(this.getExpressionType().getComponentType()));
            }
        } else {
            for (ExpressionNode argumentNode : this.getArgumentNodes()) {
                argumentNode.write(classWriter, methodWriter, writeScope);
            }
            if (this.getArgumentNodes().size() > 1) {
                methodWriter.visitMultiANewArrayInsn(MethodWriter.getType(this.getExpressionType()).getDescriptor(), this.getArgumentNodes().size());
            } else {
                methodWriter.newArray(MethodWriter.getType(this.getExpressionType().getComponentType()));
            }
        }
    }
}

