/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.scala.ScalaDocOptions;
import org.gradle.api.tasks.scala.internal.GenerateScaladoc;
import org.gradle.util.GUtil;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class ScalaDoc
extends SourceTask {
    private File destinationDir;
    private FileCollection classpath;
    private FileCollection scalaClasspath;
    private ScalaDocOptions scalaDocOptions = new ScalaDocOptions();
    private String title;
    private final Property<String> maxMemory = this.getObjectFactory().property(String.class);

    @Inject
    protected IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public WorkerExecutor getWorkerExecutor() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Classpath
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @Nested
    public ScalaDocOptions getScalaDocOptions() {
        return this.scalaDocOptions;
    }

    public void setScalaDocOptions(ScalaDocOptions scalaDocOptions) {
        this.scalaDocOptions = scalaDocOptions;
    }

    @Nullable
    @Optional
    @Input
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Incubating
    @Internal
    public Property<String> getMaxMemory() {
        return this.maxMemory;
    }

    @TaskAction
    protected void generate() {
        ScalaDocOptions options = this.getScalaDocOptions();
        if (!GUtil.isTrue((Object)options.getDocTitle())) {
            options.setDocTitle(this.getTitle());
        }
        WorkQueue queue = this.getWorkerExecutor().processIsolation(worker -> {
            worker.getClasspath().from(new Object[]{this.getScalaClasspath()});
            if (this.getMaxMemory().isPresent()) {
                worker.forkOptions(forkOptions -> forkOptions.setMaxHeapSize((String)this.getMaxMemory().get()));
            }
        });
        queue.submit(GenerateScaladoc.class, parameters -> {
            List<String> additionalParameters;
            String docTitle;
            String footer;
            parameters.getClasspath().from(new Object[]{this.getClasspath()});
            parameters.getOutputDirectory().set(this.getDestinationDir());
            parameters.getSources().from(new Object[]{this.getSource()});
            if (options.isDeprecation()) {
                parameters.getOptions().add((Object)"-deprecation");
            }
            if (options.isUnchecked()) {
                parameters.getOptions().add((Object)"-unchecked");
            }
            if ((footer = options.getFooter()) != null) {
                parameters.getOptions().add((Object)"-doc-footer");
                parameters.getOptions().add((Object)footer);
            }
            if ((docTitle = options.getDocTitle()) != null) {
                parameters.getOptions().add((Object)"-doc-title");
                parameters.getOptions().add((Object)docTitle);
            }
            if ((additionalParameters = options.getAdditionalParameters()) != null) {
                parameters.getOptions().addAll(additionalParameters);
            }
        });
    }
}

