/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeParametersToTypeArgumentsBinder;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AbstractUpdateExpressionVisitor;
import org.jd.core.v1.util.DefaultList;

public class UpdateBridgeMethodVisitor
extends AbstractUpdateExpressionVisitor {
    protected BodyDeclarationsVisitor bodyDeclarationsVisitor = new BodyDeclarationsVisitor();
    protected HashMap<String, HashMap<String, ClassFileMethodDeclaration>> bridgeMethodDeclarations = new HashMap();
    protected TypeMaker typeMaker;

    public UpdateBridgeMethodVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    public boolean init(ClassFileBodyDeclaration bodyDeclaration) {
        this.bridgeMethodDeclarations.clear();
        this.bodyDeclarationsVisitor.visit(bodyDeclaration);
        return !this.bridgeMethodDeclarations.isEmpty();
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        Expression exp = expression.getExpression();
        expression.setExpression(this.updateExpression(exp));
        if (exp != expression.getExpression()) {
            TypeParametersToTypeArgumentsBinder.staticBindParameterTypesWithArgumentTypes(expression.getType(), expression);
        }
        if (expression.getParameters() != null) {
            expression.setParameters(this.updateBaseExpression(expression.getParameters()));
            expression.getParameters().accept(this);
        }
        expression.getExpression().accept(this);
    }

    @Override
    protected Expression updateExpression(Expression expression) {
        int parameterTypesCount;
        Expression exp;
        if (expression.getClass() != ClassFileMethodInvocationExpression.class) {
            return expression;
        }
        ClassFileMethodInvocationExpression mie1 = (ClassFileMethodInvocationExpression)expression;
        HashMap<String, ClassFileMethodDeclaration> map = this.bridgeMethodDeclarations.get(mie1.getExpression().getType().getDescriptor());
        if (map == null) {
            return expression;
        }
        ClassFileMethodDeclaration bridgeMethodDeclaration = map.get(mie1.getName() + mie1.getDescriptor());
        if (bridgeMethodDeclaration == null) {
            return expression;
        }
        Statement statement = (Statement)bridgeMethodDeclaration.getStatements().getFirst();
        Class<?> statementClass = statement.getClass();
        if (statementClass == ReturnExpressionStatement.class) {
            exp = ((ReturnExpressionStatement)statement).getExpression();
        } else if (statement.getClass() == ExpressionStatement.class) {
            exp = ((ExpressionStatement)statement).getExpression();
        } else {
            return expression;
        }
        Class<?> expClass = exp.getClass();
        BaseType parameterTypes = bridgeMethodDeclaration.getParameterTypes();
        int n = parameterTypesCount = parameterTypes == null ? 0 : parameterTypes.size();
        if (expClass == FieldReferenceExpression.class) {
            FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(exp);
            expression = parameterTypesCount == 0 ? fre.getExpression() : (Expression)mie1.getParameters().getFirst();
            return new FieldReferenceExpression(mie1.getLineNumber(), fre.getType(), expression, fre.getInternalTypeName(), fre.getName(), fre.getDescriptor());
        }
        if (expClass == ClassFileMethodInvocationExpression.class) {
            MethodInvocationExpression mie2 = (MethodInvocationExpression)exp;
            TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(mie2.getInternalTypeName(), mie2.getName(), mie2.getDescriptor());
            if (methodTypes != null) {
                if (mie2.getExpression().getClass() == ObjectTypeReferenceExpression.class) {
                    return new ClassFileMethodInvocationExpression(null, mie1.getLineNumber(), null, methodTypes.returnedType, mie2.getExpression(), mie2.getInternalTypeName(), mie2.getName(), mie2.getDescriptor(), methodTypes.parameterTypes, mie1.getParameters());
                }
                BaseExpression mie1Parameters = mie1.getParameters();
                BaseExpression newParameters = null;
                switch (mie1Parameters.size()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        newParameters = (BaseExpression)mie1Parameters.getList().get(1);
                        break;
                    }
                    default: {
                        DefaultList p = mie1Parameters.getList();
                        newParameters = new Expressions((Collection<Expression>)p.subList(1, p.size()));
                    }
                }
                return new ClassFileMethodInvocationExpression(mie1.getBinder(), mie1.getLineNumber(), null, methodTypes.returnedType, (Expression)mie1Parameters.getFirst(), mie2.getInternalTypeName(), mie2.getName(), mie2.getDescriptor(), methodTypes.parameterTypes, newParameters);
            }
        } else if (expClass == BinaryOperatorExpression.class) {
            BinaryOperatorExpression boe = (BinaryOperatorExpression)exp;
            FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(boe.getLeftExpression());
            if (parameterTypesCount == 1) {
                return new BinaryOperatorExpression(mie1.getLineNumber(), mie1.getType(), new FieldReferenceExpression(fre.getType(), fre.getExpression(), fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()), boe.getOperator(), (Expression)mie1.getParameters().getFirst(), boe.getPriority());
            }
            if (parameterTypesCount == 2) {
                DefaultList parameters = mie1.getParameters().getList();
                return new BinaryOperatorExpression(mie1.getLineNumber(), mie1.getType(), new FieldReferenceExpression(fre.getType(), (Expression)parameters.get(0), fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()), boe.getOperator(), (Expression)parameters.get(1), boe.getPriority());
            }
        } else {
            if (expClass == PostOperatorExpression.class) {
                PostOperatorExpression poe = (PostOperatorExpression)exp;
                FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(poe.getExpression());
                expression = parameterTypesCount == 0 ? fre.getExpression() : (Expression)mie1.getParameters().getFirst();
                return new PostOperatorExpression(mie1.getLineNumber(), new FieldReferenceExpression(fre.getType(), expression, fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()), poe.getOperator());
            }
            if (expClass == PreOperatorExpression.class) {
                PreOperatorExpression poe = (PreOperatorExpression)exp;
                FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(poe.getExpression());
                expression = parameterTypesCount == 0 ? fre.getExpression() : (Expression)mie1.getParameters().getFirst();
                return new PreOperatorExpression(mie1.getLineNumber(), poe.getOperator(), new FieldReferenceExpression(fre.getType(), expression, fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()));
            }
            if (expClass == IntegerConstantExpression.class) {
                return exp;
            }
        }
        return expression;
    }

    protected static FieldReferenceExpression getFieldReferenceExpression(Expression expression) {
        FieldReferenceExpression fre = (FieldReferenceExpression)expression;
        Expression freExpression = fre.getExpression();
        if (freExpression != null && freExpression.getClass() == ObjectTypeReferenceExpression.class) {
            ((ObjectTypeReferenceExpression)freExpression).setExplicit(true);
        }
        return fre;
    }

    protected class BodyDeclarationsVisitor
    extends AbstractJavaSyntaxVisitor {
        protected HashMap<String, ClassFileMethodDeclaration> map = null;

        protected BodyDeclarationsVisitor() {
        }

        @Override
        public void visit(ClassDeclaration declaration) {
            this.safeAccept(declaration.getBodyDeclaration());
        }

        @Override
        public void visit(EnumDeclaration declaration) {
            this.safeAccept(declaration.getBodyDeclaration());
        }

        @Override
        public void visit(InterfaceDeclaration declaration) {
        }

        @Override
        public void visit(AnnotationDeclaration declaration) {
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            List<ClassFileConstructorOrMethodDeclaration> methodDeclarations = bodyDeclaration.getMethodDeclarations();
            if (methodDeclarations != null && !methodDeclarations.isEmpty()) {
                HashMap<String, ClassFileMethodDeclaration> backup = this.map;
                this.map = new HashMap();
                this.acceptListDeclaration(methodDeclarations);
                if (!this.map.isEmpty()) {
                    UpdateBridgeMethodVisitor.this.bridgeMethodDeclarations.put('L' + bodyDeclaration.getInternalTypeName() + ';', this.map);
                }
                this.map = backup;
            }
            this.safeAcceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
        }

        @Override
        public void visit(ConstructorDeclaration declaration) {
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            if ((declaration.getFlags() & 8) == 0) {
                return;
            }
            BaseStatement statements = declaration.getStatements();
            if (statements == null || statements.size() != 1) {
                return;
            }
            String name = declaration.getName();
            if (!name.startsWith("access$")) {
                return;
            }
            ClassFileMethodDeclaration bridgeMethodDeclaration = (ClassFileMethodDeclaration)declaration;
            if (!this.checkBridgeMethodDeclaration(bridgeMethodDeclaration)) {
                return;
            }
            this.map.put(name + declaration.getDescriptor(), bridgeMethodDeclaration);
        }

        private boolean checkBridgeMethodDeclaration(ClassFileMethodDeclaration bridgeMethodDeclaration) {
            int parameterTypesCount;
            Expression exp;
            Statement statement = (Statement)bridgeMethodDeclaration.getStatements().getFirst();
            Class<?> statementClass = statement.getClass();
            if (statementClass == ReturnExpressionStatement.class) {
                exp = ((ReturnExpressionStatement)statement).getExpression();
            } else if (statement.getClass() == ExpressionStatement.class) {
                exp = ((ExpressionStatement)statement).getExpression();
            } else {
                return false;
            }
            Class<?> expClass = exp.getClass();
            BaseType parameterTypes = bridgeMethodDeclaration.getParameterTypes();
            int n = parameterTypesCount = parameterTypes == null ? 0 : parameterTypes.size();
            if (expClass == FieldReferenceExpression.class) {
                FieldReferenceExpression fre = (FieldReferenceExpression)exp;
                if (parameterTypesCount == 0) {
                    return fre.getExpression() != null && fre.getExpression().getClass() == ObjectTypeReferenceExpression.class;
                }
                if (parameterTypesCount == 1) {
                    return fre.getExpression() == null || this.checkLocalVariableReference(fre.getExpression(), 0);
                }
            } else if (expClass == ClassFileMethodInvocationExpression.class) {
                MethodInvocationExpression mie2 = (MethodInvocationExpression)exp;
                if (mie2.getExpression().getClass() == ObjectTypeReferenceExpression.class) {
                    BaseExpression mie2Parameters = mie2.getParameters();
                    if (mie2Parameters == null || mie2Parameters.size() == 0) {
                        return true;
                    }
                    if (mie2Parameters.isList()) {
                        int i = 0;
                        for (Expression parameter : mie2Parameters) {
                            if (!this.checkLocalVariableReference(parameter, i++)) {
                                return false;
                            }
                            Type type = parameter.getType();
                            if (!type.equals(PrimitiveType.TYPE_LONG) && !type.equals(PrimitiveType.TYPE_DOUBLE)) continue;
                            ++i;
                        }
                        return true;
                    }
                    return this.checkLocalVariableReference(mie2Parameters, 0);
                }
                if (parameterTypesCount > 0 && this.checkLocalVariableReference(mie2.getExpression(), 0)) {
                    BaseExpression mie2Parameters = mie2.getParameters();
                    if (mie2Parameters == null || mie2Parameters.size() == 0) {
                        return true;
                    }
                    if (mie2Parameters.isList()) {
                        int i = 1;
                        for (Expression parameter : mie2Parameters) {
                            if (!this.checkLocalVariableReference(parameter, i++)) {
                                return false;
                            }
                            Type type = parameter.getType();
                            if (!type.equals(PrimitiveType.TYPE_LONG) && !type.equals(PrimitiveType.TYPE_DOUBLE)) continue;
                            ++i;
                        }
                        return true;
                    }
                    return this.checkLocalVariableReference(mie2Parameters, 1);
                }
            } else if (expClass == BinaryOperatorExpression.class) {
                BinaryOperatorExpression boe = (BinaryOperatorExpression)exp;
                if (parameterTypesCount == 1) {
                    if (boe.getLeftExpression().getClass() == FieldReferenceExpression.class && this.checkLocalVariableReference(boe.getRightExpression(), 0)) {
                        FieldReferenceExpression fre = (FieldReferenceExpression)boe.getLeftExpression();
                        return fre.getExpression().getClass() == ObjectTypeReferenceExpression.class;
                    }
                } else if (parameterTypesCount == 2 && boe.getLeftExpression().getClass() == FieldReferenceExpression.class && this.checkLocalVariableReference(boe.getRightExpression(), 1)) {
                    FieldReferenceExpression fre = (FieldReferenceExpression)boe.getLeftExpression();
                    return this.checkLocalVariableReference(fre.getExpression(), 0);
                }
            } else if (expClass == PostOperatorExpression.class) {
                PostOperatorExpression poe = (PostOperatorExpression)exp;
                if (poe.getExpression().getClass() == FieldReferenceExpression.class) {
                    FieldReferenceExpression fre = (FieldReferenceExpression)poe.getExpression();
                    if (parameterTypesCount == 0 && fre.getExpression().getClass() == ObjectTypeReferenceExpression.class) {
                        return true;
                    }
                    if (parameterTypesCount == 1 && fre.getExpression() != null && this.checkLocalVariableReference(fre.getExpression(), 0)) {
                        return true;
                    }
                }
            } else if (parameterTypesCount == 1 && expClass == PreOperatorExpression.class) {
                PreOperatorExpression poe = (PreOperatorExpression)exp;
                if (poe.getExpression().getClass() == FieldReferenceExpression.class) {
                    FieldReferenceExpression fre = (FieldReferenceExpression)poe.getExpression();
                    if (parameterTypesCount == 0 && fre.getExpression().getClass() == ObjectTypeReferenceExpression.class) {
                        return true;
                    }
                    if (parameterTypesCount == 1 && fre.getExpression() != null && this.checkLocalVariableReference(fre.getExpression(), 0)) {
                        return true;
                    }
                }
            } else if (parameterTypesCount == 0 && expClass == IntegerConstantExpression.class) {
                return true;
            }
            return false;
        }

        private boolean checkLocalVariableReference(BaseExpression expression, int index) {
            if (expression.getClass() != ClassFileLocalVariableReferenceExpression.class) {
                return false;
            }
            ClassFileLocalVariableReferenceExpression var = (ClassFileLocalVariableReferenceExpression)expression;
            return var.getLocalVariable().getIndex() == index;
        }
    }
}

