/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;

public class RemoveUnusedImports {
    public static String removeUnusedImports(String contents, JavadocOnlyImports javadocOnlyImports) {
        CompilationUnit unit = RemoveUnusedImports.parse(contents);
        if (unit == null) {
            return contents;
        }
        UnusedImportScanner scanner = new UnusedImportScanner();
        unit.accept((ASTVisitor)scanner);
        return RemoveUnusedImports.applyReplacements(contents, RemoveUnusedImports.buildReplacements(contents, unit, scanner.usedNames, (Multimap<String, ASTNode>)scanner.usedInJavadoc, javadocOnlyImports));
    }

    private static CompilationUnit parse(String source) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(source.toCharArray());
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        parser.setCompilerOptions((Map)options);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        if (unit.getMessages().length > 0) {
            return null;
        }
        return unit;
    }

    private static RangeMap<Integer, String> buildReplacements(String contents, CompilationUnit unit, Set<String> usedNames, Multimap<String, ASTNode> usedInJavadoc, JavadocOnlyImports javadocOnlyImports) {
        TreeRangeMap replacements = TreeRangeMap.create();
        for (ImportDeclaration importTree : unit.imports()) {
            String sep;
            String simpleName;
            if (!RemoveUnusedImports.isUnused(unit, usedNames, usedInJavadoc, javadocOnlyImports, importTree, simpleName = RemoveUnusedImports.getSimpleName(importTree))) continue;
            int endPosition = importTree.getStartPosition() + importTree.getLength();
            endPosition = Math.max(CharMatcher.isNot((char)' ').indexIn((CharSequence)contents, endPosition), endPosition);
            if (endPosition + (sep = System.lineSeparator()).length() < contents.length() && contents.subSequence(endPosition, endPosition + sep.length()).equals(sep)) {
                endPosition += sep.length();
            }
            replacements.put(Range.closedOpen((Comparable)Integer.valueOf(importTree.getStartPosition()), (Comparable)Integer.valueOf(endPosition)), (Object)"");
            if (importTree.isStatic()) continue;
            for (ASTNode doc : usedInJavadoc.get((Object)simpleName)) {
                String replaceWith = importTree.getName().toString();
                Range range = Range.closedOpen((Comparable)Integer.valueOf(doc.getStartPosition()), (Comparable)Integer.valueOf(doc.getStartPosition() + doc.getLength()));
                replacements.put(range, (Object)replaceWith);
            }
        }
        return replacements;
    }

    private static String getSimpleName(ImportDeclaration importTree) {
        return importTree.getName() instanceof QualifiedName ? ((QualifiedName)importTree.getName()).getName().toString() : importTree.getName().toString();
    }

    private static boolean isUnused(CompilationUnit unit, Set<String> usedNames, Multimap<String, ASTNode> usedInJavadoc, JavadocOnlyImports javadocOnlyImports, ImportDeclaration importTree, String simpleName) {
        if (unit.getPackage() != null) {
            String qualifier;
            String string = importTree.isOnDemand() ? importTree.getName().toString() : (qualifier = importTree.getName() instanceof QualifiedName ? ((QualifiedName)importTree.getName()).getQualifier().toString() : null);
            if (unit.getPackage().getName().toString().equals(qualifier)) {
                return true;
            }
        }
        if (importTree.isOnDemand()) {
            return false;
        }
        if (usedNames.contains(simpleName)) {
            return false;
        }
        return !usedInJavadoc.containsKey((Object)simpleName) || javadocOnlyImports != JavadocOnlyImports.KEEP;
    }

    private static String applyReplacements(String source, RangeMap<Integer, String> replacements) {
        TreeRangeSet fixedRanges = TreeRangeSet.create();
        StringBuilder sb = new StringBuilder(source);
        int offset = 0;
        for (Map.Entry replacement : replacements.asMapOfRanges().entrySet()) {
            Range range = (Range)replacement.getKey();
            String replaceWith = (String)replacement.getValue();
            int start = offset + (Integer)range.lowerEndpoint();
            int end = offset + (Integer)range.upperEndpoint();
            sb.replace(start, end, replaceWith);
            if (!replaceWith.isEmpty()) {
                fixedRanges.add(Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
            offset += replaceWith.length() - ((Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint());
        }
        String result = sb.toString();
        if (!fixedRanges.isEmpty()) {
            try {
                result = new Formatter().formatSource(result, fixedRanges.asRanges());
            }
            catch (FormatterException formatterException) {
                // empty catch block
            }
        }
        return result;
    }

    private static class UnusedImportScanner
    extends ASTVisitor {
        private final Set<String> usedNames = new LinkedHashSet<String>();
        private final Multimap<String, ASTNode> usedInJavadoc = HashMultimap.create();

        private UnusedImportScanner() {
        }

        public boolean visit(Javadoc node) {
            node.accept(new ASTVisitor(true){

                public boolean visit(TagElement node) {
                    UnusedImportScanner.this.recordTag(node);
                    return super.visit(node);
                }
            });
            return super.visit(node);
        }

        private void recordTag(TagElement node) {
            if (node.getTagName() == null) {
                return;
            }
            switch (node.getTagName()) {
                case "@exception": 
                case "@link": 
                case "@linkplain": 
                case "@see": 
                case "@throws": 
                case "@value": {
                    this.recordReference((ASTNode)Iterables.getFirst((Iterable)node.fragments(), null));
                    break;
                }
            }
        }

        private void recordReference(ASTNode reference) {
            if (reference instanceof SimpleName) {
                this.recordSimpleName((Name)reference);
            } else if (reference instanceof MemberRef) {
                this.recordSimpleName(((MemberRef)reference).getQualifier());
            } else if (reference instanceof MethodRef) {
                this.recordMethodRef((MethodRef)reference);
            }
        }

        private void recordMethodRef(MethodRef methodRef) {
            this.recordSimpleName(methodRef.getQualifier());
            for (MethodRefParameter parameter : methodRef.parameters()) {
                this.recordTypeRef(parameter.getType());
            }
        }

        private void recordTypeRef(Type type) {
            if (type instanceof SimpleType) {
                this.recordSimpleName(((SimpleType)type).getName());
            } else if (type instanceof ArrayType) {
                this.recordTypeRef(((ArrayType)type).getElementType());
            }
        }

        private void recordSimpleName(Name name) {
            String identifier;
            while (name instanceof QualifiedName) {
                name = ((QualifiedName)name).getQualifier();
            }
            if (name instanceof SimpleName && Character.isUpperCase((identifier = ((SimpleName)name).getIdentifier()).charAt(0))) {
                this.usedInJavadoc.put((Object)identifier, (Object)name);
            }
        }

        public boolean visit(ImportDeclaration node) {
            return false;
        }

        public boolean visit(SimpleName node) {
            this.usedNames.add(node.getIdentifier().toString());
            return super.visit(node);
        }
    }

    public static enum JavadocOnlyImports {
        REMOVE,
        KEEP;

    }
}

