/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected JcaTlsCrypto crypto;
    protected Certificate certificate;
    protected PrivateKey privateKey;

    public JceDefaultTlsCredentialedDecryptor(JcaTlsCrypto jcaTlsCrypto, Certificate certificate, PrivateKey privateKey) {
        if (jcaTlsCrypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!(privateKey instanceof RSAPrivateKey) && !"RSA".equals(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.crypto = jcaTlsCrypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public TlsSecret decrypt(TlsCryptoParameters tlsCryptoParameters, byte[] byArray) throws IOException {
        return this.safeDecryptPreMasterSecret(tlsCryptoParameters, this.privateKey, byArray);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters tlsCryptoParameters, PrivateKey privateKey, byte[] byArray) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion protocolVersion = tlsCryptoParameters.getClientVersion();
        boolean bl = false;
        byte[] byArray2 = new byte[48];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = Arrays.clone((byte[])byArray2);
        try {
            Cipher cipher = this.crypto.createRSAEncryptionCipher();
            cipher.init(2, privateKey);
            byte[] byArray4 = cipher.doFinal(byArray);
            if (byArray4 != null && byArray4.length == 48) {
                byArray3 = byArray4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl || !protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            int n = protocolVersion.getMajorVersion() ^ byArray3[0] & 0xFF | protocolVersion.getMinorVersion() ^ byArray3[1] & 0xFF;
            n |= n >> 1;
            n |= n >> 2;
            n |= n >> 4;
            int n2 = ~((n & 1) - 1);
            for (int i = 0; i < 48; ++i) {
                byArray3[i] = (byte)(byArray3[i] & ~n2 | byArray2[i] & n2);
            }
        }
        return this.crypto.createSecret(byArray3);
    }
}

