/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.util.Vector;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;

public class CounterSupport {
    protected static CounterSupport instance = null;
    private transient Vector<CounterListener> counterListeners;

    protected CounterSupport() {
    }

    public static CounterSupport getInstance() {
        if (instance == null) {
            instance = new CounterSupport();
        }
        return instance;
    }

    public synchronized void addCounterListener(CounterListener listener) {
        if (this.counterListeners == null) {
            this.counterListeners = new Vector(2);
        }
        if (!this.counterListeners.contains(listener)) {
            this.counterListeners.add(listener);
        }
    }

    public synchronized void removeCounterListener(CounterListener listener) {
        if (this.counterListeners != null && this.counterListeners.contains(listener)) {
            this.counterListeners.removeElement(listener);
        }
    }

    public void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            for (CounterListener l : this.counterListeners) {
                l.incrementCounter(event);
            }
        }
    }
}

