/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.speller.dictionary;

import com.intellij.grazie.speller.lists.WordList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u0000 \f2\u00020\u0001:\u0004\u000b\f\r\u000eJ\u0011\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6\u0002J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/speller/dictionary/Dictionary;", "", "contains", "", "word", "", "isAlien", "suggest", "", "distance", "", "Aggregated", "Companion", "Default", "Empty", "spellchecker"})
public interface Dictionary {
    public static final Companion Companion = com.intellij.grazie.speller.dictionary.Dictionary$Companion.$$INSTANCE;

    public boolean contains(@NotNull String var1);

    @NotNull
    public Set<String> suggest(@NotNull String var1, int var2);

    public boolean isAlien(@NotNull String var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/speller/dictionary/Dictionary$Aggregated;", "Lcom/intellij/grazie/speller/dictionary/Dictionary;", "dictionaries", "", "([Lcom/intellij/grazie/speller/dictionary/Dictionary;)V", "", "(Ljava/util/Set;)V", "contains", "", "word", "", "isAlien", "suggest", "distance", "", "spellchecker"})
    public static final class Aggregated
    implements Dictionary {
        private final Set<Dictionary> dictionaries;

        @Override
        public boolean contains(@NotNull String word) {
            boolean bl;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
                Iterable $this$any$iv = this.dictionaries;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Dictionary it = (Dictionary)element$iv;
                        boolean bl2 = false;
                        if (!it.contains(word)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<String> suggest(@NotNull String word, int distance) {
            void $this$flatMapTo$iv;
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            Iterable $this$filterNot$iv = this.dictionaries;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Dictionary it = (Dictionary)element$iv$iv;
                boolean bl = false;
                if (it.isAlien(word)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            Collection destination$iv = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                Dictionary it = (Dictionary)element$iv;
                boolean bl = false;
                Iterable list$iv = it.suggest(word, distance);
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (Set)destination$iv;
        }

        @Override
        public boolean isAlien(@NotNull String word) {
            boolean bl;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
                Iterable $this$all$iv = this.dictionaries;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Dictionary it = (Dictionary)element$iv;
                        boolean bl2 = false;
                        if (it.isAlien(word)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public Aggregated(@NotNull Set<? extends Dictionary> dictionaries) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkParameterIsNotNull(dictionaries, (String)"dictionaries");
            Iterable iterable = dictionaries;
            Aggregated aggregated = this;
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Dictionary it = (Dictionary)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof Empty))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            aggregated.dictionaries = CollectionsKt.toSet((Iterable)list);
        }

        public Aggregated(Dictionary ... dictionaries) {
            Intrinsics.checkParameterIsNotNull((Object)dictionaries, (String)"dictionaries");
            this(ArraysKt.toSet((Object[])dictionaries));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grazie/speller/dictionary/Dictionary$Default;", "Lcom/intellij/grazie/speller/dictionary/Dictionary;", "list", "Lcom/intellij/grazie/speller/lists/WordList;", "(Lcom/intellij/grazie/speller/lists/WordList;)V", "contains", "", "word", "", "isAlien", "suggest", "", "distance", "", "spellchecker"})
    public static final class Default
    implements Dictionary {
        private final WordList list;

        @Override
        public boolean contains(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return this.list.contains(word);
        }

        @Override
        @NotNull
        public Set<String> suggest(@NotNull String word, int distance) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return SequencesKt.toSet(this.list.suggest(word, distance));
        }

        @Override
        public boolean isAlien(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return this.list.isAlien(word);
        }

        public Default(@NotNull WordList list) {
            Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
            this.list = list;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/grazie/speller/dictionary/Dictionary$Empty;", "Lcom/intellij/grazie/speller/dictionary/Dictionary;", "()V", "contains", "", "word", "", "isAlien", "suggest", "", "distance", "", "spellchecker"})
    private static final class Empty
    implements Dictionary {
        @Override
        public boolean contains(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return false;
        }

        @Override
        @NotNull
        public Set<String> suggest(@NotNull String word, int distance) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return SetsKt.emptySet();
        }

        @Override
        public boolean isAlien(@NotNull String word) {
            Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
            return true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/speller/dictionary/Dictionary$Companion;", "", "()V", "empty", "Lcom/intellij/grazie/speller/dictionary/Dictionary;", "getEmpty", "()Lcom/intellij/grazie/speller/dictionary/Dictionary;", "spellchecker"})
    public static final class Companion {
        @NotNull
        private static final Dictionary empty;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final Dictionary getEmpty() {
            return empty;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            empty = new Empty();
        }
    }
}

