/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.VirtualFileResolver;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeListManager;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u00052\u00020\u0006B\u00b3\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\b\u0012'\b\u0002\u0010\u0012\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\b0\u0013j\u0002`\u0016\u00123\b\u0002\u0010\u0017\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0000\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0013j\u0004\u0018\u0001`\u001a\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010T\u001a\u00020\u00192\u0006\u0010U\u001a\u00028\u00002\u0006\u0010V\u001a\u000205H\u0016\u00a2\u0006\u0002\u0010WJ\u000e\u0010X\u001a\u0002052\u0006\u0010\u0015\u001a\u00020YJ#\u0010Z\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010[2\b\b\u0002\u0010\\\u001a\u000205H\u0000\u00a2\u0006\u0002\b]J$\u0010^\u001a\u00020\u00192\f\u0010_\u001a\b\u0012\u0004\u0012\u00020`0Q2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0/H\u0002J\u0017\u0010a\u001a\u0004\u0018\u00018\u00002\u0006\u0010b\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010cJ\u001d\u0010d\u001a\u00020\b2\u0006\u0010e\u001a\u00020Y2\u0006\u0010f\u001a\u000205H\u0000\u00a2\u0006\u0002\bgJ\u0019\u0010h\u001a\u0004\u0018\u00010\b2\u0006\u0010U\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\bi\u0010jJ\u0017\u0010k\u001a\u0004\u0018\u00010'2\u0006\u0010l\u001a\u00020mH\u0000\u00a2\u0006\u0002\bnJ5\u0010o\u001a\u0002052\b\u0010p\u001a\u0004\u0018\u00010L2\u0006\u0010q\u001a\u00020r2\u0006\u0010U\u001a\u00028\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0/H\u0002\u00a2\u0006\u0002\u0010sJ\u0015\u0010t\u001a\u0002052\u0006\u0010U\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010uJ\u0015\u0010v\u001a\u0002052\u0006\u0010U\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010uJ\u0018\u0010w\u001a\u00020\u00192\u0006\u0010x\u001a\u00020\b2\u0006\u0010y\u001a\u00020\u0002H\u0016J\u000e\u0010z\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\b\u0010{\u001a\u00020\u0019H\u0002J\b\u0010|\u001a\u00020\u0019H\u0016J\u0016\u0010}\u001a\u00020\u00192\f\u0010_\u001a\b\u0012\u0004\u0012\u00020`0QH\u0002J\r\u0010~\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u007fJ2\u0010\u0080\u0001\u001a\u0004\u0018\u00018\u00002\u0007\u0010\u0081\u0001\u001a\u0002052\u0013\u0010\u0082\u0001\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002050\u0013H\u0000\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001J\u0016\u0010\u0085\u0001\u001a\u0002052\u0006\u0010U\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010uJ\u001e\u0010\u0085\u0001\u001a\u0002052\u0006\u0010U\u001a\u00028\u00002\u0007\u0010\u0081\u0001\u001a\u000205\u00a2\u0006\u0003\u0010\u0086\u0001J\u0018\u0010\u0085\u0001\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010cJ\u0018\u0010\u0087\u0001\u001a\u00020\u00192\u0007\u0010\u0081\u0001\u001a\u000205H\u0000\u00a2\u0006\u0003\b\u0088\u0001J\u0017\u0010\u0089\u0001\u001a\u00020\u00192\f\u0010_\u001a\b\u0012\u0004\u0012\u00020`0QH\u0016J/\u0010\u008a\u0001\u001a\u00020\u00192\u0006\u0010U\u001a\u00028\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0/H\u0002\u00a2\u0006\u0003\u0010\u008d\u0001J;\u0010\u008e\u0001\u001a\u00020\u00192\r\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000#2\t\u0010\u0090\u0001\u001a\u0004\u0018\u00018\u00002\u0010\u0010\u0091\u0001\u001a\u000b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0092\u0001H\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J\t\u0010\u0094\u0001\u001a\u00020\bH\u0016R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R9\u0010\u0017\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0000\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0013j\u0004\u0018\u0001`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0/X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00109\u001a\u000205X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00106R\u0014\u0010;\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00106R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010-R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010-R\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000FX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR-\u0010\u0012\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\b0\u0013j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010I\u001a#\u0012\f\u0012\n K*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n K*\u0004\u0018\u00010L0L0J\u00a2\u0006\u0002\bMX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u001a\u0010P\u001a\b\u0012\u0004\u0012\u00028\u00000Q8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010%R\u000e\u0010S\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "T", "", "MUTABLE_SCHEME", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerBase;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "fileSpec", "", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "ioDirectory", "Ljava/nio/file/Path;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "presentableName", "schemeNameToFileName", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/configurationStore/SchemeNameToFileName;", "fileChangeSubscriber", "schemeManager", "", "Lcom/intellij/configurationStore/schemeManager/FileChangeSubscriber;", "virtualFileResolver", "Lcom/intellij/configurationStore/VirtualFileResolver;", "(Ljava/lang/String;Lcom/intellij/openapi/options/SchemeProcessor;Lcom/intellij/configurationStore/StreamProvider;Ljava/nio/file/Path;Lcom/intellij/openapi/components/RoamingType;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/intellij/configurationStore/VirtualFileResolver;)V", "allSchemeNames", "", "getAllSchemeNames", "()Ljava/util/Collection;", "allSchemes", "", "getAllSchemes", "()Ljava/util/List;", "cachedVirtualDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCachedVirtualDirectory$intellij_platform_configurationStore_impl", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setCachedVirtualDirectory$intellij_platform_configurationStore_impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFileSpec", "()Ljava/lang/String;", "filesToDelete", "", "getFilesToDelete$intellij_platform_configurationStore_impl", "()Ljava/util/Set;", "getIoDirectory$intellij_platform_configurationStore_impl", "()Ljava/nio/file/Path;", "isEmpty", "", "()Z", "isLoadingSchemes", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isOldSchemeNaming", "isOldSchemeNaming$intellij_platform_configurationStore_impl", "isUseVfs", "getPresentableName", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "rootDirectory", "Ljava/io/File;", "getRootDirectory", "()Ljava/io/File;", "schemeExtension", "getSchemeExtension$intellij_platform_configurationStore_impl", "schemeListManager", "Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "getSchemeListManager$intellij_platform_configurationStore_impl", "()Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "schemeToInfo", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "Lorg/jetbrains/annotations/NotNull;", "getSchemeToInfo$intellij_platform_configurationStore_impl", "()Ljava/util/concurrent/ConcurrentMap;", "schemes", "", "getSchemes$intellij_platform_configurationStore_impl", "updateExtension", "addScheme", "scheme", "replaceExisting", "(Ljava/lang/Object;Z)V", "canRead", "", "createSchemeLoader", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "isDuringLoad", "createSchemeLoader$intellij_platform_configurationStore_impl", "deleteFiles", "errors", "", "findSchemeByName", "schemeName", "(Ljava/lang/String;)Ljava/lang/Object;", "getFileExtension", "fileName", "isAllowAny", "getFileExtension$intellij_platform_configurationStore_impl", "getFileName", "getFileName$intellij_platform_configurationStore_impl", "(Ljava/lang/Object;)Ljava/lang/String;", "getVirtualDirectory", "reasonOperation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getVirtualDirectory$intellij_platform_configurationStore_impl", "isEqualToBundledScheme", "externalInfo", "newDigest", "", "(Lcom/intellij/configurationStore/schemeManager/ExternalInfo;[BLjava/lang/Object;Ljava/util/Set;)Z", "isMetadataEditable", "(Ljava/lang/Object;)Z", "isRenamed", "loadBundledScheme", "resourceName", "requestor", "loadSchemes", "refreshVirtualDirectory", "reload", "removeDirectoryIfEmpty", "removeExternalizableSchemesFromRuntimeState", "removeExternalizableSchemesFromRuntimeState$intellij_platform_configurationStore_impl", "removeFirstScheme", "isScheduleToDelete", "condition", "removeFirstScheme$intellij_platform_configurationStore_impl", "(ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "removeScheme", "(Ljava/lang/Object;Z)Z", "retainExternalInfo", "retainExternalInfo$intellij_platform_configurationStore_impl", "save", "saveScheme", "nameGenerator", "Lcom/intellij/util/text/UniqueNameGenerator;", "(Ljava/lang/Object;Lcom/intellij/util/text/UniqueNameGenerator;Ljava/util/Set;)V", "setSchemes", "newSchemes", "newCurrentScheme", "removeCondition", "Ljava/util/function/Predicate;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/function/Predicate;)V", "toString", "intellij.platform.configurationStore.impl"})
public final class SchemeManagerImpl<T, MUTABLE_SCHEME extends T>
extends SchemeManagerBase<T, MUTABLE_SCHEME>
implements SafeWriteRequestor,
StorageManagerFileWriteRequestor {
    private final boolean isOldSchemeNaming;
    private final AtomicBoolean isLoadingSchemes;
    @NotNull
    private final SchemeListManager<T> schemeListManager;
    @Nullable
    private VirtualFile cachedVirtualDirectory;
    @NotNull
    private final String schemeExtension;
    private final boolean updateExtension;
    @NotNull
    private final Set<String> filesToDelete;
    @NotNull
    private final ConcurrentMap<T, ExternalInfo> schemeToInfo;
    @NotNull
    private final String fileSpec;
    private final StreamProvider provider;
    @NotNull
    private final Path ioDirectory;
    @NotNull
    private final RoamingType roamingType;
    @Nullable
    private final String presentableName;
    private final Function1<String, String> schemeNameToFileName;
    private final Function1<SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber;
    private final VirtualFileResolver virtualFileResolver;

    private final boolean isUseVfs() {
        return this.fileChangeSubscriber != null || this.virtualFileResolver != null;
    }

    public final boolean isOldSchemeNaming$intellij_platform_configurationStore_impl() {
        return this.isOldSchemeNaming;
    }

    @NotNull
    public final SchemeListManager<T> getSchemeListManager$intellij_platform_configurationStore_impl() {
        return this.schemeListManager;
    }

    @NotNull
    public final List<T> getSchemes$intellij_platform_configurationStore_impl() {
        return this.schemeListManager.getSchemes();
    }

    @Nullable
    public final VirtualFile getCachedVirtualDirectory$intellij_platform_configurationStore_impl() {
        return this.cachedVirtualDirectory;
    }

    public final void setCachedVirtualDirectory$intellij_platform_configurationStore_impl(@Nullable VirtualFile virtualFile) {
        this.cachedVirtualDirectory = virtualFile;
    }

    @NotNull
    public final String getSchemeExtension$intellij_platform_configurationStore_impl() {
        return this.schemeExtension;
    }

    @NotNull
    public final Set<String> getFilesToDelete$intellij_platform_configurationStore_impl() {
        return this.filesToDelete;
    }

    @NotNull
    public final ConcurrentMap<T, ExternalInfo> getSchemeToInfo$intellij_platform_configurationStore_impl() {
        return this.schemeToInfo;
    }

    @NotNull
    public File getRootDirectory() {
        File file = this.ioDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"ioDirectory.toFile()");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getAllSchemeNames() {
        List list;
        Collection $this$mapSmart$iv = this.getSchemes$intellij_platform_configurationStore_impl();
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.size();
        switch (size$iv) {
            case 1: {
                String string;
                Object it = CollectionsKt.first((Iterable)$this$mapSmart$iv);
                boolean bl = false;
                String string2 = string = this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it);
                list = (List)new SmartList((Object)string2);
                break;
            }
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                Iterable iterable = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object bl = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean $i$a$-mapSmart-SchemeManagerImpl$allSchemeNames$2 = false;
                    String string = this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey((Object)it);
                    collection.add(string);
                }
                list = (List)destination$iv$iv;
            }
        }
        return list;
    }

    @NotNull
    public List<T> getAllSchemes() {
        List<T> list = Collections.unmodifiableList(this.getSchemes$intellij_platform_configurationStore_impl());
        Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.unmodifiableList(schemes)");
        return list;
    }

    public boolean isEmpty() {
        return this.getSchemes$intellij_platform_configurationStore_impl().isEmpty();
    }

    private final void refreshVirtualDirectory() {
        VirtualFile directory;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath((Path)this.ioDirectory));
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ndependentPath) ?: return");
        this.cachedVirtualDirectory = directory = virtualFile;
        directory.getChildren();
        if (directory instanceof NewVirtualFile) {
            ((NewVirtualFile)directory).markDirty();
        }
        directory.refresh(true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        try {
            void parser;
            URL url;
            Object object = requestor;
            URL uRL = object instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : (object instanceof TempUIThemeBasedLookAndFeelInfo ? new File(resourceName).toURI().toURL() : (url = object instanceof UITheme ? DecodeDefaultsUtil.getDefaults((Object)((UITheme)requestor).getProviderClassLoader(), (String)resourceName) : DecodeDefaultsUtil.getDefaults((Object)requestor, (String)resourceName)));
            if (url == null) {
                ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName);
                return;
            }
            InputStream inputStream = URLUtil.openStream((URL)url);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"URLUtil.openStream(url)");
            byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
            boolean isOldSchemeNaming$iv = this.isOldSchemeNaming;
            boolean $i$f$lazyPreloadScheme = false;
            MXParser parser$iv = new MXParser();
            Object object2 = bytes;
            boolean bl = false;
            object2 = new ByteArrayInputStream((byte[])object2);
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            parser$iv.setInput((Reader)new InputStreamReader((InputStream)object2, charset));
            XmlPullParser xmlPullParser = (XmlPullParser)parser$iv;
            String name = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, parser$iv);
            boolean bl3 = false;
            Function attributeProvider2 = new Function<String, String>((XmlPullParser)parser){
                final /* synthetic */ XmlPullParser $parser;

                public final String apply(String it) {
                    return this.$parser.getAttributeValue(null, it);
                }
                {
                    this.$parser = xmlPullParser;
                }
            };
            String string = PathUtilRt.getFileName((String)url.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtilRt.getFileName(url.path)");
            String fileName = string;
            String extension = this.getFileExtension$intellij_platform_configurationStore_impl(fileName, true);
            String string2 = fileName;
            int n = 0;
            int n2 = fileName.length() - extension.length();
            boolean bl4 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            ExternalInfo externalInfo = new ExternalInfo(string4, extension);
            String string5 = name;
            if (string5 == null) {
                SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                if (schemeProcessor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.LazySchemeProcessor<T, MUTABLE_SCHEME>");
                }
                string5 = ((LazySchemeProcessor)schemeProcessor).getSchemeKey(attributeProvider2, externalInfo.getFileNameWithoutExtension());
            }
            if (string5 == null) {
                throw (Throwable)SchemeManagerUtilKt.nameIsMissed(bytes);
            }
            String schemeKey = string5;
            externalInfo.setSchemeKey(schemeKey);
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            if (schemeProcessor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.LazySchemeProcessor<T, MUTABLE_SCHEME>");
            }
            Object scheme2 = ((LazySchemeProcessor)schemeProcessor).createScheme((SchemeDataHolder)new SchemeDataHolderImpl(this.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo), schemeKey, attributeProvider2, true);
            ExternalInfo oldInfo = this.schemeToInfo.put(scheme2, externalInfo);
            ComponentStoreImplKt.getLOG().assertTrue(oldInfo == null);
            Object oldScheme = this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().put(schemeKey, scheme2);
            if (oldScheme != null) {
                ComponentStoreImplKt.getLOG().warn("Duplicated scheme " + schemeKey + " - old: " + oldScheme + ", new " + scheme2);
            }
            this.getSchemes$intellij_platform_configurationStore_impl().add(scheme2);
            if (requestor instanceof UITheme) {
                ((UITheme)requestor).setEditorSchemeName(schemeKey);
            }
            if (requestor instanceof TempUIThemeBasedLookAndFeelInfo) {
                UITheme uITheme = ((TempUIThemeBasedLookAndFeelInfo)requestor).getTheme();
                Intrinsics.checkNotNullExpressionValue((Object)uITheme, (String)"requestor.theme");
                uITheme.setEditorSchemeName(schemeKey);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName, e);
        }
    }

    @NotNull
    public final SchemeLoader<T, MUTABLE_SCHEME> createSchemeLoader$intellij_platform_configurationStore_impl(boolean isDuringLoad) {
        HashSet filesToDelete = new HashSet(this.filesToDelete);
        this.filesToDelete.removeAll(filesToDelete);
        return new SchemeLoader(this, this.getSchemes$intellij_platform_configurationStore_impl(), filesToDelete, isDuringLoad);
    }

    public static /* synthetic */ SchemeLoader createSchemeLoader$intellij_platform_configurationStore_impl$default(SchemeManagerImpl schemeManagerImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return schemeManagerImpl.createSchemeLoader$intellij_platform_configurationStore_impl(bl);
    }

    @NotNull
    public final String getFileExtension$intellij_platform_configurationStore_impl(@NotNull CharSequence fileName, boolean isAllowAny) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.schemeExtension)) {
            string = this.schemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            string = ".xml";
        } else if (isAllowAny) {
            String string2 = PathUtil.getFileExtension((String)((Object)fileName).toString());
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.getFileExtension(fileName.toString())!!");
        } else {
            throw (Throwable)new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Collection<T> loadSchemes() {
        if (!this.isLoadingSchemes.compareAndSet(false, true)) {
            throw (Throwable)new IllegalStateException("loadSchemes is already called");
        }
        try {
            boolean isLoadOnlyFromProvider2;
            SchemeLoader<T, MUTABLE_SCHEME> schemeLoader = this.createSchemeLoader$intellij_platform_configurationStore_impl(true);
            boolean bl = isLoadOnlyFromProvider2 = this.provider != null && this.provider.processChildren(this.fileSpec, this.roamingType, (Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.canRead(it);
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(1);
                }
            }, (Function3)new Function3<String, InputStream, Boolean, Boolean>(this, schemeLoader){
                final /* synthetic */ SchemeManagerImpl this$0;
                final /* synthetic */ SchemeLoader $schemeLoader;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input, boolean readOnly) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                    boolean $i$f$catchAndLog = false;
                    try {
                        boolean bl = false;
                        MUTABLE_SCHEME scheme2 = this.$schemeLoader.loadScheme(name, input, null);
                        if (readOnly && scheme2 != null) {
                            this.this$0.getSchemeListManager$intellij_platform_configurationStore_impl().getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().put(this.this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2), scheme2);
                        }
                    }
                    catch (ProcessCanceledException e$iv) {
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable e$iv) {
                        StringBuilder stringBuilder = new StringBuilder().append("Cannot read scheme ");
                        Logger logger = ComponentStoreImplKt.getLOG();
                        boolean bl = false;
                        String string = SchemeManagerImpl.access$getProvider$p(this.this$0).getClass().getName() + ": " + name;
                        logger.error(stringBuilder.append(string).toString(), e$iv);
                    }
                    return true;
                }
                {
                    this.this$0 = schemeManagerImpl;
                    this.$schemeLoader = schemeLoader;
                    super(3);
                }
            });
            if (!isLoadOnlyFromProvider2) {
                if (this.virtualFileResolver == null) {
                    Path path = this.ioDirectory;
                    Function1 filter$iv = (Function1)new Function1<Path, Boolean>(this){
                        final /* synthetic */ SchemeManagerImpl this$0;

                        public final boolean invoke(@NotNull Path it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.this$0.canRead(((Object)it.getFileName()).toString());
                        }
                        {
                            this.this$0 = schemeManagerImpl;
                            super(1);
                        }
                    };
                    boolean $i$f$directoryStreamIfExists = false;
                    try {
                        void $this$directoryStreamIfExists$iv;
                        Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                            final /* synthetic */ Function1 $filter;
                            {
                                this.$filter = function1;
                            }

                            public final boolean accept(Path it) {
                                Path path = it;
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                                return (Boolean)this.$filter.invoke((Object)path);
                            }
                        });
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Throwable throwable = null;
                        try {
                            DirectoryStream directoryStream = (DirectoryStream)closeable;
                            boolean bl4 = false;
                            for (Path file : directoryStream) {
                                boolean $i$f$catchAndLog = false;
                                try {
                                    byte[] byArray;
                                    boolean bl5 = false;
                                    try {
                                        byArray = Files.readAllBytes(file);
                                    }
                                    catch (FileSystemException e) {
                                        Path path2 = file;
                                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
                                        if (PathKt.isDirectory((Path)path2)) continue;
                                        throw (Throwable)e;
                                    }
                                    byte[] bytes = byArray;
                                    Path path3 = file;
                                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file");
                                    schemeLoader.loadScheme(((Object)path3.getFileName()).toString(), null, bytes);
                                }
                                catch (ProcessCanceledException e$iv) {
                                    throw (Throwable)e$iv;
                                }
                                catch (Throwable e$iv) {
                                    StringBuilder stringBuilder = new StringBuilder().append("Cannot read scheme ");
                                    Logger logger = ComponentStoreImplKt.getLOG();
                                    boolean bl6 = false;
                                    String string = ((Object)file).toString();
                                    logger.error(stringBuilder.append(string).toString(), e$iv);
                                }
                            }
                            directoryStream = Unit.INSTANCE;
                        }
                        catch (Throwable directoryStream) {
                            throwable = directoryStream;
                            throw directoryStream;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (NoSuchFileException noSuchFileException) {}
                } else {
                    VirtualFile[] virtualFileArray = this.getVirtualDirectory$intellij_platform_configurationStore_impl(StateStorageOperation.READ);
                    if (virtualFileArray == null || (virtualFileArray = virtualFileArray.getChildren()) == null) {
                        virtualFileArray = VirtualFile.EMPTY_ARRAY;
                    }
                    for (VirtualFile file : virtualFileArray) {
                        boolean $i$f$catchAndLog = false;
                        try {
                            boolean bl7 = false;
                            VirtualFile virtualFile = file;
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                            CharSequence charSequence = virtualFile.getNameSequence();
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"file.nameSequence");
                            if (!this.canRead(charSequence)) continue;
                            String string = file.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                            schemeLoader.loadScheme(string, null, file.contentsToByteArray());
                        }
                        catch (ProcessCanceledException e$iv) {
                            throw (Throwable)e$iv;
                        }
                        catch (Throwable e$iv) {
                            String string;
                            StringBuilder stringBuilder = new StringBuilder().append("Cannot read scheme ");
                            Logger logger = ComponentStoreImplKt.getLOG();
                            boolean bl8 = false;
                            VirtualFile virtualFile = file;
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getPath(), (String)"file.path");
                            logger.error(stringBuilder.append(string).toString(), e$iv);
                        }
                    }
                }
            }
            List<T> newSchemes = schemeLoader.apply();
            for (T newScheme : newSchemes) {
                if (this.processPendingCurrentSchemeName$intellij_platform_configurationStore_impl(newScheme)) break;
            }
            Function1<SchemeManagerImpl<?, ?>, Unit> function1 = this.fileChangeSubscriber;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this);
            }
            Collection collection = newSchemes;
            return collection;
        }
        finally {
            this.isLoadingSchemes.set(false);
        }
    }

    public void reload() {
        this.getProcessor$intellij_platform_configurationStore_impl().beforeReloaded((SchemeManager)this);
        this.removeExternalizableSchemesFromRuntimeState$intellij_platform_configurationStore_impl();
        this.getProcessor$intellij_platform_configurationStore_impl().reloaded((SchemeManager)this, this.loadSchemes());
    }

    public final void removeExternalizableSchemesFromRuntimeState$intellij_platform_configurationStore_impl() {
        Iterator<T> iterator;
        Iterator<T> iterator2 = iterator = this.getSchemes$intellij_platform_configurationStore_impl().iterator();
        boolean bl = false;
        Iterator<T> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            SerializableScheme serializableScheme;
            T scheme2 = iterator3.next();
            T t = scheme2;
            if (!(t instanceof SerializableScheme)) {
                t = null;
            }
            if ((serializableScheme = (SerializableScheme)t) == null || (serializableScheme = serializableScheme.getSchemeState()) == null) {
                serializableScheme = this.getProcessor$intellij_platform_configurationStore_impl().getState(scheme2);
            }
            if (serializableScheme == SchemeState.NON_PERSISTENT) continue;
            if (this.getActiveScheme() != null) {
                bl = false;
                boolean bl2 = false;
                Iterator<T> it = iterator2;
                boolean bl3 = false;
                if (scheme2 == it) {
                    this.setCurrentPendingSchemeName$intellij_platform_configurationStore_impl(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it));
                    this.setActiveScheme$intellij_platform_configurationStore_impl(null);
                }
            }
            iterator.remove();
            T t2 = scheme2;
            if (t2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type MUTABLE_SCHEME");
            }
            this.getProcessor$intellij_platform_configurationStore_impl().onSchemeDeleted(t2);
        }
        this.retainExternalInfo$intellij_platform_configurationStore_impl(false);
    }

    @Nullable
    public final String getFileName$intellij_platform_configurationStore_impl(@NotNull T scheme2) {
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme2);
        return externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null;
    }

    public final boolean canRead(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (this.updateExtension && StringsKt.endsWith((CharSequence)name, (CharSequence)".xml", (boolean)true) || StringsKt.endsWith((CharSequence)name, (CharSequence)this.schemeExtension, (boolean)true)) && (!(this.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor) || ((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl()).isSchemeFile(name));
    }

    public void save(@NotNull List<Throwable> errors) {
        Object scheme22;
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        if (this.isLoadingSchemes.get()) {
            ComponentStoreImplKt.getLOG().warn("Skip save - schemes are loading");
        }
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList changedSchemes = new SmartList();
        for (T scheme3 : this.getSchemes$intellij_platform_configurationStore_impl()) {
            String fileName;
            SerializableScheme serializableScheme;
            T t = scheme3;
            if (!(t instanceof SerializableScheme)) {
                t = null;
            }
            if ((serializableScheme = (SerializableScheme)t) == null || (serializableScheme = serializableScheme.getSchemeState()) == null) {
                serializableScheme = this.getProcessor$intellij_platform_configurationStore_impl().getState(scheme3);
            }
            Intrinsics.checkNotNullExpressionValue((Object)serializableScheme, (String)"(scheme as? Serializable\u2026rocessor.getState(scheme)");
            Iterator state = serializableScheme;
            if (state == SchemeState.NON_PERSISTENT) continue;
            hasSchemes = true;
            if (state != SchemeState.UNCHANGED) {
                T t2 = scheme3;
                if (t2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type MUTABLE_SCHEME");
                }
                changedSchemes.add(t2);
            }
            if ((fileName = this.getFileName$intellij_platform_configurationStore_impl(scheme3)) == null || this.isRenamed(scheme3)) continue;
            nameGenerator.addExistingName(fileName);
        }
        HashSet filesToDelete = new HashSet(this.filesToDelete);
        for (Object scheme22 : changedSchemes) {
            try {
                Object object = scheme22;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scheme");
                this.saveScheme(object, nameGenerator, filesToDelete);
            }
            catch (Throwable e) {
                errors.add(new RuntimeException("Cannot save scheme " + this.fileSpec + '/' + scheme22, e));
            }
        }
        scheme22 = filesToDelete;
        boolean state = false;
        if (!scheme22.isEmpty()) {
            Iterator iterator;
            Iterator iterator2 = iterator = this.schemeToInfo.values().iterator();
            boolean bl = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                ExternalInfo info = (ExternalInfo)iterator3.next();
                if (!filesToDelete.contains(info.getFileName())) continue;
                iterator.remove();
            }
            this.filesToDelete.removeAll(filesToDelete);
            this.deleteFiles(errors, filesToDelete);
            if (!(hasSchemes || this.provider != null && this.provider.isApplicable(this.fileSpec, this.roamingType))) {
                this.removeDirectoryIfEmpty(errors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDirectoryIfEmpty(List<Throwable> errors) {
        Path $this$directoryStreamIfExists$iv = this.ioDirectory;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                boolean bl3 = false;
                Iterator iterator = it.iterator();
                while (iterator.hasNext()) {
                    Path file;
                    Path path = file = (Path)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                    if (PathKt.isHidden((Path)path)) continue;
                    ComponentStoreImplKt.getLOG().info("Directory " + this.ioDirectory.getFileName() + " is not deleted: at least one file " + file.getFileName() + " exists");
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        ComponentStoreImplKt.getLOG().info("Remove scheme directory " + this.ioDirectory.getFileName());
        if (this.isUseVfs()) {
            VirtualFile dir = this.getVirtualDirectory$intellij_platform_configurationStore_impl(StateStorageOperation.WRITE);
            this.cachedVirtualDirectory = null;
            if (dir != null) {
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, dir, errors){
                    final /* synthetic */ SchemeManagerImpl this$0;
                    final /* synthetic */ VirtualFile $dir$inlined;
                    final /* synthetic */ List $errors$inlined;
                    {
                        this.this$0 = schemeManagerImpl;
                        this.$dir$inlined = virtualFile;
                        this.$errors$inlined = list;
                    }

                    public final T compute() {
                        Object object;
                        boolean bl = false;
                        try {
                            this.$dir$inlined.delete((Object)((Object)this.this$0));
                            object = Unit.INSTANCE;
                        }
                        catch (IOException e) {
                            object = this.$errors$inlined.add(e);
                        }
                        return (T)object;
                    }
                });
            }
        } else {
            List<Throwable> $this$catch$iv = errors;
            boolean $i$f$catch = false;
            try {
                boolean bl = false;
                PathKt.delete$default((Path)this.ioDirectory, (boolean)false, (int)1, null);
            }
            catch (Throwable e$iv) {
                $this$catch$iv.add(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveScheme(MUTABLE_SCHEME scheme2, UniqueNameGenerator nameGenerator, Set<String> filesToDelete) {
        boolean renamed;
        Element element;
        Element element2;
        ExternalInfo externalInfo;
        ExternalInfo externalInfo2 = externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme2);
        String currentFileNameWithoutExtension = externalInfo2 != null ? externalInfo2.getFileNameWithoutExtension() : null;
        Parent parent = this.getProcessor$intellij_platform_configurationStore_impl().writeScheme(scheme2);
        if (parent != null) {
            Parent parent2 = parent;
            boolean bl = false;
            boolean bl2 = false;
            Parent it = parent2;
            boolean bl3 = false;
            Parent parent3 = it;
            if (!(parent3 instanceof Element)) {
                parent3 = null;
            }
            if ((element2 = (Element)parent3) == null) {
                Parent parent4 = it;
                if (parent4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jdom.Document");
                }
                element2 = ((Document)parent4).detachRootElement();
            }
        } else {
            element2 = element = null;
        }
        if (JdomKt.isEmpty(element)) {
            ExternalInfo externalInfo3 = externalInfo;
            if (externalInfo3 != null) {
                externalInfo3.scheduleDelete(filesToDelete, "empty");
            }
            return;
        }
        String fileNameWithoutExtension = currentFileNameWithoutExtension;
        if (fileNameWithoutExtension == null || this.isRenamed(scheme2)) {
            fileNameWithoutExtension = nameGenerator.generateUniqueName((String)this.schemeNameToFileName.invoke((Object)this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2)));
        }
        String fileName = fileNameWithoutExtension + this.schemeExtension;
        filesToDelete.remove(fileName);
        Element element3 = element;
        Intrinsics.checkNotNull((Object)element3);
        byte[] newDigest = Scheme_implKt.digest$default((Element)element3, null, (int)1, null);
        if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && externalInfo.isDigestEquals(newDigest)) {
            return;
        }
        if (this.isEqualToBundledScheme(externalInfo, newDigest, scheme2, filesToDelete)) {
            return;
        }
        if (this.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor && ((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl()).isSchemeDefault(scheme2, newDigest)) {
            ExternalInfo externalInfo4 = externalInfo;
            if (externalInfo4 != null) {
                externalInfo4.scheduleDelete(filesToDelete, "equals to default");
            }
            return;
        }
        BufferExposingByteArrayOutputStream byteOut = JdomKt.toBufferExposingByteArray$default((Element)element, null, (int)1, null);
        String providerPath = null;
        if (this.provider != null && this.provider.getEnabled()) {
            providerPath = this.fileSpec + '/' + fileName;
            if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                providerPath = null;
            }
        } else {
            providerPath = null;
        }
        boolean bl = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && currentFileNameWithoutExtension != null && nameGenerator.isUnique(currentFileNameWithoutExtension);
        if (providerPath == null) {
            if (this.isUseVfs()) {
                void file;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                VirtualFile dir = this.getVirtualDirectory$intellij_platform_configurationStore_impl(StateStorageOperation.WRITE);
                if (dir == null || !dir.isValid()) {
                    this.cachedVirtualDirectory = dir = SchemeLoaderKt.createDir(this.ioDirectory, this);
                }
                if (renamed) {
                    ExternalInfo externalInfo5 = externalInfo;
                    Intrinsics.checkNotNull((Object)externalInfo5);
                    VirtualFile oldFile = dir.findChild(externalInfo5.getFileName());
                    if (oldFile != null) {
                        if (dir.findChild(fileName) == null) {
                            boolean $i$f$runWriteAction = false;
                            ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, oldFile, fileName){
                                final /* synthetic */ SchemeManagerImpl this$0;
                                final /* synthetic */ VirtualFile $oldFile$inlined;
                                final /* synthetic */ String $fileName$inlined;
                                {
                                    this.this$0 = schemeManagerImpl;
                                    this.$oldFile$inlined = virtualFile;
                                    this.$fileName$inlined = string;
                                }

                                public final T compute() {
                                    boolean bl = false;
                                    this.$oldFile$inlined.rename((Object)((Object)this.this$0), this.$fileName$inlined);
                                    return (T)Unit.INSTANCE;
                                }
                            });
                            file.element = oldFile;
                        } else {
                            externalInfo.scheduleDelete(filesToDelete, "renamed");
                        }
                    }
                }
                if ((VirtualFile)file.element == null) {
                    file.element = SchemeLoaderKt.getOrCreateChild(dir, fileName, this);
                }
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, (Ref.ObjectRef)file, byteOut){
                    final /* synthetic */ SchemeManagerImpl this$0;
                    final /* synthetic */ Ref.ObjectRef $file$inlined;
                    final /* synthetic */ BufferExposingByteArrayOutputStream $byteOut$inlined;
                    {
                        this.this$0 = schemeManagerImpl;
                        this.$file$inlined = objectRef;
                        this.$byteOut$inlined = bufferExposingByteArrayOutputStream;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final T compute() {
                        boolean bl = false;
                        Closeable closeable = ((VirtualFile)this.$file$inlined.element).getOutputStream((Object)((Object)this.this$0));
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Throwable throwable = null;
                        try {
                            OutputStream it = (OutputStream)closeable;
                            boolean bl4 = false;
                            this.$byteOut$inlined.writeTo(it);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            } else {
                if (renamed) {
                    ExternalInfo externalInfo6 = externalInfo;
                    Intrinsics.checkNotNull((Object)externalInfo6);
                    externalInfo6.scheduleDelete(filesToDelete, "renamed");
                }
                Path path = this.ioDirectory.resolve(fileName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ioDirectory.resolve(fileName)");
                byte[] byArray = byteOut.getInternalBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteOut.internalBuffer");
                PathKt.write((Path)path, (byte[])byArray, (int)0, (int)byteOut.size());
            }
        } else {
            if (renamed) {
                ExternalInfo externalInfo7 = externalInfo;
                Intrinsics.checkNotNull((Object)externalInfo7);
                externalInfo7.scheduleDelete(filesToDelete, "renamed");
            }
            StreamProvider streamProvider = this.provider;
            Intrinsics.checkNotNull((Object)streamProvider);
            byte[] byArray = byteOut.getInternalBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteOut.internalBuffer");
            streamProvider.write(providerPath, byArray, byteOut.size(), this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeToInfo.put(scheme2, externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setDigest(newDigest);
        externalInfo.setSchemeKey(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2));
    }

    private final boolean isEqualToBundledScheme(ExternalInfo externalInfo, byte[] newDigest, MUTABLE_SCHEME scheme2, Set<String> filesToDelete) {
        Function1 $fun$serializeIfPossible$1 = new Function1<T, Element>(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            @Nullable
            public final Element invoke(@NotNull T scheme2) {
                Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
                Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
                boolean $i$f$runAndLogException = false;
                boolean bl = false;
                try {
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    T t = scheme2;
                    if (t == null) {
                        return null;
                    }
                    T bundledAsMutable = t;
                    Parent parent = this.this$0.getProcessor$intellij_platform_configurationStore_impl().writeScheme(bundledAsMutable);
                    if (parent == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jdom.Element");
                    }
                    return (Element)parent;
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                    return null;
                }
            }
            {
                this.this$0 = schemeManagerImpl;
                super(1);
            }
        };
        T bundledScheme = this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().get(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2));
        if (bundledScheme == null) {
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            if (!(schemeProcessor instanceof LazySchemeProcessor)) {
                schemeProcessor = null;
            }
            LazySchemeProcessor lazySchemeProcessor = (LazySchemeProcessor)schemeProcessor;
            if (lazySchemeProcessor != null) {
                if (lazySchemeProcessor.isSchemeEqualToBundled(scheme2)) {
                    ExternalInfo externalInfo2 = externalInfo;
                    if (externalInfo2 != null) {
                        externalInfo2.scheduleDelete(filesToDelete, "equals to bundled");
                    }
                    return true;
                }
            }
            return false;
        }
        ExternalInfo externalInfo3 = (ExternalInfo)this.schemeToInfo.get(bundledScheme);
        if (externalInfo3 == null) {
            return false;
        }
        ExternalInfo bundledExternalInfo = externalInfo3;
        if (bundledExternalInfo.getDigest() == null) {
            Element element = $fun$serializeIfPossible$1.invoke(bundledScheme);
            if (element != null) {
                Element element2 = element;
                boolean bl = false;
                boolean bl2 = false;
                Element it = element2;
                boolean bl3 = false;
                bundledExternalInfo.setDigest(Scheme_implKt.digest$default((Element)it, null, (int)1, null));
            } else {
                return false;
            }
        }
        if (bundledExternalInfo.isDigestEquals(newDigest)) {
            ExternalInfo externalInfo4 = externalInfo;
            if (externalInfo4 != null) {
                externalInfo4.scheduleDelete(filesToDelete, "equals to bundled");
            }
            return true;
        }
        return false;
    }

    private final boolean isRenamed(T scheme2) {
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(scheme2);
        return info != null && Intrinsics.areEqual((Object)this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2), (Object)info.getSchemeKey()) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteFiles(List<Throwable> errors, Set<String> filesToDelete) {
        Logger logger;
        Logger $this$debug$iv;
        if (this.provider != null) {
            Iterator<String> iterator;
            Iterator<String> iterator2 = iterator = filesToDelete.iterator();
            boolean bl = false;
            Iterator<String> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                String name = iterator3.next();
                List<Throwable> $this$catch$iv = errors;
                boolean $i$f$catch = false;
                try {
                    boolean bl2 = false;
                    String spec = this.fileSpec + '/' + name;
                    if (!this.provider.delete(spec, this.roamingType)) continue;
                    $this$debug$iv = ComponentStoreImplKt.getLOG();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        logger = $this$debug$iv;
                        boolean bl3 = false;
                        String string = spec + " deleted from provider " + this.provider;
                        logger.debug(string, (Throwable)e$iv);
                    }
                    iterator.remove();
                }
                catch (Throwable e$iv) {
                    $this$catch$iv.add(e$iv);
                }
            }
        }
        if (filesToDelete.isEmpty()) {
            return;
        }
        Logger $this$debug$iv2 = ComponentStoreImplKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            Logger logger2 = $this$debug$iv2;
            boolean bl = false;
            String string = "Delete scheme files: " + CollectionsKt.joinToString$default((Iterable)filesToDelete, null, null, null, (int)0, null, null, (int)63, null);
            logger2.debug(string, (Throwable)e$iv);
        }
        if (this.isUseVfs()) {
            VirtualFile virtualFile = this.getVirtualDirectory$intellij_platform_configurationStore_impl(StateStorageOperation.WRITE);
            if (virtualFile != null) {
                void $this$filterTo$iv$iv;
                $this$debug$iv2 = virtualFile;
                boolean bl = false;
                $i$f$debug = false;
                Logger virtualDir = $this$debug$iv2;
                boolean bl4 = false;
                Logger logger3 = virtualDir.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"virtualDir.children");
                Object $this$filter$iv = logger3;
                boolean $i$f$filter = false;
                $this$debug$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                logger = $this$filterTo$iv$iv;
                int n = ((void)logger).length;
                for (int i = 0; i < n; ++i) {
                    Logger element$iv$iv;
                    Logger it = element$iv$iv = logger[i];
                    boolean bl5 = false;
                    Logger logger4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"it");
                    if (!filesToDelete.contains(logger4.getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List childrenToDelete = (List)destination$iv$iv;
                $this$filter$iv = childrenToDelete;
                boolean bl6 = false;
                if (!$this$filter$iv.isEmpty()) {
                    boolean $i$f$runWriteAction = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable<T>(childrenToDelete, this, filesToDelete, errors){
                        final /* synthetic */ List $childrenToDelete$inlined;
                        final /* synthetic */ SchemeManagerImpl this$0;
                        final /* synthetic */ Set $filesToDelete$inlined;
                        final /* synthetic */ List $errors$inlined;
                        {
                            this.$childrenToDelete$inlined = list;
                            this.this$0 = schemeManagerImpl;
                            this.$filesToDelete$inlined = set;
                            this.$errors$inlined = list2;
                        }

                        public final T compute() {
                            boolean bl = false;
                            for (VirtualFile file : this.$childrenToDelete$inlined) {
                                List $this$catch$iv = this.$errors$inlined;
                                boolean $i$f$catch = false;
                                try {
                                    boolean bl2 = false;
                                    file.delete((Object)((Object)this.this$0));
                                }
                                catch (Throwable e$iv) {
                                    $this$catch$iv.add(e$iv);
                                }
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
                return;
            }
        }
        for (String name : filesToDelete) {
            List<Throwable> $this$catch$iv = errors;
            boolean $i$f$catch = false;
            try {
                boolean bl = false;
                Path path = this.ioDirectory.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"ioDirectory.resolve(name)");
                PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
            }
            catch (Throwable e$iv2) {
                $this$catch$iv.add(e$iv2);
            }
        }
    }

    @Nullable
    public final VirtualFile getVirtualDirectory$intellij_platform_configurationStore_impl(@NotNull StateStorageOperation reasonOperation) {
        Intrinsics.checkNotNullParameter((Object)reasonOperation, (String)"reasonOperation");
        VirtualFile result = this.cachedVirtualDirectory;
        if (result == null) {
            String path = PathKt.getSystemIndependentPath((Path)this.ioDirectory);
            VirtualFileResolver virtualFileResolver = this.virtualFileResolver;
            this.cachedVirtualDirectory = result = virtualFileResolver == null ? LocalFileSystem.getInstance().findFileByPath(path) : this.virtualFileResolver.resolveVirtualFile(path, reasonOperation);
        }
        return result;
    }

    public void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Predicate<T> removeCondition) {
        Intrinsics.checkNotNullParameter(newSchemes, (String)"newSchemes");
        this.schemeListManager.setSchemes(newSchemes, (T)newCurrentScheme, (Predicate<? extends T>)removeCondition);
    }

    /*
     * WARNING - void declaration
     */
    public final void retainExternalInfo$intellij_platform_configurationStore_impl(boolean isScheduleToDelete) {
        Iterator iterator;
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        Iterator iterator2 = iterator = this.schemeToInfo.entrySet().iterator();
        boolean bl = false;
        Iterator iterator3 = iterator2;
        block0: while (iterator3.hasNext()) {
            void scheme2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator3.next();
            boolean bl2 = false;
            iterator2 = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ExternalInfo info = (ExternalInfo)entry2.getValue();
            ConcurrentHashMap<String, T> concurrentHashMap = this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl();
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            void v2 = scheme2;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"scheme");
            if (concurrentHashMap.get(schemeProcessor.getSchemeKey((Object)v2)) == scheme2) continue;
            for (T s : this.getSchemes$intellij_platform_configurationStore_impl()) {
                if (s != scheme2) continue;
                this.filesToDelete.remove(info.getFileName());
                continue block0;
            }
            iterator.remove();
            if (!isScheduleToDelete) continue;
            info.scheduleDelete(this.filesToDelete, "requested to delete");
        }
    }

    public void addScheme(@NotNull T scheme2, boolean replaceExisting) {
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        this.schemeListManager.addScheme(scheme2, replaceExisting);
    }

    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        T t;
        block1: {
            Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
            Iterable $this$firstOrNull$iv = this.getSchemes$intellij_platform_configurationStore_impl();
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it), (Object)schemeName)) continue;
                t = element$iv;
                break block1;
            }
            t = null;
        }
        return t;
    }

    @Nullable
    public T removeScheme(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.removeFirstScheme$intellij_platform_configurationStore_impl(true, (Function1)new Function1<T, Boolean>(this, name){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)this.this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it), (Object)this.$name);
            }
            {
                this.this$0 = schemeManagerImpl;
                this.$name = string;
                super(1);
            }
        });
    }

    public boolean removeScheme(@NotNull T scheme2) {
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        return this.removeScheme(scheme2, true);
    }

    public final boolean removeScheme(@NotNull T scheme2, boolean isScheduleToDelete) {
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        return this.removeFirstScheme$intellij_platform_configurationStore_impl(isScheduleToDelete, (Function1)new Function1<T, Boolean>(scheme2){
            final /* synthetic */ Object $scheme;

            public final boolean invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it == this.$scheme;
            }
            {
                this.$scheme = object;
                super(1);
            }
        }) != null;
    }

    public boolean isMetadataEditable(@NotNull T scheme2) {
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        return !this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().containsKey(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2));
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    @Nullable
    public final T removeFirstScheme$intellij_platform_configurationStore_impl(boolean isScheduleToDelete, @NotNull Function1<? super T, Boolean> condition) {
        Iterator<T> iterator;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Iterator<T> iterator2 = iterator = this.getSchemes$intellij_platform_configurationStore_impl().iterator();
        boolean bl = false;
        Iterator<T> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            T scheme2 = iterator3.next();
            if (!((Boolean)condition.invoke(scheme2)).booleanValue()) continue;
            if (this.getActiveScheme() == scheme2) {
                this.setActiveScheme$intellij_platform_configurationStore_impl(null);
            }
            iterator.remove();
            if (isScheduleToDelete && this.getProcessor$intellij_platform_configurationStore_impl().isExternalizable(scheme2)) {
                ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.remove(scheme2);
                if (externalInfo != null) {
                    externalInfo.scheduleDelete(this.filesToDelete, "requested to delete (removeFirstScheme)");
                }
            }
            return scheme2;
        }
        return null;
    }

    @NotNull
    public final String getFileSpec() {
        return this.fileSpec;
    }

    @NotNull
    public final Path getIoDirectory$intellij_platform_configurationStore_impl() {
        return this.ioDirectory;
    }

    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    public final String getPresentableName() {
        return this.presentableName;
    }

    public SchemeManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<T, ? super MUTABLE_SCHEME> processor2, @Nullable StreamProvider provider, @NotNull Path ioDirectory, @NotNull RoamingType roamingType, @Nullable String presentableName, @NotNull Function1<? super String, String> schemeNameToFileName, @Nullable Function1<? super SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber, @Nullable VirtualFileResolver virtualFileResolver) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)ioDirectory, (String)"ioDirectory");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(schemeNameToFileName, (String)"schemeNameToFileName");
        super(processor2);
        this.fileSpec = fileSpec;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.roamingType = roamingType;
        this.presentableName = presentableName;
        this.schemeNameToFileName = schemeNameToFileName;
        this.fileChangeSubscriber = fileChangeSubscriber;
        this.virtualFileResolver = virtualFileResolver;
        this.isOldSchemeNaming = Intrinsics.areEqual(this.schemeNameToFileName, (Object)Scheme_implKt.getOLD_NAME_CONVERTER());
        this.isLoadingSchemes = new AtomicBoolean();
        this.schemeListManager = new SchemeListManager(this);
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.newSetFromMap(ConcurrentHashMap())");
        this.filesToDelete = set;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentCollectionFact\u2026ityMap<T, ExternalInfo>()");
        this.schemeToInfo = concurrentMap;
        if (processor2 instanceof SchemeExtensionProvider) {
            this.schemeExtension = ((SchemeExtensionProvider)processor2).getSchemeExtension();
            this.updateExtension = true;
        } else {
            this.schemeExtension = ".xml";
            this.updateExtension = false;
        }
        if (this.isUseVfs()) {
            Object object;
            Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
            boolean $i$f$runAndLogException = false;
            boolean bl = false;
            try {
                object = Result.Companion;
                boolean bl2 = false;
                boolean bl3 = false;
                this.refreshVirtualDirectory();
                Unit unit = Unit.INSTANCE;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
    }

    public /* synthetic */ SchemeManagerImpl(String string, SchemeProcessor schemeProcessor, StreamProvider streamProvider, Path path, RoamingType roamingType, String string2, Function1 function1, Function1 function12, VirtualFileResolver virtualFileResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        if ((n & 0x40) != 0) {
            function1 = Scheme_implKt.getCURRENT_NAME_CONVERTER();
        }
        if ((n & 0x80) != 0) {
            function12 = null;
        }
        if ((n & 0x100) != 0) {
            virtualFileResolver = null;
        }
        this(string, schemeProcessor, streamProvider, path, roamingType, string2, (Function1<? super String, String>)function1, function12, virtualFileResolver);
    }

    public static final /* synthetic */ StreamProvider access$getProvider$p(SchemeManagerImpl $this) {
        return $this.provider;
    }
}

