/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.Nullable;

public class VcsScopeItem
implements ModelScopeItem {
    private final ChangeListManager myChangeListManager;
    private final DefaultComboBoxModel<LocalChangeList> myModel;
    private final Project myProject;

    @Nullable
    public static VcsScopeItem createIfHasVCS(Project project) {
        if (ChangeListManager.getInstance((Project)project).getAffectedFiles().isEmpty()) {
            return null;
        }
        return new VcsScopeItem(project);
    }

    public VcsScopeItem(Project project) {
        this.myProject = project;
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        assert (!this.myChangeListManager.getAffectedFiles().isEmpty());
        if (this.myChangeListManager.areChangeListsEnabled()) {
            this.myModel = new DefaultComboBoxModel();
            this.myModel.addElement(null);
            List changeLists = this.myChangeListManager.getChangeLists();
            for (LocalChangeList changeList : changeLists) {
                this.myModel.addElement(changeList);
            }
        } else {
            this.myModel = null;
        }
    }

    public AnalysisScope getScope() {
        LocalChangeList list;
        ChangeList changeList;
        ChangeList changeList2 = changeList = this.myModel != null ? (ChangeList)this.myModel.getSelectedItem() : null;
        List files = changeList == null ? this.myChangeListManager.getAffectedFiles() : ((list = this.myChangeListManager.findChangeList(changeList.getName())) != null ? ChangesUtil.getAfterRevisionsFiles(list.getChanges().stream()).collect(Collectors.toList()) : Collections.emptyList());
        return new AnalysisScope(this.myProject, new HashSet(files));
    }

    @Nullable
    public DefaultComboBoxModel<LocalChangeList> getChangeListsModel() {
        return this.myModel;
    }
}

