/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.impl.VcsSelectionHistoryDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;

public class SelectedBlockHistoryAction
extends AbstractVcsAction {
    protected boolean isEnabled(VcsContext context) {
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
        if (selection == null) {
            return false;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        if (file == null) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (activeVcs == null) {
            return false;
        }
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        if (provider == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    @Override
    public void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        assert (project != null);
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
        assert (selection != null);
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        assert (file != null);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        assert (activeVcs != null);
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        assert (provider != null);
        int selectionStart = selection.getSelectionStartLineNumber();
        int selectionEnd = selection.getSelectionEndLineNumber();
        VcsSelectionHistoryDialog dialog = new VcsSelectionHistoryDialog(project, file, selection.getDocument(), provider, activeVcs, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), selection.getDialogTitle());
        dialog.show();
    }

    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        Editor editor;
        if (context == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(2);
        }
        if ((editor = context.getEditor()) == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabled(this.isEnabled(context));
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
        if (selection != null) {
            presentation.setText(selection.getActionName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

