/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcs.log.ui.frame.VcsLogCommitDetailsListPanel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogUiUtil {
    @NotNull
    public static JComponent installProgress(@NotNull JComponent component, final @NotNull VcsLogData logData, final @NotNull String logId, @NotNull Disposable disposableParent) {
        if (component == null) {
            VcsLogUiUtil.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogUiUtil.$$$reportNull$$$0(1);
        }
        if (logId == null) {
            VcsLogUiUtil.$$$reportNull$$$0(2);
        }
        if (disposableParent == null) {
            VcsLogUiUtil.$$$reportNull$$$0(3);
        }
        final ProgressStripe progressStripe = new ProgressStripe(component, disposableParent, 300){

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.myDecorator != null && logData.getProgress().isRunning()) {
                    this.startLoadingImmediately();
                }
            }
        };
        logData.getProgress().addProgressIndicatorListener(new VcsLogProgress.ProgressListener(){

            @Override
            public void progressStarted(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
                if (keys == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (VcsLogUiUtil.isProgressVisible(keys, logId)) {
                    progressStripe.startLoading();
                }
            }

            @Override
            public void progressChanged(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
                if (keys == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (VcsLogUiUtil.isProgressVisible(keys, logId)) {
                    progressStripe.startLoading();
                } else {
                    progressStripe.stopLoading();
                }
            }

            @Override
            public void progressStopped() {
                progressStripe.stopLoading();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "keys";
                objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUiUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "progressStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "progressChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposableParent);
        ProgressStripe progressStripe2 = progressStripe;
        if (progressStripe2 == null) {
            VcsLogUiUtil.$$$reportNull$$$0(4);
        }
        return progressStripe2;
    }

    public static boolean isProgressVisible(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys, @NotNull String logId) {
        if (keys == null) {
            VcsLogUiUtil.$$$reportNull$$$0(5);
        }
        if (logId == null) {
            VcsLogUiUtil.$$$reportNull$$$0(6);
        }
        if (keys.contains(VcsLogData.DATA_PACK_REFRESH)) {
            return true;
        }
        return ContainerUtil.find(keys, key -> VisiblePackRefresherImpl.isVisibleKeyFor(key, logId)) != null;
    }

    @NotNull
    public static JScrollPane setupScrolledGraph(@NotNull VcsLogGraphTable graphTable, int border) {
        if (graphTable == null) {
            VcsLogUiUtil.$$$reportNull$$$0(7);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable), (int)border);
        ComponentUtil.putClientProperty((JComponent)scrollPane, (Key)UIUtil.KEEP_BORDER_SIDES, (Object)2);
        graphTable.viewportSet(scrollPane.getViewport());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            VcsLogUiUtil.$$$reportNull$$$0(8);
        }
        return jScrollPane;
    }

    public static void installDetailsListeners(@NotNull VcsLogGraphTable graphTable, @NotNull VcsLogCommitDetailsListPanel detailsPanel, @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        if (graphTable == null) {
            VcsLogUiUtil.$$$reportNull$$$0(9);
        }
        if (detailsPanel == null) {
            VcsLogUiUtil.$$$reportNull$$$0(10);
        }
        if (logData == null) {
            VcsLogUiUtil.$$$reportNull$$$0(11);
        }
        if (disposableParent == null) {
            VcsLogUiUtil.$$$reportNull$$$0(12);
        }
        Runnable miniDetailsLoadedListener = () -> {
            graphTable.reLayout();
            graphTable.repaint();
        };
        Runnable containingBranchesListener = () -> {
            detailsPanel.branchesChanged();
            graphTable.repaint();
        };
        logData.getMiniDetailsGetter().addDetailsLoadedListener(miniDetailsLoadedListener);
        logData.getContainingBranchesGetter().addTaskCompletedListener(containingBranchesListener);
        Disposer.register((Disposable)disposableParent, () -> {
            logData.getContainingBranchesGetter().removeTaskCompletedListener(containingBranchesListener);
            logData.getMiniDetailsGetter().removeDetailsLoadedListener(miniDetailsLoadedListener);
        });
    }

    @NotNull
    public static SimpleTextAttributes getLinkAttributes() {
        return new SimpleTextAttributes(0, JBUI.CurrentTheme.Link.linkColor());
    }

    public static void showTooltip(@NotNull JComponent component, @NotNull Point point, @NotNull Balloon.Position position, @NotNull @NlsContexts.Tooltip String text2) {
        if (component == null) {
            VcsLogUiUtil.$$$reportNull$$$0(13);
        }
        if (point == null) {
            VcsLogUiUtil.$$$reportNull$$$0(14);
        }
        if (position == null) {
            VcsLogUiUtil.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            VcsLogUiUtil.$$$reportNull$$$0(16);
        }
        JEditorPane tipComponent = IdeTooltipManager.initPane((String)text2, (HintHint)new HintHint((Component)component, point).setAwtTooltip(true), null);
        IdeTooltip tooltip = new IdeTooltip((Component)component, point, (JComponent)new Wrapper((JComponent)tipComponent), new Object[0]).setPreferredPosition(position).setToCenter(false).setToCenterIfSmall(false);
        IdeTooltipManager.getInstance().show(tooltip, false);
    }

    @NotNull
    public static History installNavigationHistory(@NotNull AbstractVcsLogUi ui2) {
        if (ui2 == null) {
            VcsLogUiUtil.$$$reportNull$$$0(17);
        }
        History history = new History((Place.Navigator)new VcsLogPlaceNavigator(ui2));
        ui2.getTable().getSelectionModel().addListSelectionListener(e -> {
            if (!history.isNavigatingNow() && !e.getValueIsAdjusting()) {
                history.pushQueryPlace();
            }
        });
        History history2 = history;
        if (history2 == null) {
            VcsLogUiUtil.$$$reportNull$$$0(18);
        }
        return history2;
    }

    @NotNull
    @Nls
    public static String shortenTextToFit(@NotNull @Nls String text2, @NotNull FontMetrics fontMetrics, int availableWidth, int maxLength, @NotNull @Nls String symbol) {
        if (text2 == null) {
            VcsLogUiUtil.$$$reportNull$$$0(19);
        }
        if (fontMetrics == null) {
            VcsLogUiUtil.$$$reportNull$$$0(20);
        }
        if (symbol == null) {
            VcsLogUiUtil.$$$reportNull$$$0(21);
        }
        if (fontMetrics.stringWidth(text2) <= availableWidth) {
            String string = text2;
            if (string == null) {
                VcsLogUiUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        for (int i = text2.length(); i > maxLength; --i) {
            String result2 = StringUtil.shortenTextWithEllipsis((String)text2, (int)i, (int)0, (String)symbol);
            if (fontMetrics.stringWidth(result2) > availableWidth) continue;
            String string = result2;
            if (string == null) {
                VcsLogUiUtil.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)text2, (int)maxLength, (int)0, (String)symbol);
        if (string == null) {
            VcsLogUiUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static int getHorizontalTextPadding(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            VcsLogUiUtil.$$$reportNull$$$0(25);
        }
        Insets borderInsets = component.getMyBorder().getBorderInsets((Component)component);
        Insets ipad = component.getIpad();
        return borderInsets.left + borderInsets.right + ipad.left + ipad.right;
    }

    public static void appendActionToEmptyText(@Nls @NotNull StatusText emptyText, @Nls @NotNull String text2, @NotNull Runnable action) {
        if (emptyText == null) {
            VcsLogUiUtil.$$$reportNull$$$0(26);
        }
        if (text2 == null) {
            VcsLogUiUtil.$$$reportNull$$$0(27);
        }
        if (action == null) {
            VcsLogUiUtil.$$$reportNull$$$0(28);
        }
        emptyText.appendSecondaryText(text2, VcsLogUiUtil.getLinkAttributes(), e -> action.run());
    }

    public static void appendResetFiltersActionToEmptyText(@NotNull VcsLogFilterUiEx filterUi, @Nls @NotNull StatusText emptyText) {
        if (filterUi == null) {
            VcsLogUiUtil.$$$reportNull$$$0(29);
        }
        if (emptyText == null) {
            VcsLogUiUtil.$$$reportNull$$$0(30);
        }
        VcsLogUiUtil.appendActionToEmptyText(emptyText, VcsLogBundle.message((String)"vcs.log.reset.filters.status.action", (Object[])new Object[0]), filterUi::clearFilters);
    }

    public static boolean isDiffPreviewInEditor() {
        return Registry.is((String)"vcs.log.show.diff.preview.as.editor.tab");
    }

    @NotNull
    public static Dimension expandToFitToolbar(@NotNull Dimension size, @NotNull JComponent toolbar) {
        if (size == null) {
            VcsLogUiUtil.$$$reportNull$$$0(31);
        }
        if (toolbar == null) {
            VcsLogUiUtil.$$$reportNull$$$0(32);
        }
        Dimension preferredSize = toolbar.getPreferredSize();
        int minToolbarSize = Math.round((float)Math.min(preferredSize.width, preferredSize.height) * 1.5f);
        return new Dimension(Math.max(size.width, minToolbarSize), Math.max(size.height, minToolbarSize));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/VcsLogUiUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphTable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 16: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUiUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "installProgress";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setupScrolledGraph";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "installNavigationHistory";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextToFit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installProgress";
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isProgressVisible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupScrolledGraph";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installDetailsListeners";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "installNavigationHistory";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextToFit";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getHorizontalTextPadding";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendActionToEmptyText";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "appendResetFiltersActionToEmptyText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "expandToFitToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class VcsLogPlaceNavigator
    implements Place.Navigator {
        @NonNls
        private static final String PLACE_KEY = "Vcs.Log.Ui.History.PlaceKey";
        @NotNull
        private final AbstractVcsLogUi myUi;

        private VcsLogPlaceNavigator(@NotNull AbstractVcsLogUi ui2) {
            if (ui2 == null) {
                VcsLogPlaceNavigator.$$$reportNull$$$0(0);
            }
            this.myUi = ui2;
        }

        public final void queryPlace(@NotNull Place place) {
            List commits;
            if (place == null) {
                VcsLogPlaceNavigator.$$$reportNull$$$0(1);
            }
            if ((commits = this.myUi.getVcsLog().getSelectedCommits()).size() > 0) {
                place.putPath(PLACE_KEY, commits.get(0));
            }
        }

        public final ActionCallback navigateTo(@Nullable Place place, final boolean requestFocus) {
            if (place == null) {
                return ActionCallback.DONE;
            }
            Object value = place.getPath(PLACE_KEY);
            if (!(value instanceof CommitId)) {
                return ActionCallback.REJECTED;
            }
            CommitId commitId = (CommitId)value;
            final ActionCallback callback2 = new ActionCallback();
            ListenableFuture<Boolean> future2 = ((VcsLogImpl)this.myUi.getVcsLog()).jumpToCommit(commitId.getHash(), commitId.getRoot());
            Futures.addCallback(future2, (FutureCallback)new FutureCallback<Boolean>(){

                public void onSuccess(Boolean success2) {
                    if (success2.booleanValue()) {
                        if (requestFocus) {
                            myUi.getTable().requestFocusInWindow();
                        }
                        callback2.setDone();
                    } else {
                        callback2.setRejected();
                    }
                }

                public void onFailure(Throwable t) {
                    callback2.setRejected();
                }
            }, (Executor)EdtExecutorService.getInstance());
            return callback2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/util/VcsLogUiUtil$VcsLogPlaceNavigator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "queryPlace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

