/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.status.StatusType;

public class CommandUtil {
    private static final Logger LOG = Logger.getInstance(CommandUtil.class);
    private static final Map<Class<?>, JAXBContext> cachedContexts = new ConcurrentHashMap();
    @NonNls
    private static final String IGNORE_SPACE_CHANGE_DIFF_EXTENSION = "--ignore-space-change";
    @NonNls
    private static final String IGNORE_ALL_SPACE_DIFF_EXTENSION = "--ignore-all-space";
    @NonNls
    private static final String IGNORE_EOL_STYLE_DIFF_EXTENSION = "--ignore-eol-style";

    public static void put(@NotNull List<? super String> parameters, boolean condition, @NonNls @NotNull String value) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(0);
        }
        if (value == null) {
            CommandUtil.$$$reportNull$$$0(1);
        }
        if (condition) {
            parameters.add(value);
        }
    }

    public static void put(@NotNull List<? super String> parameters, String ... values) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(2);
        }
        if (values == null) {
            CommandUtil.$$$reportNull$$$0(3);
        }
        ContainerUtil.addAll(parameters, (Object[])values);
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(4);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(5);
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), Revision.UNDEFINED);
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path, boolean usePegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(6);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(7);
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, path);
        } else {
            parameters.add(path.getAbsolutePath());
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path, @Nullable Revision pegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(8);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(9);
        }
        CommandUtil.put(parameters, path.getAbsolutePath(), pegRevision);
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull String path, @Nullable Revision pegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(10);
        }
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(11);
        }
        parameters.add(CommandUtil.format(path, pegRevision));
    }

    @NotNull
    public static String format(@NotNull String path, @Nullable Revision pegRevision) {
        boolean hasPegRevision;
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(12);
        }
        StringBuilder builder = new StringBuilder(path);
        boolean hasAtSymbol = path.contains("@");
        boolean bl = hasPegRevision = pegRevision != null && !Revision.UNDEFINED.equals(pegRevision) && !Revision.WORKING.equals(pegRevision) && pegRevision.isValid();
        if (hasPegRevision || hasAtSymbol) {
            builder.append("@");
        }
        if (hasPegRevision) {
            builder.append(CommandUtil.format(pegRevision));
        }
        String string = builder.toString();
        if (string == null) {
            CommandUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Target target) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(14);
        }
        if (target == null) {
            CommandUtil.$$$reportNull$$$0(15);
        }
        CommandUtil.put(parameters, target.getPath(), target.getPegRevision());
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Target target, boolean usePegRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(16);
        }
        if (target == null) {
            CommandUtil.$$$reportNull$$$0(17);
        }
        if (usePegRevision) {
            CommandUtil.put(parameters, target);
        } else {
            parameters.add(target.getPath());
        }
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Depth depth) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(18);
        }
        CommandUtil.put(parameters, depth, false);
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Depth depth, boolean sticky) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(19);
        }
        if (depth != null && !Depth.UNKNOWN.equals((Object)depth)) {
            CommandUtil.put(parameters, "--depth", depth.getName());
            if (sticky) {
                CommandUtil.put(parameters, "--set-depth", depth.getName());
            }
        }
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Revision revision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(20);
        }
        if (revision != null && !Revision.UNDEFINED.equals(revision) && !Revision.WORKING.equals(revision) && revision.isValid()) {
            CommandUtil.put(parameters, "--revision", CommandUtil.format(revision));
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Revision startRevision, @NotNull Revision endRevision) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(21);
        }
        if (startRevision == null) {
            CommandUtil.$$$reportNull$$$0(22);
        }
        if (endRevision == null) {
            CommandUtil.$$$reportNull$$$0(23);
        }
        CommandUtil.put(parameters, "--revision", CommandUtil.format(startRevision) + ":" + CommandUtil.format(endRevision));
    }

    @NotNull
    public static String format(@NotNull Revision revision) {
        if (revision == null) {
            CommandUtil.$$$reportNull$$$0(24);
        }
        Object object = revision.getDate() != null ? "{" + DateFormatUtil.getIso8601Format().format(revision.getDate()) + "}" : revision.toString();
        if (object == null) {
            CommandUtil.$$$reportNull$$$0(25);
        }
        return object;
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable DiffOptions diffOptions) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(26);
        }
        if (diffOptions == null) {
            return;
        }
        List<String> extensions = Arrays.asList(diffOptions.isIgnoreAllWhitespace() ? IGNORE_SPACE_CHANGE_DIFF_EXTENSION : null, diffOptions.isIgnoreAmountOfWhitespace() ? IGNORE_ALL_SPACE_DIFF_EXTENSION : null, diffOptions.isIgnoreEOLStyle() ? IGNORE_EOL_STYLE_DIFF_EXTENSION : null);
        String value = StringUtil.join(extensions, (String)" ");
        if (!StringUtil.isEmpty((String)value)) {
            CommandUtil.put(parameters, "--extensions", value);
        }
    }

    public static void putChangeLists(@NotNull List<? super String> parameters, @Nullable Iterable<String> changeLists) {
        if (parameters == null) {
            CommandUtil.$$$reportNull$$$0(27);
        }
        if (changeLists == null) {
            return;
        }
        for (String changeList : changeLists) {
            CommandUtil.put(parameters, "--cl", changeList);
        }
    }

    public static String escape(@NotNull String path) {
        if (path == null) {
            CommandUtil.$$$reportNull$$$0(28);
        }
        return path.contains("@") ? path + "@" : path;
    }

    public static <T> T parse(@NotNull String data, @NotNull Class<T> type) throws JAXBException {
        if (data == null) {
            CommandUtil.$$$reportNull$$$0(29);
        }
        if (type == null) {
            CommandUtil.$$$reportNull$$$0(30);
        }
        if (!cachedContexts.containsKey(type)) {
            cachedContexts.put(type, JAXBContext.newInstance((Class[])new Class[]{type}));
        }
        JAXBContext context = cachedContexts.get(type);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(@NotNull ValidationEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                return event.getLinkedException() == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/commandLine/CommandUtil$1", "handleEvent"));
            }
        });
        return (T)unmarshaller.unmarshal((Reader)new StringReader(data.trim()));
    }

    @NotNull
    public static File getHomeDirectory() {
        return new File(PathManager.getHomePath());
    }

    public static char getStatusChar(@Nullable String type) {
        return !StringUtil.isEmpty((String)type) ? type.charAt(0) : (char)' ';
    }

    @NotNull
    public static StatusType getStatusType(@Nullable String type) {
        return CommandUtil.getStatusType(CommandUtil.getStatusChar(type));
    }

    @NotNull
    public static StatusType getStatusType(char first) {
        StatusType contentsStatus = 'A' == first ? StatusType.STATUS_ADDED : ('D' == first ? StatusType.STATUS_DELETED : ('U' == first ? StatusType.CHANGED : ('C' == first ? StatusType.CONFLICTED : ('G' == first ? StatusType.MERGED : ('R' == first ? StatusType.STATUS_REPLACED : ('E' == first ? StatusType.STATUS_OBSTRUCTED : StatusType.STATUS_NORMAL))))));
        StatusType statusType = contentsStatus;
        if (statusType == null) {
            CommandUtil.$$$reportNull$$$0(31);
        }
        return statusType;
    }

    @Nullable
    public static File findExistingParent(@Nullable File file) {
        while (file != null) {
            if (file.exists() && file.isDirectory()) {
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    @NotNull
    public static File requireExistingParent(@NotNull File file) {
        File result;
        if (file == null) {
            CommandUtil.$$$reportNull$$$0(32);
        }
        if ((result = CommandUtil.findExistingParent(file)) == null) {
            LOG.error("Existing parent not found for " + file.getAbsolutePath());
        }
        File file2 = Objects.requireNonNull(result);
        if (file2 == null) {
            CommandUtil.$$$reportNull$$$0(33);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 25: 
            case 31: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 25: 
            case 31: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 25: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/CommandUtil";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRevision";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endRevision";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/CommandUtil";
                break;
            }
            case 13: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "requireExistingParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 12: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 13: 
            case 25: 
            case 31: 
            case 33: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putChangeLists";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "requireExistingParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 25: 
            case 31: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

