/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.html.impl.util.MicrodataUtil;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.documentation.MimeTypeDictionary;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final String[] TARGET = new String[]{"_blank", "_top", "_self", "_parent"};
    public static final String[] ENCTYPE = new String[]{"multipart/form-data", "application/x-www-form-urlencoded"};
    public static final String[] REL = new String[]{"alternate", "author", "bookmark", "help", "icon", "license", "next", "nofollow", "noreferrer", "noopener", "prefetch", "prev", "search", "stylesheet", "tag", "start", "contents", "index", "glossary", "copyright", "chapter", "section", "subsection", "appendix", "script", "import", "apple-touch-icon", "apple-touch-icon-precomposed", "apple-touch-startup-image"};
    public static final String[] MEDIA = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
    public static final String[] LANGUAGE = new String[]{"JavaScript", "VBScript", "JScript", "JavaScript1.2", "JavaScript1.3", "JavaScript1.4", "JavaScript1.5"};
    public static final String[] TYPE = new String[]{"text/css", "text/html", "text/plain", "text/xml"};
    public static final String[] SANDBOX = new String[]{"allow-forms", "allow-pointer-lock", "allow-popups", "allow-same-origin", "allow-scripts", "allow-top-navigation"};
    public static final String[] LANG = new String[]{"aa", "ab", "ae", "af", "ak", "am", "an", "ar", "as", "av", "ay", "az", "ba", "be", "bg", "bh", "bi", "bm", "bn", "bo", "br", "bs", "ca", "ce", "ch", "co", "cr", "cs", "cu", "cv", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "gv", "ha", "he", "hi", "ho", "hr", "ht", "hu", "hy", "hz", "ia", "id", "ie", "ig", "ii", "ik", "io", "is", "it", "iu", "ja", "jv", "ka", "kg", "ki", "kj", "kk", "kl", "km", "kn", "ko", "kr", "ks", "ku", "kv", "kw", "ky", "la", "lb", "lg", "li", "ln", "lo", "lt", "lu", "lv", "mg", "mh", "mi", "mk", "ml", "mn", "mr", "ms", "mt", "my", "na", "nb", "nd", "ne", "ng", "nl", "nn", "no", "nr", "nv", "ny", "oc", "oj", "om", "or", "os", "pa", "pi", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sc", "sd", "se", "sg", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ty", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "za", "zh", "zu"};

    public HtmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement position;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!HtmlCompletionContributor.hasHtmlAttributesCompletion(position = parameters.getPosition())) {
                    return;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttributeValue.class, (boolean)false);
                if (attributeValue != null && attributeValue.getParent() instanceof XmlAttribute) {
                    for (String element : HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)attributeValue.getParent())) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)element));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean hasHtmlAttributesCompletion(PsiElement position) {
        if (PsiTreeUtil.getParentOfType((PsiElement)position, HtmlTag.class, (boolean)false) != null) {
            return true;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)position, XmlTag.class, (boolean)false);
        return xmlTag != null && xmlTag.getLanguage() == XHTMLLanguage.INSTANCE;
    }

    public static @NonNls String @NotNull [] addSpecificCompletions(XmlAttribute attribute) {
        String namespace;
        @NonNls String name = attribute.getName();
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                HtmlCompletionContributor.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        @NonNls String tagName = tag.getName();
        if (tag.getDescriptor() instanceof HtmlElementDescriptorImpl) {
            name = StringUtil.toLowerCase((String)name);
            tagName = StringUtil.toLowerCase((String)tagName);
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace = tag.getNamespace()) || "http://www.w3.org/1999/html".equals(namespace)) {
            if ("target".equals(name) || "formtarget".equals(name)) {
                if (TARGET == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(1);
                }
                return TARGET;
            }
            if (("lang".equals(name) || "xml:lang".equals(name)) && tagName.equalsIgnoreCase("html")) {
                if (LANG == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(2);
                }
                return LANG;
            }
            if ("enctype".equals(name)) {
                if (ENCTYPE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(3);
                }
                return ENCTYPE;
            }
            if ("rel".equals(name) || "rev".equals(name)) {
                if (REL == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(4);
                }
                return REL;
            }
            if ("media".equals(name)) {
                if (MEDIA == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(5);
                }
                return MEDIA;
            }
            if ("language".equals(name)) {
                if (LANGUAGE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(6);
                }
                return LANGUAGE;
            }
            if ("sandbox".equals(name)) {
                if (SANDBOX == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(7);
                }
                return SANDBOX;
            }
            if ("type".equals(name) && "link".equals(tagName)) {
                if (TYPE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(8);
                }
                return TYPE;
            }
            if ("http-equiv".equals(name) && "meta".equals(tagName)) {
                if (HtmlUtil.RFC2616_HEADERS == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(9);
                }
                return HtmlUtil.RFC2616_HEADERS;
            }
            if ("content".equals(name) && "meta".equals(tagName) && tag.getAttribute("name") == null) {
                if (MimeTypeDictionary.HTML_CONTENT_TYPES == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(10);
                }
                return MimeTypeDictionary.HTML_CONTENT_TYPES;
            }
            if ("accept".equals(name) && "input".equals(tagName)) {
                if (MimeTypeDictionary.HTML_CONTENT_TYPES == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(11);
                }
                return MimeTypeDictionary.HTML_CONTENT_TYPES;
            }
            if ("accept-charset".equals(name) || "charset".equals(name)) {
                Charset[] charSets = CharsetToolkit.getAvailableCharsets();
                String[] names = new String[charSets.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = charSets[i].toString();
                }
                if (names == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(12);
                }
                return names;
            }
            if ("itemprop".equals(name) && !DumbService.isDumb((Project)attribute.getProject())) {
                XmlTag scopeTag = MicrodataUtil.findScopeTag(tag);
                String[] stringArray = scopeTag != null ? HtmlCompletionContributor.findItemProperties(scopeTag) : ArrayUtilRt.EMPTY_STRING_ARRAY;
                if (stringArray == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(13);
                }
                return stringArray;
            }
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(14);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static String[] findItemProperties(@NotNull XmlTag tag) {
        XmlAttribute typeAttribute;
        if (tag == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(15);
        }
        if ((typeAttribute = tag.getAttribute("itemtype")) != null) {
            XmlAttributeValue valueElement = typeAttribute.getValueElement();
            PsiReference[] references = valueElement != null ? valueElement.getReferences() : PsiReference.EMPTY_ARRAY;
            ArrayList<String> result = new ArrayList<String>();
            for (PsiReference reference : references) {
                PsiElement target;
                PsiElement psiElement = target = reference != null ? reference.resolve() : null;
                if (!(target instanceof PsiFile)) continue;
                result.addAll(MicrodataUtil.extractProperties((PsiFile)target, StringUtil.unquoteString((String)reference.getCanonicalText())));
            }
            return ArrayUtilRt.toStringArray(result);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/HtmlCompletionContributor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addSpecificCompletions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findItemProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

