/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SaveAsTemplateAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(SaveAsTemplateAction.class);

    @NotNull
    @VisibleForTesting
    public static String suggestTemplateText(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            SaveAsTemplateAction.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            SaveAsTemplateAction.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitAllDocuments();
        TextRange selection = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        PsiElement[] psiElements = PsiTreeUtil.collectElements((PsiElement)file2, element2 -> selection.contains(element2.getTextRange()));
        Document document = EditorFactory.getInstance().createDocument((CharSequence)selection.substring(editor.getDocument().getText()));
        boolean isXml = file2.getLanguage().is(StdLanguages.XML);
        int offsetDelta = editor.getSelectionModel().getSelectionStart();
        WriteCommandAction.writeCommandAction((Project)file2.getProject()).withName(null).run(() -> {
            HashMap<RangeMarker, String> rangeToText = new HashMap<RangeMarker, String>();
            for (PsiElement element2 : psiElements) {
                for (PsiReference reference2 : element2.getReferences()) {
                    if (reference2 instanceof PsiQualifiedReference && ((PsiQualifiedReference)reference2).getQualifier() != null) continue;
                    String canonicalText = reference2.getCanonicalText();
                    TextRange referenceRange = reference2.getRangeInElement();
                    if (referenceRange.isEmpty()) continue;
                    TextRange elementTextRange = element2.getTextRange();
                    LOG.assertTrue(elementTextRange != null, (Object)elementTextRange);
                    TextRange range2 = elementTextRange.cutOut(referenceRange).shiftRight(-offsetDelta);
                    String oldText = document.getText(range2);
                    int pos = canonicalText.indexOf(60);
                    if (pos > 0 && !oldText.contains("<")) {
                        canonicalText = canonicalText.substring(0, pos);
                    }
                    if (isXml && (pos = canonicalText.lastIndexOf(58)) >= 0 && pos < canonicalText.length() - 1 && !oldText.contains(":")) {
                        canonicalText = canonicalText.substring(pos + 1);
                    }
                    if (canonicalText.equals(oldText)) continue;
                    rangeToText.put(document.createRangeMarker(range2), canonicalText);
                }
            }
            ArrayList<RangeMarker> markers = new ArrayList<RangeMarker>();
            for (RangeMarker m1 : rangeToText.keySet()) {
                boolean nested = false;
                for (RangeMarker m2 : rangeToText.keySet()) {
                    if (m1 == m2 || m2.getStartOffset() > m1.getStartOffset() || m1.getEndOffset() > m2.getEndOffset()) continue;
                    nested = true;
                    break;
                }
                if (nested) continue;
                markers.add(m1);
            }
            for (RangeMarker marker : markers) {
                String value2 = (String)rangeToText.get(marker);
                document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)value2);
            }
        });
        String string = document.getText().trim();
        if (string == null) {
            SaveAsTemplateAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveAsTemplateAction.$$$reportNull$$$0(3);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = Objects.requireNonNull((Editor)CommonDataKeys.EDITOR.getData(dataContext));
        PsiFile file2 = Objects.requireNonNull((PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        String templateText = SaveAsTemplateAction.suggestTemplateText(editor, file2);
        final TemplateImpl template = new TemplateImpl("<abbreviation>", templateText, "user");
        template.setToReformat(true);
        OffsetKey startKey = OffsetKey.create((String)"pivot");
        OffsetsInFile offsets2 = new OffsetsInFile(file2);
        offsets2.getOffsets().addOffset(startKey, editor.getSelectionModel().getSelectionStart());
        OffsetsInFile copy2 = TemplateManagerImpl.copyWithDummyIdentifier(offsets2, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
        Set<TemplateContextType> applicable = TemplateManagerImpl.getApplicableContextTypes(TemplateActionContext.expanding((PsiFile)copy2.getFile(), (int)copy2.getOffsets().getOffset(startKey)));
        for (TemplateContextType contextType : TemplateManagerImpl.getAllContextTypes()) {
            template.getTemplateContext().setEnabled(contextType, applicable.contains(contextType));
        }
        final LiveTemplatesConfigurable configurable2 = new LiveTemplatesConfigurable();
        SingleConfigurableEditor dialog2 = new SingleConfigurableEditor(file2.getProject(), (Configurable)configurable2, DialogWrapper.IdeModalityType.MODELESS);
        new UiNotifyConnector.Once((Component)dialog2.getContentPane(), new Activatable(){

            public void showNotify() {
                configurable2.getTemplateListPanel().addTemplate(template);
            }
        });
        dialog2.setTitle(e.getPresentation().getText());
        dialog2.show();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveAsTemplateAction.$$$reportNull$$$0(4);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file2 == null || editor == null) {
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabled(editor.getSelectionModel().hasSelection());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/actions/SaveAsTemplateAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/actions/SaveAsTemplateAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestTemplateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestTemplateText";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

