/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.parser.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 @2\u00020\u0001:\u0001@Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*2\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0003J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\tJ\u0015\u00109\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\u00020\r2\u0006\u0010+\u001a\u00020,2\u0006\u00108\u001a\u00020\tJ\u0010\u0010<\u001a\u0004\u0018\u00010\u00002\u0006\u0010+\u001a\u00020,J\b\u0010=\u001a\u00020\tH\u0016J\u0006\u0010>\u001a\u000205J\u0006\u0010?\u001a\u000205R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001dR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0019\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\f\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b$\u0010\u001fR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b%\u0010&R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001b\u00a8\u0006A"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "", "name", "", "id", "", "superClassId", "classLoaderId", "instanceSize", "", "superClassOffset", "refInstanceFields", "", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "primitiveInstanceFields", "constantFields", "", "objectStaticFields", "Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "primitiveStaticFields", "(Ljava/lang/String;JJJII[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;[J[Lcom/intellij/diagnostic/hprof/classstore/StaticField;[Lcom/intellij/diagnostic/hprof/classstore/StaticField;)V", "getClassLoaderId", "()J", "getConstantFields", "()[J", "getId", "getInstanceSize", "()I", "getName", "()Ljava/lang/String;", "getObjectStaticFields", "()[Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "[Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "prettyName", "getPrettyName", "[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "getPrimitiveStaticFields", "getRefInstanceFields", "()[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "getSuperClassId", "getSuperClassOffset", "allRefFieldNames", "", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "computeOffsetOfField", "fieldName", "copyWithName", "newName", "copyWithRemappedIDs", "remappingFunction", "Ljava/util/function/LongUnaryOperator;", "equals", "", "other", "getClassFieldName", "index", "getPrimitiveStaticFieldValue", "(Ljava/lang/String;)Ljava/lang/Long;", "getRefField", "getSuperClass", "hashCode", "isArray", "isPrimitiveArray", "Companion", "intellij.platform.ide.impl"})
public final class ClassDefinition {
    @NotNull
    private final String name;
    private final long id;
    private final long superClassId;
    private final long classLoaderId;
    private final int instanceSize;
    private final int superClassOffset;
    @NotNull
    private final InstanceField[] refInstanceFields;
    private final InstanceField[] primitiveInstanceFields;
    @NotNull
    private final long[] constantFields;
    @NotNull
    private final StaticField[] objectStaticFields;
    @NotNull
    private final StaticField[] primitiveStaticFields;
    public static final int OBJECT_PREAMBLE_SIZE = 8;
    public static final int ARRAY_PREAMBLE_SIZE = 12;
    @NotNull
    private static final InstanceField CLASS_FIELD;
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.diagnostic.hprof.classstore.ClassDefinition");
        }
        ClassDefinition cfr_ignored_0 = (ClassDefinition)object2;
        if (this.id != ((ClassDefinition)other).id) {
            return false;
        }
        if (this.id == 0L && ((ClassDefinition)other).id == 0L) {
            return Intrinsics.areEqual((Object)this.name, (Object)((ClassDefinition)other).name);
        }
        return true;
    }

    @NotNull
    public final String getPrettyName() {
        return Companion.computePrettyName(this.name);
    }

    @Nullable
    public final ClassDefinition getSuperClass(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        long l = this.superClassId;
        return l == 0L ? null : classStore.get((int)this.superClassId);
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public final boolean isArray() {
        return this.name.charAt(0) == '[';
    }

    public final boolean isPrimitiveArray() {
        return this.isArray() && this.name.length() == 2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassDefinition copyWithRemappedIDs(@NotNull LongUnaryOperator remappingFunction) {
        int n;
        Object[] objectArray;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)remappingFunction, (String)"remappingFunction");
        Function1<Long, Long> $fun$map$1 = new Function1<Long, Long>(remappingFunction){
            final /* synthetic */ LongUnaryOperator $remappingFunction;

            public final long invoke(long id2) {
                return this.$remappingFunction.applyAsLong(id2);
            }
            {
                this.$remappingFunction = longUnaryOperator;
                super(1);
            }
        };
        int n4 = this.constantFields.length;
        long[] lArray = new long[n4];
        int n5 = 0;
        while (n5 < n4) {
            void it;
            long l;
            n3 = n5;
            n2 = n5++;
            objectArray = lArray;
            n = 0;
            objectArray[n2] = l = $fun$map$1.invoke(this.constantFields[it]);
        }
        long[] newConstantFields = lArray;
        int n6 = this.objectStaticFields.length;
        StaticField[] staticFieldArray = new StaticField[n6];
        n3 = 0;
        while (n3 < n6) {
            void it;
            n = n3;
            n2 = n3++;
            objectArray = staticFieldArray;
            boolean bl = false;
            StaticField oldStaticField = this.objectStaticFields[it];
            StaticField staticField = new StaticField(oldStaticField.getName(), $fun$map$1.invoke(oldStaticField.getValue()));
            objectArray[n2] = (long)staticField;
        }
        StaticField[] newStaticObjectFields = staticFieldArray;
        return new ClassDefinition(this.name, $fun$map$1.invoke(this.id), $fun$map$1.invoke(this.superClassId), $fun$map$1.invoke(this.classLoaderId), this.instanceSize, this.superClassOffset, this.refInstanceFields, this.primitiveInstanceFields, newConstantFields, newStaticObjectFields, this.primitiveStaticFields);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allRefFieldNames(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        boolean bl = false;
        List result2 = new ArrayList();
        ClassDefinition currentClass = this;
        while (true) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InstanceField[] instanceFieldArray = currentClass.refInstanceFields;
            List list2 = result2;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var9_10 = $this$mapTo$iv$iv;
            int n = ((void)var9_10).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var13_14 = item$iv$iv = var9_10[j];
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            list2.addAll((Collection)collection);
            if (currentClass.getSuperClass(classStore) != null) continue;
            break;
        }
        return result2;
    }

    @NotNull
    public final InstanceField getRefField(@NotNull ClassStore classStore, int index) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        int currentIndex = index;
        ClassDefinition currentClass = this;
        while (true) {
            int size;
            if (currentIndex < (size = currentClass.refInstanceFields.length)) {
                return currentClass.refInstanceFields[currentIndex];
            }
            currentIndex -= size;
            if (currentClass.getSuperClass(classStore) != null) continue;
            break;
        }
        if (currentIndex == 0) {
            return CLASS_FIELD;
        }
        throw (Throwable)new IndexOutOfBoundsException(index + " on class " + this.name);
    }

    @NotNull
    public final String getClassFieldName(int index) {
        int n = index;
        if (0 <= n && this.constantFields.length > n) {
            return "<constant>";
        }
        n = index;
        if (this.constantFields.length <= n && this.constantFields.length + this.objectStaticFields.length > n) {
            return this.objectStaticFields[index - this.constantFields.length].getName();
        }
        if (index == this.constantFields.length + this.objectStaticFields.length) {
            return "<loader>";
        }
        throw (Throwable)new IndexOutOfBoundsException(index + " on class " + this.name);
    }

    @Nullable
    public final Long getPrimitiveStaticFieldValue(@NotNull String name) {
        StaticField staticField;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            StaticField[] staticFieldArray = this.primitiveStaticFields;
            boolean bl = false;
            StaticField[] staticFieldArray2 = staticFieldArray;
            boolean bl2 = false;
            StaticField[] staticFieldArray3 = staticFieldArray2;
            int n = staticFieldArray3.length;
            for (int j = 0; j < n; ++j) {
                StaticField staticField2;
                StaticField it = staticField2 = staticFieldArray3[j];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                staticField = staticField2;
                break block1;
            }
            staticField = null;
        }
        return staticField != null ? Long.valueOf(staticField.getValue()) : null;
    }

    public final int computeOffsetOfField(@NotNull String fieldName, @NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        int classOffset = 0;
        ClassDefinition currentClass = this;
        while (true) {
            InstanceField field;
            block6: {
                InstanceField it;
                InstanceField instanceField;
                int n;
                int n2;
                InstanceField[] instanceFieldArray;
                boolean bl;
                InstanceField[] instanceFieldArray2;
                boolean bl2;
                InstanceField[] instanceFieldArray3;
                block5: {
                    InstanceField instanceField2;
                    instanceFieldArray3 = currentClass.refInstanceFields;
                    bl2 = false;
                    instanceFieldArray2 = instanceFieldArray3;
                    bl = false;
                    instanceFieldArray = instanceFieldArray2;
                    n2 = instanceFieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = instanceField = instanceFieldArray[n];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) continue;
                        instanceField2 = instanceField;
                        break block5;
                    }
                    instanceField2 = field = null;
                }
                if (field == null) {
                    InstanceField instanceField3;
                    instanceFieldArray3 = currentClass.primitiveInstanceFields;
                    bl2 = false;
                    instanceFieldArray2 = instanceFieldArray3;
                    bl = false;
                    instanceFieldArray = instanceFieldArray2;
                    n2 = instanceFieldArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = instanceField = instanceFieldArray[n];
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) continue;
                        instanceField3 = instanceField;
                        break block6;
                    }
                    instanceField3 = field = null;
                }
            }
            if (field != null) {
                return classOffset + field.getOffset();
            }
            classOffset += currentClass.superClassOffset;
            if (currentClass.getSuperClass(classStore) != null) continue;
            return -1;
        }
    }

    @NotNull
    public final ClassDefinition copyWithName(@NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        return new ClassDefinition(newName2, this.id, this.superClassId, this.classLoaderId, this.instanceSize, this.superClassOffset, this.refInstanceFields, this.primitiveInstanceFields, this.constantFields, this.objectStaticFields, this.primitiveStaticFields);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getId() {
        return this.id;
    }

    public final long getSuperClassId() {
        return this.superClassId;
    }

    public final long getClassLoaderId() {
        return this.classLoaderId;
    }

    public final int getInstanceSize() {
        return this.instanceSize;
    }

    public final int getSuperClassOffset() {
        return this.superClassOffset;
    }

    @NotNull
    public final InstanceField[] getRefInstanceFields() {
        return this.refInstanceFields;
    }

    @NotNull
    public final long[] getConstantFields() {
        return this.constantFields;
    }

    @NotNull
    public final StaticField[] getObjectStaticFields() {
        return this.objectStaticFields;
    }

    @NotNull
    public final StaticField[] getPrimitiveStaticFields() {
        return this.primitiveStaticFields;
    }

    public ClassDefinition(@NotNull String name, long id2, long superClassId, long classLoaderId, int instanceSize, int superClassOffset, @NotNull InstanceField[] refInstanceFields, @NotNull InstanceField[] primitiveInstanceFields, @NotNull long[] constantFields, @NotNull StaticField[] objectStaticFields, @NotNull StaticField[] primitiveStaticFields) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)refInstanceFields, (String)"refInstanceFields");
        Intrinsics.checkNotNullParameter((Object)primitiveInstanceFields, (String)"primitiveInstanceFields");
        Intrinsics.checkNotNullParameter((Object)constantFields, (String)"constantFields");
        Intrinsics.checkNotNullParameter((Object)objectStaticFields, (String)"objectStaticFields");
        Intrinsics.checkNotNullParameter((Object)primitiveStaticFields, (String)"primitiveStaticFields");
        this.name = name;
        this.id = id2;
        this.superClassId = superClassId;
        this.classLoaderId = classLoaderId;
        this.instanceSize = instanceSize;
        this.superClassOffset = superClassOffset;
        this.refInstanceFields = refInstanceFields;
        this.primitiveInstanceFields = primitiveInstanceFields;
        this.constantFields = constantFields;
        this.objectStaticFields = objectStaticFields;
        this.primitiveStaticFields = primitiveStaticFields;
    }

    static {
        Companion = new Companion(null);
        CLASS_FIELD = new InstanceField("<class>", -1, Type.OBJECT);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition$Companion;", "", "()V", "ARRAY_PREAMBLE_SIZE", "", "CLASS_FIELD", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "getCLASS_FIELD", "()Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "OBJECT_PREAMBLE_SIZE", "computePrettyName", "", "name", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NonNls
        @NotNull
        public final String computePrettyName(@NotNull String name) {
            String string;
            int arraySymbolsCount;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (!StringsKt.startsWith$default((CharSequence)name, (char)'[', (boolean)false, (int)2, null)) {
                return name;
            }
            for (arraySymbolsCount = 0; name.length() > arraySymbolsCount && name.charAt(arraySymbolsCount) == '['; ++arraySymbolsCount) {
            }
            if (name.length() <= arraySymbolsCount) {
                return name;
            }
            char arrayType = name.charAt(arraySymbolsCount);
            String arrayString = StringsKt.repeat((CharSequence)"[]", (int)arraySymbolsCount);
            switch (arrayType) {
                case 'B': {
                    string = "byte" + arrayString;
                    break;
                }
                case 'C': {
                    string = "char" + arrayString;
                    break;
                }
                case 'D': {
                    string = "double" + arrayString;
                    break;
                }
                case 'F': {
                    string = "float" + arrayString;
                    break;
                }
                case 'I': {
                    string = "int" + arrayString;
                    break;
                }
                case 'J': {
                    string = "long" + arrayString;
                    break;
                }
                case 'L': {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = name;
                    int n = arraySymbolsCount + 1;
                    int n2 = name.length() - 1;
                    boolean bl = false;
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = stringBuilder.append(string3).append(arrayString).toString();
                    break;
                }
                case 'S': {
                    string = "short" + arrayString;
                    break;
                }
                case 'Z': {
                    string = "boolean" + arrayString;
                    break;
                }
                default: {
                    string = name;
                }
            }
            return string;
        }

        @NotNull
        public final InstanceField getCLASS_FIELD() {
            return CLASS_FIELD;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

