/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferableFileEditorStateSupport {
    @NotNull
    private static final Key<MyState> TRANSFERABLE_FILE_EDITOR_STATE = Key.create((String)"Diff.TransferableFileEditorState");
    private static final Condition<BinaryEditorHolder> IS_SUPPORTED = holder -> TransferableFileEditorStateSupport.getEditorState(holder.getEditor()) != null;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<? extends BinaryEditorHolder> myHolders;
    @NotNull
    private final List<? extends FileEditor> myEditors;
    private final boolean mySupported;
    private int myMasterIndex;
    private boolean myDuringUpdate;

    public TransferableFileEditorStateSupport(@NotNull DiffSettingsHolder.DiffSettings settings, @NotNull List<? extends BinaryEditorHolder> holders, @NotNull Disposable disposable2) {
        if (settings == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(0);
        }
        if (holders == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(2);
        }
        this.myMasterIndex = 0;
        this.myDuringUpdate = true;
        this.mySettings = settings;
        this.myHolders = holders;
        this.myEditors = ContainerUtil.map((Collection)ContainerUtil.filter(holders, IS_SUPPORTED), holder -> holder.getEditor());
        this.mySupported = this.myEditors.size() > 0;
        new MySynchronizer().install(disposable2);
    }

    public boolean isSupported() {
        return this.mySupported;
    }

    public boolean isEnabled() {
        return this.mySettings.isSyncBinaryEditorSettings();
    }

    public void setEnabled(boolean enabled) {
        this.mySettings.setSyncBinaryEditorSettings(enabled);
    }

    public void syncStatesNow() {
        if (this.myEditors.size() < 2) {
            return;
        }
        FileEditor masterEditor = this.myHolders.get(this.myMasterIndex).getEditor();
        this.syncStateFrom(masterEditor);
    }

    @NotNull
    public AnAction createToggleAction() {
        return new ToggleSynchronousEditorStatesAction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(3);
        }
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(4);
        }
        this.myDuringUpdate = false;
        if (!this.isEnabled()) {
            return;
        }
        MyState state = (MyState)context.getUserData(TRANSFERABLE_FILE_EDITOR_STATE);
        if (state == null) {
            return;
        }
        int newMasterIndex = state.getMasterIndex();
        if (newMasterIndex < this.myHolders.size()) {
            this.myMasterIndex = newMasterIndex;
        }
        try {
            this.myDuringUpdate = true;
            for (BinaryEditorHolder binaryEditorHolder : this.myHolders) {
                state.restoreContextData(binaryEditorHolder.getEditor());
            }
            this.syncStatesNow();
        }
        finally {
            this.myDuringUpdate = false;
        }
    }

    public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(5);
        }
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(6);
        }
        if (!this.isEnabled()) {
            return;
        }
        MyState state = new MyState(this.myMasterIndex);
        context.putUserData(TRANSFERABLE_FILE_EDITOR_STATE, (Object)state);
        state.storeContextData(this.myHolders.get(this.myMasterIndex).getEditor());
        for (BinaryEditorHolder binaryEditorHolder : this.myHolders) {
            state.storeContextData(binaryEditorHolder.getEditor());
        }
    }

    private void syncStateFrom(@NotNull FileEditor sourceEditor) {
        TransferableFileEditorState sourceState;
        if (sourceEditor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(7);
        }
        if ((sourceState = TransferableFileEditorStateSupport.getEditorState(sourceEditor)) == null) {
            return;
        }
        Map options2 = sourceState.getTransferableOptions();
        String id2 = sourceState.getEditorId();
        for (FileEditor fileEditor : this.myEditors) {
            if (sourceEditor == fileEditor) continue;
            this.updateEditor(fileEditor, id2, options2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(@NotNull FileEditor editor, @NotNull String id2, @NotNull Map<String, String> options2) {
        if (editor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(8);
        }
        if (id2 == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(9);
        }
        if (options2 == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(10);
        }
        try {
            this.myDuringUpdate = true;
            TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(editor);
            if (state != null && state.getEditorId().equals(id2)) {
                state.setTransferableOptions(options2);
                state.setCopiedFromMasterEditor();
                editor.setState((FileEditorState)state);
            }
        }
        finally {
            this.myDuringUpdate = false;
        }
    }

    @Nullable
    private static TransferableFileEditorState getEditorState(@NotNull FileEditor editor) {
        FileEditorState state;
        if (editor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(11);
        }
        return (state = editor.getState(FileEditorStateLevel.FULL)) instanceof TransferableFileEditorState ? (TransferableFileEditorState)state : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processContextHints";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateContextHints";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "syncStateFrom";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyState {
        private final Map<String, Map<String, String>> myMap = new HashMap<String, Map<String, String>>();
        private final int myMasterIndex;

        MyState(int masterIndex) {
            this.myMasterIndex = masterIndex;
        }

        public int getMasterIndex() {
            return this.myMasterIndex;
        }

        public void restoreContextData(@NotNull FileEditor editor) {
            TransferableFileEditorState editorState;
            if (editor == null) {
                MyState.$$$reportNull$$$0(0);
            }
            if ((editorState = TransferableFileEditorStateSupport.getEditorState(editor)) == null) {
                return;
            }
            Map<String, String> options2 = this.myMap.get(editorState.getEditorId());
            if (options2 == null) {
                return;
            }
            editorState.setTransferableOptions(options2);
            editor.setState((FileEditorState)editorState);
        }

        public void storeContextData(@NotNull FileEditor editor) {
            TransferableFileEditorState editorState;
            if (editor == null) {
                MyState.$$$reportNull$$$0(1);
            }
            if ((editorState = TransferableFileEditorStateSupport.getEditorState(editor)) == null) {
                return;
            }
            if (!this.myMap.containsKey(editorState.getEditorId())) {
                this.myMap.put(editorState.getEditorId(), editorState.getTransferableOptions());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "editor";
            objectArray2[1] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MyState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreContextData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeContextData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToggleSynchronousEditorStatesAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final TransferableFileEditorStateSupport mySupport;

        ToggleSynchronousEditorStatesAction(@NotNull TransferableFileEditorStateSupport support) {
            if (support == null) {
                ToggleSynchronousEditorStatesAction.$$$reportNull$$$0(0);
            }
            super(DiffBundle.message((String)"synchronize.editors.settings", (Object[])new Object[0]), AllIcons.Actions.SyncPanels);
            this.mySupport = support;
        }

        public boolean isVisible() {
            return this.mySupport.isSupported();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySupport.isEnabled();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySupport.setEnabled(state);
            if (state) {
                this.mySupport.syncStatesNow();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$ToggleSynchronousEditorStatesAction", "<init>"));
        }
    }

    private class MySynchronizer
    implements PropertyChangeListener {
        private MySynchronizer() {
        }

        public void install(@NotNull Disposable disposable2) {
            if (disposable2 == null) {
                MySynchronizer.$$$reportNull$$$0(0);
            }
            if (TransferableFileEditorStateSupport.this.myEditors.size() < 2) {
                return;
            }
            for (FileEditor fileEditor : TransferableFileEditorStateSupport.this.myEditors) {
                fileEditor.addPropertyChangeListener((PropertyChangeListener)this);
            }
            Disposer.register((Disposable)disposable2, (Disposable)new Disposable(){

                public void dispose() {
                    for (FileEditor fileEditor : TransferableFileEditorStateSupport.this.myEditors) {
                        fileEditor.removePropertyChangeListener((PropertyChangeListener)MySynchronizer.this);
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TransferableFileEditorStateSupport.this.myDuringUpdate || !TransferableFileEditorStateSupport.this.isEnabled()) {
                return;
            }
            if (!(evt.getSource() instanceof FileEditor)) {
                return;
            }
            FileEditor editor = (FileEditor)evt.getSource();
            if (!editor.getComponent().isShowing()) {
                return;
            }
            Dimension size = editor.getComponent().getSize();
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            int holderIndex = ContainerUtil.indexOf(TransferableFileEditorStateSupport.this.myHolders, holder -> editor.equals(holder.getEditor()));
            if (holderIndex != -1) {
                TransferableFileEditorStateSupport.this.myMasterIndex = holderIndex;
            }
            TransferableFileEditorStateSupport.this.syncStateFrom(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer", "install"));
        }
    }
}

