/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.TreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FavoritesListNode
extends AbstractTreeNode<String> {
    private static final Logger LOGGER = Logger.getInstance(FavoritesListNode.class);
    private final String myDescription;

    public FavoritesListNode(Project project, @NotNull String listName, String description) {
        if (listName == null) {
            FavoritesListNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)listName);
        this.myName = listName;
        this.myDescription = description;
    }

    public FavoritesListNode(Project project, @NotNull String listName) {
        if (listName == null) {
            FavoritesListNode.$$$reportNull$$$0(1);
        }
        this(project, listName, null);
    }

    public FavoritesListProvider getProvider() {
        return null;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        return FavoritesListNode.getFavoritesRoots(this.myProject, this.myName, this);
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            FavoritesListNode.$$$reportNull$$$0(2);
        }
        presentation2.setIcon(AllIcons.Toolwindows.ToolWindowFavorites);
        presentation2.setPresentableText(this.myName);
        presentation2.setLocationString(this.myDescription);
    }

    @NotNull
    public static Collection<AbstractTreeNode<?>> getFavoritesRoots(Project project, String listName, FavoritesListNode listNode) {
        List<TreeItem<Pair<AbstractUrl, String>>> pairs = FavoritesManager.getInstance(project).getFavoritesListRootUrls(listName);
        if (pairs.isEmpty()) {
            List<AbstractTreeNode<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                FavoritesListNode.$$$reportNull$$$0(3);
            }
            return list2;
        }
        return FavoritesListNode.createFavoriteRoots(project, pairs, listNode);
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> createFavoriteRoots(Project project, @NotNull Collection<? extends TreeItem<Pair<AbstractUrl, String>>> urls, AbstractTreeNode<?> me) {
        if (urls == null) {
            FavoritesListNode.$$$reportNull$$$0(4);
        }
        ArrayList result2 = new ArrayList();
        FavoritesListNode.processUrls(project, urls, result2, me);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            FavoritesListNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void processUrls(Project project, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> urls, Collection<? super AbstractTreeNode<?>> result2, AbstractTreeNode<?> me) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : urls) {
            AbstractUrl abstractUrl = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            Object[] path = abstractUrl.createPath(project);
            if (path == null || path.length < 1 || path[0] == null) continue;
            try {
                List children2;
                ClassLoader loader2;
                if (abstractUrl instanceof AbstractUrlFavoriteAdapter) {
                    FavoriteNodeProvider provider2 = ((AbstractUrlFavoriteAdapter)abstractUrl).getNodeProvider();
                    ClassLoader loader3 = provider2.getClass().getClassLoader();
                } else {
                    loader2 = FavoritesListNode.class.getClassLoader();
                }
                String className = (String)((Pair)treeItem.getData()).getSecond();
                Class<?> nodeClass = loader2.loadClass(className);
                AbstractTreeNode node = ProjectViewNode.createTreeNode(nodeClass, (Project)project, (Object)path[path.length - 1], (ViewSettings)FavoritesManager.getInstance(project).getViewSettings());
                node.setParent(me);
                node.setIndex(result2.size());
                result2.add(node);
                if (!(node instanceof ProjectViewNodeWithChildrenList) || (children2 = treeItem.getChildren()) == null || children2.isEmpty()) continue;
                ArrayList childList = new ArrayList();
                FavoritesListNode.processUrls(project, children2, childList, node);
                for (AbstractTreeNode treeNode : childList) {
                    ((ProjectViewNodeWithChildrenList)node).addChild(treeNode);
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesListNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesListNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoritesRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFavoriteRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFavoriteRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

