/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config2 = new GraphicsConfig((Graphics)g);
        Color bg = c.getBackground();
        g.setPaint(bg);
        TableColumnModel model2 = ((JTableHeader)c).getColumnModel();
        int h = c.getHeight();
        int w = model2.getTotalColumnWidth();
        g.fillRect(0, 0, w, h);
        JBColor bottomSeparatorColor = JBColor.namedColor((String)"TableHeader.bottomSeparatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.75));
        g.setPaint((Paint)bottomSeparatorColor);
        LinePainter2D.paint((Graphics2D)g, (double)0.0, (double)(h - 1), (double)w, (double)(h - 1));
        Enumeration<TableColumn> columns = model2.getColumns();
        JBColor lineColor = JBColor.namedColor((String)"TableHeader.separatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.7));
        int offset = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (!columns.hasMoreElements() || column.getWidth() <= 0) continue;
            g.setColor((Color)lineColor);
            LinePainter2D.paint((Graphics2D)g, (double)((offset += column.getWidth()) - 1), (double)1.0, (double)(offset - 1), (double)(h - 3));
        }
        config2.restore();
        super.paint(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (size.height == 0) {
            return size;
        }
        JBValue.UIInteger height = new JBValue.UIInteger("TableHeader.height", 25);
        return new Dimension(size.width, Math.max(height.get(), size.height));
    }
}

