/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public final class HidpiInfo
extends AnAction
implements DumbAware {
    private static final boolean ENABLED = JreHiDpiUtil.isJreHiDPIEnabled();
    private static final String JRE_HIDPI_MODE_TEXT = "Per-monitor DPI-aware";
    private static final String MONITOR_RESOLUTION_TEXT = "Monitor resolution";
    private static final String SYS_SCALE_TEXT = "Monitor scale";
    private static final String USR_SCALE_TEXT = "User (IDE) scale";
    private JBPopup popup;
    private final int myCopyIconSize = AllIcons.General.CopyHovered.getIconWidth();
    private final int myCopyIconPlateSize = this.myCopyIconSize * 2;
    private Rectangle myCopyIconRect;
    private boolean myDrawCopyIcon;
    private boolean myIsCopyIconActive;

    public static String getUsrScaleDesc() {
        return "<html><span style='font-size:x-small'>The global IDE scale factor" + (String)(JBUIScale.DEBUG_USER_SCALE_FACTOR.isNotNull() ? ", overridden by the debug property." : ", derived from the main font size: <code>$LABEL_FONT_SIZE" + (ENABLED ? "pt" : "px") + "</code><br><code>" + (SystemInfo.isMac ? "Preferences " : "Settings ") + "> Appearance & Behaviour > Appearance > Override default font") + "</code></span></html>";
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Object[][] data2;
        Object[] columns;
        Window activeFrame;
        block10: {
            if (anActionEvent == null) {
                HidpiInfo.$$$reportNull$$$0(0);
            }
            if ((activeFrame = IdeFrameImpl.getActiveFrame()) == null) {
                return;
            }
            Rectangle bounds2 = activeFrame.getGraphicsConfiguration().getBounds();
            String _USR_SCALE_DESC = HidpiInfo.getUsrScaleDesc().replace("$LABEL_FONT_SIZE", "" + StartupUiUtil.getLabelFont().getSize());
            columns = new String[]{"Property", "Value", "Description"};
            Object[][] objectArray = new String[4][];
            String[] stringArray = new String[3];
            stringArray[0] = JRE_HIDPI_MODE_TEXT;
            String string = stringArray[1] = ENABLED ? "enabled" : "disabled";
            stringArray[2] = "<html><span style='font-size:x-small'>When enabled, the IDE UI scaling honors per-monitor DPI.<br>" + (String)(SystemInfo.isWindows ? "To " + (ENABLED ? "disable" : "enable") + " set the JVM option <code>-Dsun.java2d.uiScale.enabled=" + (ENABLED ? "false" : "true") + "</code> and restart.</span></html>" : "The mode can not be changed on this platform.");
            objectArray[0] = stringArray;
            objectArray[1] = new String[]{MONITOR_RESOLUTION_TEXT, bounds2.width + "x" + bounds2.height, "<html><span style='font-size:x-small'>" + (ENABLED ? "The current monitor resolution" : "The main monitor resolution") + " (in user space).</span></html>"};
            objectArray[2] = new String[]{SYS_SCALE_TEXT, "" + JBUIScale.sysScale((Component)activeFrame), "<html><span style='font-size:x-small'>" + (ENABLED ? "The current monitor scale factor" : "The main monitor scale factor") + ".</span></html>"};
            objectArray[3] = new String[]{USR_SCALE_TEXT, "" + JBUIScale.scale((float)1.0f), _USR_SCALE_DESC};
            data2 = objectArray;
            if (SystemInfo.isLinux && SystemInfo.isJetBrainsJvm) {
                try {
                    Class<?> cls = Class.forName("sun.awt.X11GraphicsDevice");
                    MethodInvocator getDpiInfo = new MethodInvocator(cls, "getDpiInfo", new Class[0]);
                    if (!getDpiInfo.isAvailable()) break block10;
                    GraphicsDevice gd = null;
                    try {
                        gd = activeFrame.getGraphicsConfiguration().getDevice();
                        String[][] dpiInfo = (String[][])getDpiInfo.invoke((Object)gd, new Object[0]);
                        if (dpiInfo != null && dpiInfo.length > 0) {
                            for (String[] row : dpiInfo) {
                                row[2] = "<html><span style='font-size:x-small'>" + row[2] + "</span></html>";
                            }
                            String[][] _exData = new String[data2.length + dpiInfo.length][];
                            System.arraycopy(data2, 0, _exData, 0, data2.length);
                            System.arraycopy(dpiInfo, 0, _exData, data2.length, dpiInfo.length);
                            data2 = _exData;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getInstance(HidpiInfo.class).warn("Unexpected GraphicsDevice type (value): " + (gd != null ? gd.getClass().getName() : "null"));
                    }
                }
                catch (ClassNotFoundException cls) {
                    // empty catch block
                }
            }
        }
        Object[][] exData = data2;
        final JTable table = new JTable(exData, columns, (String[][])exData){
            final /* synthetic */ String[][] val$exData;
            {
                this.val$exData = stringArray;
                super(arg0, arg1);
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return (table1, value2, isSelected, hasFocus, row1, column1) -> HidpiInfo.label(this.val$exData[row1][column1]);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (HidpiInfo.this.myDrawCopyIcon) {
                    Rectangle rect = this.getBounds();
                    g.setColor(JBColor.background());
                    g.fillRect(rect.width - HidpiInfo.this.myCopyIconPlateSize, rect.height - HidpiInfo.this.myCopyIconPlateSize, HidpiInfo.this.myCopyIconPlateSize, HidpiInfo.this.myCopyIconPlateSize);
                    int offset = (HidpiInfo.this.myCopyIconPlateSize + HidpiInfo.this.myCopyIconSize) / 2;
                    AllIcons.General.CopyHovered.paintIcon(this, g, rect.width - offset, rect.height - offset);
                }
            }
        };
        final Supplier<Rectangle> getCopyIconRect = () -> {
            if (this.myCopyIconRect == null) {
                this.myCopyIconRect = table.getBounds();
                this.myCopyIconRect.x = this.myCopyIconRect.width - this.myCopyIconPlateSize;
                this.myCopyIconRect.y = this.myCopyIconRect.height - this.myCopyIconPlateSize;
                this.myCopyIconRect.width = this.myCopyIconRect.height = this.myCopyIconPlateSize;
            }
            return this.myCopyIconRect;
        };
        Object[][] _data = data2;
        table.addMouseListener(new MouseAdapter((String[][])_data){
            final /* synthetic */ String[][] val$_data;
            {
                this.val$_data = stringArray;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                HidpiInfo.this.myDrawCopyIcon = true;
                table.repaint((Rectangle)getCopyIconRect.get());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HidpiInfo.this.myDrawCopyIcon = false;
                table.repaint((Rectangle)getCopyIconRect.get());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (HidpiInfo.this.myIsCopyIconActive) {
                    StringBuilder builder2 = new StringBuilder();
                    for (String[] datum : this.val$_data) {
                        builder2.append(datum[0]).append(" : ").append(datum[1]).append("\n");
                    }
                    try {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(builder2.toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    HidpiInfo.this.popup.cancel();
                }
            }
        });
        table.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (((Rectangle)getCopyIconRect.get()).contains(e.getPoint())) {
                    HidpiInfo.this.myIsCopyIconActive = true;
                    table.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    HidpiInfo.this.myIsCopyIconActive = false;
                    table.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        BiFunction<Integer, Integer, Dimension> size = (arg_0, arg_1) -> HidpiInfo.lambda$actionPerformed$1((String[][])exData, arg_0, arg_1);
        int padding = JBUIScale.scale((int)10);
        table.setColumnSelectionAllowed(true);
        TableColumnModel tcm = table.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)0)).width + padding);
        tcm.getColumn(1).setPreferredWidth(size.apply((Integer)Integer.valueOf((int)1), (Integer)Integer.valueOf((int)1)).width + padding);
        tcm.getColumn(2).setPreferredWidth(size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)2)).width + padding);
        for (int i2 = 0; i2 < table.getRowCount(); ++i2) {
            table.setRowHeight(i2, size.apply((Integer)Integer.valueOf((int)0), (Integer)Integer.valueOf((int)2)).height);
        }
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)table, "Center");
        tablePanel.add((Component)table.getTableHeader(), "North");
        this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)tablePanel, null).setTitle("HiDPI Info").createPopup();
        this.popup.showInCenterOf((Component)activeFrame);
    }

    private static JLabel label(String text2) {
        JLabel label2 = new JLabel(text2);
        label2.setBorder(JBUI.Borders.empty((int)2));
        return label2;
    }

    private static /* synthetic */ Dimension lambda$actionPerformed$1(String[][] exData, Integer row, Integer col) {
        return HidpiInfo.label(exData[row][col]).getPreferredSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/intellij/internal/HidpiInfo", "actionPerformed"));
    }
}

