/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.encodings;

import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class EncodingViewer
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(EncodingViewer.class);
    private JPanel myPanel;
    private JTextArea myText;
    private JComboBox myEncoding;
    private JButton myLoadFile;
    private byte[] myBytes;

    public EncodingViewer() {
        super(false);
        this.$$$setupUI$$$();
        this.initEncodings();
        this.myLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), (Component)EncodingViewer.this.myPanel, null, null);
                if (file2 != null) {
                    EncodingViewer.this.loadFrom(file2);
                }
            }
        });
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "EncodingViewer";
    }

    private void loadFrom(VirtualFile virtualFile) {
        try {
            this.myBytes = virtualFile.contentsToByteArray();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        this.refreshText();
    }

    private void refreshText() {
        if (this.myBytes == null) {
            return;
        }
        try {
            String selectedCharset = this.getSelectedCharset();
            this.myText.setText(new String(this.myBytes, selectedCharset));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private String getSelectedCharset() {
        String string = ((Charset)this.myEncoding.getSelectedItem()).name();
        if (string == null) {
            EncodingViewer.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void initEncodings() {
        Charset[] availableCharsets = CharsetToolkit.getAvailableCharsets();
        this.myEncoding.setModel(new DefaultComboBoxModel<Charset>(availableCharsets));
        int defaultIndex = Arrays.asList(availableCharsets).indexOf(CharsetToolkit.getDefaultSystemCharset());
        this.myEncoding.setSelectedIndex(defaultIndex);
        this.myEncoding.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EncodingViewer.this.refreshText();
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/encodings/EncodingViewer", "getSelectedCharset"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JComboBox jComboBox;
        JButton jButton;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLoadFile = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/CommonBundle", EncodingViewer.class).getString("button.load.file"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEncoding = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myText = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setRows(20);
        jBScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

