/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search;

import com.intellij.largeFilesEditor.search.Position;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NonNls;

public class SearchResult {
    public static final Key<SearchResult> KEY = new Key("lfe.SearchResult");
    public final Position startPosition;
    public final Position endPostion;
    @NlsSafe
    public final String contextPrefix;
    @NlsSafe
    public final String foundString;
    @NlsSafe
    public final String contextPostfix;

    public SearchResult(long startPageNumber, int startOffsetInPage, long endPageNumber, int endOffsetInPage, String contextPrefix, String foundString, String contextPostfix) {
        this.startPosition = new Position(startPageNumber, startOffsetInPage);
        this.endPostion = new Position(endPageNumber, endOffsetInPage);
        this.contextPrefix = contextPrefix == null ? "" : contextPrefix;
        this.foundString = foundString == null ? "" : foundString;
        this.contextPostfix = contextPostfix == null ? "" : contextPostfix;
    }

    @NonNls
    public String toString() {
        return String.format("p%ds%d-p%ds%d: pref{%s},orig{%s},post{%s}", this.startPosition.pageNumber, this.startPosition.symbolOffsetInPage, this.endPostion.pageNumber, this.endPostion.symbolOffsetInPage, this.contextPrefix, this.foundString, this.contextPostfix);
    }

    public boolean equals(Object target2) {
        if (this == target2) {
            return true;
        }
        if (target2 instanceof SearchResult) {
            SearchResult targetResult = (SearchResult)target2;
            if (this.startPosition.equals(targetResult.startPosition) && this.endPostion.equals(targetResult.endPostion) && this.contextPrefix.equals(targetResult.contextPrefix) && this.foundString.equals(targetResult.foundString) && this.contextPostfix.equals(targetResult.contextPostfix)) {
                return true;
            }
        }
        return false;
    }
}

