/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationActionProvider;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.notification.impl.NotificationParentGroup;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutConfiguration;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonActionProvider;
import com.intellij.ui.NotificationBalloonShadowBorderProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationsManagerImpl
extends NotificationsManager {
    public static final Color DEFAULT_TEXT_COLOR = new JBColor((Color)Gray._0, (Color)Gray._191);
    private static final Color TEXT_COLOR = JBColor.namedColor((String)"Notification.foreground", (Color)DEFAULT_TEXT_COLOR);
    public static final Color FILL_COLOR = JBColor.namedColor((String)"Notification.background", (Color)new JBColor((Color)Gray._242, new Color(78, 80, 82)));
    public static final Color BORDER_COLOR = JBColor.namedColor((String)"Notification.borderColor", (Color)new JBColor(Gray._178.withAlpha(205), new Color(86, 90, 92, 205)));
    private final List<Notification> myEarlyNotifications = new ArrayList<Notification>();

    public NotificationsManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Notification notification2 : NotificationsManagerImpl.this.getNotificationsOfType(Notification.class, project)) {
                    notification2.hideBalloon();
                }
                TooltipController.getInstance().resetCurrent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$1", "projectClosed"));
            }
        });
    }

    public void expire(@NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(0);
        }
        UIUtil.invokeLaterIfNeeded(() -> EventLog.expireNotification(notification2));
    }

    public void expireAll() {
        for (Notification notification2 : this.getNotificationsOfType(Notification.class, null)) {
            notification2.expire();
        }
    }

    public <T extends Notification> T @NotNull [] getNotificationsOfType(@NotNull Class<T> klass, @Nullable Project project) {
        if (klass == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Notification> result2 = new ArrayList<Notification>();
        if (project == null || !project.isDefault() && !project.isDisposed()) {
            for (Notification notification2 : EventLog.getLogModel(project).getNotifications()) {
                if (!klass.isInstance(notification2)) continue;
                result2.add(notification2);
            }
        }
        Notification[] notificationArray = (Notification[])ArrayUtil.toObjectArray(result2, klass);
        if (notificationArray == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(2);
        }
        return notificationArray;
    }

    private void doNotify(@NotNull Notification notification2, @Nullable Project project) {
        boolean willBeShown;
        NotificationsConfigurationImpl configuration;
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(3);
        }
        if (!(configuration = NotificationsConfigurationImpl.getInstanceImpl()).isRegistered(notification2.getGroupId())) {
            configuration.register(notification2.getGroupId(), NotificationDisplayType.BALLOON);
        }
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(notification2.getGroupId());
        boolean shouldLog = settings.isShouldLog();
        boolean displayable = settings.getDisplayType() != NotificationDisplayType.NONE;
        boolean bl = willBeShown = displayable && NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS;
        if (!shouldLog && !willBeShown) {
            notification2.expire();
        }
        if (NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS) {
            if (project == null) {
                GuiUtils.invokeLaterIfNeeded(() -> this.showNotification(notification2, null), (ModalityState)ModalityState.any(), (Condition)ApplicationManager.getApplication().getDisposed());
            } else if (!project.isDisposed()) {
                StartupManager.getInstance((Project)project).runAfterOpened(() -> GuiUtils.invokeLaterIfNeeded(() -> this.showNotification(notification2, project), (ModalityState)ModalityState.any(), (Condition)project.getDisposed()));
            }
        }
    }

    @RequiresEdt
    private void dispatchEarlyNotifications() {
        ArrayList<Notification> copy2 = new ArrayList<Notification>(this.myEarlyNotifications);
        this.myEarlyNotifications.clear();
        copy2.forEach(early -> this.showNotification((Notification)early, null));
    }

    @RequiresEdt
    private void showNotification(final Notification notification2, @Nullable Project project) {
        if (!LoadingState.APP_STARTED.isOccurred()) {
            this.myEarlyNotifications.add(notification2);
            if (this.myEarlyNotifications.size() == 1) {
                final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
                connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                    @Override
                    public void appStarted() {
                        assert (LoadingState.APP_STARTED.isOccurred());
                        GuiUtils.invokeLaterIfNeeded(() -> NotificationsManagerImpl.this.dispatchEarlyNotifications(), (ModalityState)ModalityState.any(), (Condition)ApplicationManager.getApplication().getDisposed());
                        connection.disconnect();
                    }
                });
            }
            return;
        }
        if (!this.myEarlyNotifications.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> this.dispatchEarlyNotifications(), ModalityState.any(), ApplicationManager.getApplication().getDisposed());
        }
        String groupId2 = notification2.getGroupId();
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(groupId2);
        NotificationDisplayType type = settings.getDisplayType();
        String toolWindowId = NotificationsConfigurationImpl.getInstanceImpl().getToolWindowId(groupId2);
        if (!(type != NotificationDisplayType.TOOL_WINDOW || toolWindowId != null && project != null && ToolWindowManager.getInstance((Project)project).canShowNotification(toolWindowId))) {
            type = NotificationDisplayType.BALLOON;
        }
        switch (type) {
            case NONE: {
                return;
            }
            default: {
                Balloon balloon2 = NotificationsManagerImpl.notifyByBalloon(notification2, type, project);
                if (project == null || project.isDefault()) {
                    return;
                }
                if (settings.isShouldLog() && type != NotificationDisplayType.STICKY_BALLOON) break;
                if (balloon2 == null) {
                    notification2.expire();
                    break;
                }
                balloon2.addListener(new JBPopupListener(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (!event.isOk()) {
                            notification2.expire();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/NotificationsManagerImpl$3", "onClosed"));
                    }
                });
                break;
            }
            case TOOL_WINDOW: {
                BalloonLayout layout;
                Window window;
                MessageType messageType = notification2.getType() == NotificationType.ERROR ? MessageType.ERROR : (notification2.getType() == NotificationType.WARNING ? MessageType.WARNING : MessageType.INFO);
                List actions = notification2.getActions();
                final NotificationListener notificationListener = notification2.getListener();
                HyperlinkListener listener2 = notificationListener == null ? null : new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        notificationListener.hyperlinkUpdate(notification2, e);
                    }
                };
                Object msg = notification2.getTitle();
                if (StringUtil.isNotEmpty((String)notification2.getContent())) {
                    if (StringUtil.isNotEmpty((String)msg)) {
                        msg = (String)msg + "<br>";
                    }
                    msg = (String)msg + notification2.getContent();
                }
                if (!actions.isEmpty()) {
                    msg = (String)msg + HtmlChunk.br();
                    for (int index = 0; index < actions.size(); ++index) {
                        final AnAction action2 = (AnAction)actions.get(index);
                        final String linkTarget = "notification-action-" + index + "for-tool-window-" + System.identityHashCode(notification2);
                        String text2 = action2.getTemplatePresentation().getText();
                        if (text2 == null) continue;
                        msg = (String)msg + HtmlChunk.link((String)linkTarget, (String)text2) + " ";
                        final HyperlinkListener oldListener = listener2;
                        listener2 = new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (!e.getDescription().equals(linkTarget)) {
                                    oldListener.hyperlinkUpdate(e);
                                    return;
                                }
                                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                                    return;
                                }
                                Object source = e.getSource();
                                DataContext context = source instanceof Component ? DataManager.getInstance().getDataContext((Component)source) : null;
                                NotificationCollector.getInstance().logNotificationActionInvoked(notification2, action2, NotificationCollector.NotificationPlace.TOOL_WINDOW);
                                Notification.fire((Notification)notification2, (AnAction)action2, (DataContext)context);
                            }
                        };
                    }
                }
                if ((window = NotificationsManagerImpl.findWindowForBalloon(project)) instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                    ((BalloonLayoutImpl)layout).remove(notification2);
                }
                ToolWindowManager.getInstance((Project)Objects.requireNonNull(project)).notifyByBalloon(toolWindowId, messageType, (String)msg, notification2.getIcon(), listener2);
                NotificationCollector.getInstance().logToolWindowNotificationShown(project, notification2);
            }
        }
    }

    @Nullable
    private static Balloon notifyByBalloon(@NotNull Notification notification2, @NotNull NotificationDisplayType displayType, @Nullable Project project) {
        BalloonLayoutData layoutData;
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(4);
        }
        if (displayType == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(5);
        }
        if (NotificationsManagerImpl.isDummyEnvironment()) {
            return null;
        }
        Window window = NotificationsManagerImpl.findWindowForBalloon(project);
        if (!(window instanceof IdeFrame)) {
            return null;
        }
        BalloonLayout layout = ((IdeFrame)window).getBalloonLayout();
        if (layout == null) {
            return null;
        }
        Ref layoutDataRef = new Ref();
        if (project == null || project.isDefault()) {
            BalloonLayoutData layoutData2 = new BalloonLayoutData();
            layoutData2.groupId = "";
            layoutData2.welcomeScreen = layout instanceof WelcomeBalloonLayoutImpl;
            layoutData2.type = notification2.getType();
            layoutDataRef.set((Object)layoutData2);
        } else {
            BalloonLayoutData.MergeInfo mergeData = ((BalloonLayoutImpl)layout).preMerge(notification2);
            if (mergeData != null) {
                layoutData = new BalloonLayoutData();
                layoutData.mergeData = mergeData;
                layoutDataRef.set((Object)layoutData);
            }
        }
        Balloon balloon2 = NotificationsManagerImpl.createBalloon((IdeFrame)window, notification2, false, false, (Ref<BalloonLayoutData>)layoutDataRef, (Disposable)(project != null ? project : ApplicationManager.getApplication()));
        if (notification2.isExpired()) {
            return null;
        }
        layoutData = (BalloonLayoutData)layoutDataRef.get();
        layout.add(balloon2, (Object)layoutData);
        if (balloon2.isDisposed()) {
            return null;
        }
        if (layoutData != null) {
            layoutData.project = project;
        }
        ((BalloonImpl)balloon2).startFadeoutTimer(0);
        if (displayType == NotificationDisplayType.BALLOON || ProjectUtil.getOpenProjects().length == 0) {
            NotificationsManagerImpl.frameActivateBalloonListener((Disposable)balloon2, () -> {
                if (!balloon2.isDisposed()) {
                    ((BalloonImpl)balloon2).startSmartFadeoutTimer(10000);
                }
            });
        }
        NotificationCollector.getInstance().logBalloonShown(project, displayType, notification2, layoutData != null && layoutData.isExpandable);
        return balloon2;
    }

    public static void frameActivateBalloonListener(@NotNull Disposable parentDisposable, final @NotNull Runnable callback2) {
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(6);
        }
        if (callback2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isActive()) {
            callback2.run();
        } else {
            final Disposable listenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)parentDisposable, (Disposable)listenerDisposable);
            ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(FrameStateListener.TOPIC, (Object)new FrameStateListener(){

                public void onFrameActivated() {
                    Disposer.dispose((Disposable)listenerDisposable);
                    callback2.run();
                }
            });
        }
    }

    @Nullable
    public static Window findWindowForBalloon(@Nullable Project project) {
        Window frame = WindowManager.getInstance().getFrame(project);
        if (frame == null && project == null) {
            frame = (Window)WelcomeFrame.getInstance();
        }
        if (frame == null && project == null) {
            DialogWrapper wrapper2;
            frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            while (frame instanceof DialogWrapperDialog && (wrapper2 = ((DialogWrapperDialog)frame).getDialogWrapper()) != null && wrapper2.isModalProgress()) {
                frame = frame.getOwner();
            }
        }
        if (frame == null && project == null) {
            frame = WindowManager.getInstance().findVisibleFrame();
        }
        return frame;
    }

    @NotNull
    public static Balloon createBalloon(@NotNull IdeFrame window, @NotNull Notification notification2, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        if (window == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(8);
        }
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(9);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(11);
        }
        return NotificationsManagerImpl.createBalloon(window.getComponent(), notification2, showCallout, hideOnClickOutside, layoutDataRef, parentDisposable);
    }

    @NotNull
    public static Balloon createBalloon(@Nullable JComponent windowComponent, final @NotNull Notification notification2, boolean showCallout, boolean hideOnClickOutside, @NotNull Ref<BalloonLayoutData> layoutDataRef, @NotNull Disposable parentDisposable) {
        JPanel buttons;
        String style;
        BalloonLayoutData layoutData;
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(12);
        }
        if (layoutDataRef == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(14);
        }
        BalloonLayoutData balloonLayoutData = layoutData = layoutDataRef.isNull() ? new BalloonLayoutData() : (BalloonLayoutData)layoutDataRef.get();
        if (layoutData.groupId == null) {
            layoutData.groupId = notification2.getGroupId();
        } else {
            layoutData.groupId = null;
            layoutData.mergeData = null;
        }
        layoutData.id = notification2.id;
        layoutData.displayId = notification2.displayId;
        layoutDataRef.set((Object)layoutData);
        if (layoutData.textColor == null) {
            layoutData.textColor = TEXT_COLOR;
        }
        if (layoutData.fillColor == null) {
            layoutData.fillColor = FILL_COLOR;
        }
        if (layoutData.borderColor == null) {
            layoutData.borderColor = BORDER_COLOR;
        }
        boolean actions = !notification2.getActions().isEmpty() || notification2.getContextHelpAction() != null;
        boolean showFullContent = layoutData.showFullContent || notification2 instanceof NotificationFullContent;
        final JEditorPane text2 = new JEditorPane(){

            @Override
            protected void paintComponent(Graphics g) {
                Point location;
                super.paintComponent(g);
                if (layoutData.showMinSize && (location = NotificationsManagerImpl.getCollapsedTextEndLocation(this, layoutData)) != null) {
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    g.setColor(this.getForeground());
                    g.drawString("...", location.x, location.y + g.getFontMetrics().getAscent());
                }
            }
        };
        UIUtil.JBWordWrapHtmlEditorKit kit = new UIUtil.JBWordWrapHtmlEditorKit();
        kit.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor()) + "}");
        text2.setEditorKit((EditorKit)kit);
        text2.setForeground(layoutData.textColor);
        HyperlinkListener listener2 = NotificationsUtil.wrapListener(notification2);
        if (listener2 != null) {
            text2.addHyperlinkListener(listener2);
        }
        String fontStyle = NotificationsUtil.getFontStyle();
        int prefSize = new JLabel((String)NotificationsUtil.buildHtml((Notification)notification2, null, (boolean)true, null, (String)fontStyle)).getPreferredSize().width;
        String string = style = prefSize > BalloonLayoutConfiguration.MaxWidth() ? BalloonLayoutConfiguration.MaxWidthStyle() : null;
        if (layoutData.showFullContent) {
            style = prefSize > BalloonLayoutConfiguration.MaxFullContentWidth() ? BalloonLayoutConfiguration.MaxFullContentWidthStyle() : null;
        }
        String textContent = NotificationsUtil.buildHtml(notification2, style, true, null, fontStyle);
        text2.setText(textContent);
        text2.setEditable(false);
        text2.setOpaque(false);
        text2.setBorder(null);
        NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        if (text2.getCaret() != null) {
            text2.setCaretPosition(0);
        }
        final JScrollPane pane2 = NotificationsManagerImpl.createBalloonScrollPane(text2, false);
        pane2.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar scrollBar = pane2.getVerticalScrollBar();
                if (layoutData.showMinSize && scrollBar.getValue() > 0) {
                    scrollBar.removeAdjustmentListener(this);
                    scrollBar.setValue(0);
                    scrollBar.addAdjustmentListener(this);
                }
            }
        });
        LinkLabel expandAction = null;
        int lines = 3;
        if (notification2.hasTitle()) {
            --lines;
        }
        if (actions) {
            --lines;
        }
        layoutData.fullHeight = text2.getPreferredSize().height;
        layoutData.twoLineHeight = NotificationsManagerImpl.calculateContentHeight(lines);
        layoutData.maxScrollHeight = Math.min(layoutData.fullHeight, NotificationsManagerImpl.calculateContentHeight(10));
        layoutData.configuration = BalloonLayoutConfiguration.create(notification2, layoutData, actions);
        if (layoutData.welcomeScreen) {
            layoutData.maxScrollHeight = layoutData.fullHeight;
        } else if (!showFullContent && layoutData.maxScrollHeight != layoutData.fullHeight) {
            pane2.setViewport((JViewport)((Object)new GradientViewport(text2, (Insets)JBInsets.create((int)10, (int)0), true){

                @Override
                @Nullable
                protected Color getViewColor() {
                    return layoutData.fillColor;
                }

                @Override
                protected void paintGradient(Graphics g) {
                    if (!layoutData.showMinSize) {
                        super.paintGradient(g);
                    }
                }
            }));
        }
        NotificationsManagerImpl.configureBalloonScrollPane(pane2, layoutData.fillColor);
        if (showFullContent) {
            if (windowComponent == null) {
                pane2.setPreferredSize(text2.getPreferredSize());
            } else {
                pane2.setPreferredSize(new Dimension(text2.getPreferredSize().width, (int)Math.min((double)layoutData.fullHeight, (double)windowComponent.getHeight() * 0.75)));
            }
        } else if (layoutData.twoLineHeight < layoutData.fullHeight) {
            text2.setPreferredSize(null);
            Dimension size = text2.getPreferredSize();
            size.height = layoutData.twoLineHeight;
            text2.setPreferredSize(size);
            text2.setSize(size);
            layoutData.showMinSize = true;
            pane2.setHorizontalScrollBarPolicy(31);
            pane2.setVerticalScrollBarPolicy(21);
            pane2.setPreferredSize(size);
            text2.setCaret(new TextCaret(layoutData));
            expandAction = new LinkLabel(null, AllIcons.Ide.Notification.Expand, (LinkListener)new LinkListener<Void>((JPanel)content2){
                final /* synthetic */ JPanel val$content;
                {
                    this.val$content = jPanel2;
                }

                public void linkSelected(LinkLabel<Void> link2, Void ignored) {
                    layoutData.showMinSize = !layoutData.showMinSize;
                    text2.setPreferredSize(null);
                    Dimension size = text2.getPreferredSize();
                    if (layoutData.showMinSize) {
                        size.height = layoutData.twoLineHeight;
                        pane2.setVerticalScrollBarPolicy(21);
                        link2.setIcon(AllIcons.Ide.Notification.Expand);
                        link2.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
                        NotificationCollector.getInstance().logNotificationBalloonCollapsed(notification2);
                    } else {
                        text2.select(0, 0);
                        size.height = layoutData.fullHeight;
                        pane2.setVerticalScrollBarPolicy(20);
                        link2.setIcon(AllIcons.Ide.Notification.Collapse);
                        link2.setHoveringIcon(AllIcons.Ide.Notification.CollapseHover);
                        NotificationCollector.getInstance().logNotificationBalloonExpanded(notification2);
                    }
                    text2.setPreferredSize(size);
                    text2.setSize(size);
                    if (!layoutData.showMinSize) {
                        size = new Dimension(size.width, layoutData.maxScrollHeight);
                    }
                    pane2.setPreferredSize(size);
                    this.val$content.doLayout();
                    layoutData.doLayout.run();
                }
            });
            expandAction.setHoveringIcon(AllIcons.Ide.Notification.ExpandHover);
            layoutData.isExpandable = true;
        }
        NotificationCenterPanel centerPanel = new NotificationCenterPanel(text2, layoutData);
        content2.add((Component)((Object)centerPanel), "Center");
        if (notification2.hasTitle()) {
            String titleStyle = StringUtil.defaultIfEmpty((String)fontStyle, (String)"") + "white-space:nowrap;";
            JLabel title = new JLabel();
            title.setText(NotificationsUtil.buildHtml(notification2, titleStyle, false, null, null));
            title.setOpaque(false);
            title.setForeground(layoutData.textColor);
            centerPanel.addTitle(title);
        }
        if (expandAction != null) {
            centerPanel.addExpandAction(expandAction);
        }
        if (notification2.hasContent()) {
            centerPanel.addContent(layoutData.welcomeScreen ? text2 : pane2);
        }
        if (!layoutData.welcomeScreen) {
            final Icon icon2 = NotificationsUtil.getIcon(notification2);
            JComponent iconComponent = new JComponent(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    icon2.paintIcon(this, g, layoutData.configuration.iconOffset.width, layoutData.configuration.iconOffset.height);
                }
            };
            iconComponent.setOpaque(false);
            iconComponent.setPreferredSize(new Dimension(layoutData.configuration.iconPanelWidth, 2 * layoutData.configuration.iconOffset.height + icon2.getIconHeight()));
            content2.add((Component)iconComponent, "West");
        }
        if ((buttons = NotificationsManagerImpl.createButtons(notification2, (JPanel)content2, listener2)) != null) {
            layoutData.groupId = null;
            layoutData.mergeData = null;
            buttons.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)5, (int)7));
        }
        HoverAdapter hoverAdapter = new HoverAdapter();
        hoverAdapter.addSource((Component)content2);
        hoverAdapter.addSource((Component)((Object)centerPanel));
        hoverAdapter.addSource(text2);
        hoverAdapter.addSource(pane2);
        if (buttons == null && actions) {
            NotificationsManagerImpl.createActionPanel(notification2, centerPanel, layoutData.configuration.actionGap, hoverAdapter);
        }
        if (expandAction != null) {
            hoverAdapter.addComponent((Component)expandAction, (Function<? super Component, ? extends Rectangle>)((Function)arg_0 -> NotificationsManagerImpl.lambda$createBalloon$7((JPanel)content2, layoutData, text2, pane2, arg_0)));
        }
        hoverAdapter.initListeners();
        if (layoutData.mergeData != null) {
            NotificationsManagerImpl.createMergeAction(layoutData, (JPanel)content2);
        }
        text2.setSize(text2.getPreferredSize());
        Dimension paneSize = new Dimension(text2.getPreferredSize());
        int maxWidth = JBUIScale.scale((int)600);
        if (windowComponent != null) {
            maxWidth = Math.min(maxWidth, windowComponent.getWidth() - 20);
        }
        if (paneSize.width > maxWidth) {
            pane2.setPreferredSize(new Dimension(maxWidth, paneSize.height + UIUtil.getScrollBarWidth()));
        }
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content2);
        builder2.setFillColor(layoutData.fillColor).setCloseButtonEnabled(buttons == null).setShowCallout(showCallout).setShadow(false).setAnimationCycle(200).setHideOnClickOutside(hideOnClickOutside).setHideOnAction(hideOnClickOutside).setHideOnKeyOutside(hideOnClickOutside).setHideOnFrameResize(false).setBorderColor(layoutData.borderColor).setBorderInsets((Insets)JBUI.emptyInsets());
        if (layoutData.fadeoutTime != 0L) {
            builder2.setFadeoutTime(layoutData.fadeoutTime);
        }
        BalloonImpl balloon2 = (BalloonImpl)builder2.createBalloon();
        balloon2.getContent().addMouseListener(new MouseAdapter(){});
        balloon2.setAnimationEnabled(false);
        notification2.setBalloon((Balloon)balloon2);
        balloon2.setShadowBorderProvider(new NotificationBalloonShadowBorderProvider(layoutData.fillColor, layoutData.borderColor));
        if (!layoutData.welcomeScreen && buttons == null) {
            balloon2.setActionProvider(new NotificationBalloonActionProvider(balloon2, centerPanel.getTitle(), layoutData, notification2.getGroupId(), notification2.id, notification2.displayId));
        }
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)balloon2).subscribe(LafManagerListener.TOPIC, source -> {
            UIUtil.JBWordWrapHtmlEditorKit newKit = new UIUtil.JBWordWrapHtmlEditorKit();
            newKit.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor()) + "}");
            text2.setEditorKit((EditorKit)newKit);
            text2.setText(textContent);
            text2.revalidate();
            text2.repaint();
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)balloon2);
        BalloonImpl balloonImpl = balloon2;
        if (balloonImpl == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(15);
        }
        return balloonImpl;
    }

    @Nullable
    private static JPanel createButtons(@NotNull Notification notification2, final @NotNull JPanel content2, @Nullable HyperlinkListener listener2) {
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(16);
        }
        if (content2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(17);
        }
        if (notification2 instanceof NotificationActionProvider) {
            JPanel buttons = new JPanel((LayoutManager)new HorizontalLayout(5));
            buttons.setOpaque(false);
            content2.add("South", buttons);
            final Ref defaultButton = new Ref();
            NotificationActionProvider provider2 = (NotificationActionProvider)notification2;
            for (NotificationActionProvider.Action action2 : provider2.getActions(listener2)) {
                JButton button2 = new JButton(action2){

                    @Override
                    public void setUI(ButtonUI ui) {
                        boolean isDarcula;
                        boolean bl = isDarcula = ui instanceof DarculaButtonUI && StartupUiUtil.isUnderDarcula();
                        if (isDarcula) {
                            ui = new DarculaButtonUI(){

                                @Override
                                protected Color getButtonColorStart() {
                                    return new ColorUIResource(5922657);
                                }

                                @Override
                                protected Color getButtonColorEnd() {
                                    return new ColorUIResource(5922657);
                                }
                            };
                        }
                        super.setUI(ui);
                        if (isDarcula) {
                            this.setBorder(new DarculaButtonPainter(){

                                @Override
                                public Paint getBorderPaint(Component button2) {
                                    return new ColorUIResource(0x717777);
                                }
                            });
                        }
                    }
                };
                button2.setOpaque(false);
                if (action2.isDefaultAction()) {
                    defaultButton.setIfNull((Object)button2);
                }
                buttons.add("RIGHT", button2);
            }
            if (!defaultButton.isNull()) {
                UIUtil.addParentChangeListener((Component)content2, (PropertyChangeListener)new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getOldValue() == null && event.getNewValue() != null) {
                            UIUtil.removeParentChangeListener((Component)content2, (PropertyChangeListener)this);
                            JRootPane rootPane = UIUtil.getRootPane((Component)content2);
                            if (rootPane != null) {
                                rootPane.setDefaultButton((JButton)defaultButton.get());
                            }
                        }
                    }
                });
            }
            return buttons;
        }
        return null;
    }

    @NotNull
    public static JScrollPane createBalloonScrollPane(@NotNull Component content2, boolean configure) {
        if (content2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(18);
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)content2, (boolean)true);
        if (configure) {
            NotificationsManagerImpl.configureBalloonScrollPane(pane2, FILL_COLOR);
        }
        JScrollPane jScrollPane = pane2;
        if (jScrollPane == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(19);
        }
        return jScrollPane;
    }

    public static void configureBalloonScrollPane(@NotNull JScrollPane pane2, @NotNull Color fillColor) {
        if (pane2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(20);
        }
        if (fillColor == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(21);
        }
        pane2.setOpaque(false);
        pane2.getViewport().setOpaque(false);
        pane2.setBackground(fillColor);
        pane2.getViewport().setBackground(fillColor);
        pane2.getVerticalScrollBar().setBackground(fillColor);
    }

    private static void createActionPanel(final @NotNull Notification notification2, @NotNull NotificationCenterPanel centerPanel, int gap, @NotNull HoverAdapter hoverAdapter) {
        AnAction helpAction;
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(22);
        }
        if (centerPanel == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(23);
        }
        if (hoverAdapter == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(24);
        }
        NotificationActionPanel actionPanel = new NotificationActionPanel(gap, notification2.getCollapseActionsDirection());
        centerPanel.addActionPanel(actionPanel);
        List actions = notification2.getActions();
        if (actions.size() > 2 && notification2.getCollapseActionsDirection() == Notification.CollapseActionsDirection.KEEP_RIGHTMOST) {
            NotificationsManagerImpl.addDropDownAction(notification2, actionPanel);
        }
        for (AnAction action2 : actions) {
            Presentation presentation2 = action2.getTemplatePresentation();
            actionPanel.addActionLink((LinkLabel<AnAction>)new LinkLabel(presentation2.getText(), presentation2.getIcon(), (LinkListener)new LinkListener<AnAction>(){

                public void linkSelected(LinkLabel<AnAction> aSource, AnAction action2) {
                    NotificationCollector.getInstance().logNotificationActionInvoked(notification2, action2, NotificationCollector.NotificationPlace.BALLOON);
                    Notification.fire((Notification)notification2, (AnAction)action2, (DataContext)DataManager.getInstance().getDataContext(aSource));
                }
            }, (Object)action2));
        }
        if (actions.size() > 2 && notification2.getCollapseActionsDirection() == Notification.CollapseActionsDirection.KEEP_LEFTMOST) {
            NotificationsManagerImpl.addDropDownAction(notification2, actionPanel);
        }
        if ((helpAction = notification2.getContextHelpAction()) != null) {
            Presentation presentation3 = helpAction.getTemplatePresentation();
            ContextHelpLabel helpLabel = new ContextHelpLabel(presentation3.getText(), presentation3.getDescription());
            helpLabel.setForeground(UIUtil.getLabelDisabledForeground());
            actionPanel.addContextHelpLabel(helpLabel);
        }
        JBInsets hover = JBUI.insets((int)8, (int)5, (int)8, (int)7);
        int count = actionPanel.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            hoverAdapter.addComponent(actionPanel.getComponent(i2), (Insets)hover);
        }
        hoverAdapter.addSource((Component)((Object)actionPanel));
    }

    private static void addDropDownAction(@NotNull Notification notification2, NotificationActionPanel actionPanel) {
        if (notification2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(25);
        }
        DropDownAction action2 = new DropDownAction(notification2.getDropDownText(), new LinkListener<Void>(){

            public void linkSelected(LinkLabel<Void> link2, Void ignored) {
                NotificationActionPanel parent = (NotificationActionPanel)((Object)link2.getParent());
                DefaultActionGroup group2 = new DefaultActionGroup();
                for (LinkLabel<AnAction> actionLink : parent.actionLinks) {
                    if (actionLink.isVisible()) continue;
                    group2.add((AnAction)actionLink.getLinkData());
                }
                NotificationsManagerImpl.showPopup(link2, group2);
            }
        });
        Notification.setDataProvider((Notification)notification2, (JComponent)((Object)action2));
        action2.setVisible(false);
        actionPanel.addGroupedActionsLink(action2);
    }

    private static void createMergeAction(@NotNull BalloonLayoutData layoutData, @NotNull JPanel panel2) {
        if (layoutData == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(26);
        }
        if (panel2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(27);
        }
        @Nls StringBuilder title = new StringBuilder().append(layoutData.mergeData.count).append(" ").append(IdeBundle.message((String)"notification.manager.merge.more", (Object[])new Object[0]));
        String shortTitle = NotificationParentGroup.getShortTitle(layoutData.groupId);
        if (shortTitle != null) {
            title.append(" ").append(IdeBundle.message((String)"notification.manager.merge.from", (Object[])new Object[0])).append(" ").append(shortTitle);
        }
        LinkLabel<BalloonLayoutData> action2 = new LinkLabel<BalloonLayoutData>(title.toString(), null, (LinkListener)new LinkListener<BalloonLayoutData>(){

            public void linkSelected(LinkLabel<BalloonLayoutData> aSource, BalloonLayoutData layoutData) {
                EventLog.showNotification(layoutData.project, layoutData.groupId, layoutData.getMergeIds());
            }
        }, layoutData){

            protected boolean isInClickableArea(Point pt) {
                return true;
            }

            protected Color getTextColor() {
                return JBColor.namedColor((String)"Notification.MoreButton.foreground", (Color)new JBColor(0x666666, 0x8C8C8C));
            }
        };
        action2.setFont(FontUtil.minusOne((Font)action2.getFont()));
        action2.setHorizontalAlignment(0);
        action2.setPaintUnderline(false);
        AbstractLayoutManager layout = new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getWidth(), JBUIScale.scale((int)20) + 2);
            }

            public void layoutContainer(Container parent) {
                parent.getComponent(0).setBounds(2, 1, parent.getWidth() - 4, JBUIScale.scale((int)20));
            }
        };
        NonOpaquePanel mergePanel = new NonOpaquePanel((LayoutManager)layout){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor((Color)JBColor.namedColor((String)"Notification.MoreButton.background", (Color)new JBColor(0xE3E3E3, 3816509)));
                ((Graphics2D)g).fill(new Rectangle2D.Double(1.5, 1.0, (double)this.getWidth() - 2.5, this.getHeight() - 2));
                g.setColor((Color)JBColor.namedColor((String)"Notification.MoreButton.innerBorderColor", (Color)new JBColor(0xDBDBDB, 3487544)));
                if (SystemInfo.isMac) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(2.0, 0.0, (double)this.getWidth() - 3.5, 0.5));
                } else if (SystemInfo.isWindows) {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, this.getWidth() - 3, 0.5));
                } else {
                    ((Graphics2D)g).draw(new Rectangle2D.Double(1.5, 0.0, (double)this.getWidth() - 2.5, 0.5));
                }
            }
        };
        mergePanel.add((Component)action2);
        panel2.add("South", (Component)mergePanel);
    }

    public static int calculateContentHeight(int lines) {
        String word = IdeBundle.message((String)"notification.manager.content.height.word", (Object[])new Object[0]);
        String lineBreak = IdeBundle.message((String)"notification.manager.content.height.linebreak", (Object[])new Object[0]);
        String content2 = word + StringUtil.repeat((String)(lineBreak + word), (int)(lines - 1));
        JEditorPane text2 = new JEditorPane();
        text2.setEditorKit(UIUtil.getHTMLEditorKit());
        text2.setText(NotificationsUtil.buildHtml(null, null, content2, null, null, null, NotificationsUtil.getFontStyle()));
        text2.setEditable(false);
        text2.setOpaque(false);
        text2.setBorder(null);
        return text2.getPreferredSize().height;
    }

    private static boolean isDummyEnvironment() {
        Application app = ApplicationManager.getApplication();
        return app.isUnitTestMode() || app.isCommandLine();
    }

    private static void showPopup(@NotNull LinkLabel<?> link2, @NotNull DefaultActionGroup group2) {
        if (link2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(28);
        }
        if (group2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(29);
        }
        if (link2.isShowing()) {
            ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group2);
            menu.getComponent().show((Component)link2, JBUIScale.scale((int)-10), link2.getHeight() + JBUIScale.scale((int)2));
        }
    }

    @Nullable
    private static Point getCollapsedTextEndLocation(@NotNull JEditorPane text2, @NotNull BalloonLayoutData layoutData) {
        if (text2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(30);
        }
        if (layoutData == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(31);
        }
        try {
            int end = text2.viewToModel(new Point(10, layoutData.twoLineHeight + 5));
            if (end == -1) {
                end = text2.getDocument().getLength();
            }
            for (int i2 = end - 1; i2 >= 0; --i2) {
                Rectangle r = text2.modelToView(i2);
                if (r == null || r.y >= layoutData.twoLineHeight) continue;
                return r.getLocation();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static int getFirstLineHeight(@NotNull JEditorPane text2) {
        if (text2 == null) {
            NotificationsManagerImpl.$$$reportNull$$$0(32);
        }
        try {
            int end = text2.getDocument().getLength();
            for (int i2 = 0; i2 < end; ++i2) {
                Rectangle r = text2.modelToView(i2);
                if (r == null || r.height <= 0) continue;
                return r.height;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ Rectangle lambda$createBalloon$7(JPanel content2, BalloonLayoutData layoutData, JEditorPane text2, JScrollPane pane2, Component component2) {
        Rectangle bounds2;
        Point location = SwingUtilities.convertPoint(content2.getParent(), content2.getLocation(), component2.getParent());
        if (layoutData.showMinSize) {
            JComponent centerComponent = layoutData.welcomeScreen ? text2 : pane2;
            Point centerLocation = SwingUtilities.convertPoint(centerComponent.getParent(), centerComponent.getLocation(), component2.getParent());
            bounds2 = new Rectangle(location.x, centerLocation.y, content2.getWidth(), ((Component)centerComponent).getHeight());
        } else {
            bounds2 = new Rectangle(location.x, component2.getY(), content2.getWidth(), component2.getHeight());
            JBInsets.addTo((Rectangle)bounds2, (Insets)JBUI.insets((int)5, (int)0, (int)7, (int)0));
        }
        return bounds2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutDataRef";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centerPanel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hoverAdapter";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutData";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationsOfType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloon";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createBalloonScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expire";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationsOfType";
                break;
            }
            case 2: 
            case 15: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doNotify";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyByBalloon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "frameActivateBalloonListener";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createBalloon";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonScrollPane";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureBalloonScrollPane";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createActionPanel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addDropDownAction";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createMergeAction";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedTextEndLocation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLineHeight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TextCaret
    extends DefaultCaret
    implements UIResource {
        private final BalloonLayoutData myLayoutData;

        TextCaret(@NotNull BalloonLayoutData layoutData) {
            if (layoutData == null) {
                TextCaret.$$$reportNull$$$0(0);
            }
            this.myLayoutData = layoutData;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseExited(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.myLayoutData.showMinSize) {
                super.mouseMoved(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/notification/impl/NotificationsManagerImpl$TextCaret", "<init>"));
        }
    }

    private static class CenteredLayoutWithActions
    extends BorderLayout {
        private final JEditorPane myText;
        private final BalloonLayoutData myLayoutData;
        private JLabel myTitleComponent;
        private Component myCenteredComponent;
        private NotificationActionPanel myActionPanel;
        private Component myExpandAction;

        CenteredLayoutWithActions(JEditorPane text2, BalloonLayoutData layoutData) {
            this.myText = text2;
            this.myLayoutData = layoutData;
        }

        @Nullable
        public Component getTitle() {
            if (this.myTitleComponent != null) {
                return this.myTitleComponent;
            }
            if (this.myCenteredComponent != null) {
                if (this.myCenteredComponent instanceof JScrollPane) {
                    return ((JScrollPane)this.myCenteredComponent).getViewport().getView();
                }
                return this.myCenteredComponent;
            }
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize((Function<? super Component, ? extends Dimension>)((Function)component2 -> component2.getPreferredSize()));
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize((Function<? super Component, ? extends Dimension>)((Function)component2 -> component2.getMinimumSize()));
        }

        private Dimension layoutSize(@NotNull Function<? super Component, ? extends Dimension> size) {
            if (size == null) {
                CenteredLayoutWithActions.$$$reportNull$$$0(0);
            }
            Dimension titleSize = this.myTitleComponent == null ? new Dimension() : (Dimension)size.fun((Object)this.myTitleComponent);
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : (Dimension)size.fun((Object)this.myCenteredComponent);
            Dimension actionSize = this.myActionPanel == null ? new Dimension() : (Dimension)size.fun((Object)this.myActionPanel);
            Dimension expandSize = this.myExpandAction == null || this.myLayoutData.showMinSize ? new Dimension() : (Dimension)size.fun((Object)this.myExpandAction);
            int height = this.myLayoutData.configuration.topSpaceHeight + titleSize.height + centeredSize.height + Math.max(actionSize.height, expandSize.height) + this.myLayoutData.configuration.bottomSpaceHeight;
            if (titleSize.height > 0 && centeredSize.height > 0) {
                height += this.myLayoutData.configuration.titleContentSpaceHeight;
            }
            if (centeredSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.contentActionsSpaceHeight;
            }
            if (titleSize.height > 0 && actionSize.height > 0) {
                height += this.myLayoutData.configuration.titleActionsSpaceHeight;
            }
            int titleWidth = titleSize.width + this.myLayoutData.configuration.closeOffset;
            int centerWidth = centeredSize.width + this.myLayoutData.configuration.closeOffset;
            int actionWidth = actionSize.width + expandSize.width;
            int width = Math.max(centerWidth, Math.max(titleWidth, actionWidth));
            if (!this.myLayoutData.showFullContent) {
                width = Math.min(width, BalloonLayoutConfiguration.MaxWidth());
            }
            width = Math.max(width, BalloonLayoutConfiguration.MinWidth());
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean isActions;
            int top = this.myLayoutData.configuration.topSpaceHeight;
            int width = parent.getWidth();
            Dimension centeredSize = this.myCenteredComponent == null ? new Dimension() : this.myCenteredComponent.getPreferredSize();
            boolean bl = isActions = this.myActionPanel != null || this.myExpandAction != null && !this.myLayoutData.showMinSize;
            if (this.myTitleComponent != null) {
                int titleHeight = this.myTitleComponent.getPreferredSize().height;
                this.myTitleComponent.setBounds(0, top, width - this.myLayoutData.configuration.closeOffset, titleHeight);
                top += titleHeight;
                if (this.myCenteredComponent != null) {
                    top += this.myLayoutData.configuration.titleContentSpaceHeight;
                } else if (isActions) {
                    top += this.myLayoutData.configuration.titleActionsSpaceHeight;
                }
            }
            if (this.myCenteredComponent != null) {
                int centeredWidth = width;
                if (!this.myLayoutData.showFullContent && !this.myLayoutData.showMinSize && this.myLayoutData.fullHeight != this.myLayoutData.maxScrollHeight) {
                    --centeredWidth;
                }
                this.myCenteredComponent.setBounds(0, top, centeredWidth, centeredSize.height);
                this.myCenteredComponent.revalidate();
            }
            if (this.myExpandAction != null) {
                Dimension size = this.myExpandAction.getPreferredSize();
                int x = width - size.width - Objects.requireNonNull(this.myLayoutData.configuration.rightActionsOffset).width;
                if (this.myLayoutData.showMinSize) {
                    Point location = NotificationsManagerImpl.getCollapsedTextEndLocation(this.myText, this.myLayoutData);
                    if (location != null) {
                        int y = SwingUtilities.convertPoint((Component)this.myText, (int)location.x, (int)location.y, (Component)parent).y;
                        this.myExpandAction.setBounds(x, y, size.width, size.height);
                    }
                } else {
                    int y = parent.getHeight() - size.height - this.myLayoutData.configuration.bottomSpaceHeight;
                    this.myExpandAction.setBounds(x, y, size.width, size.height);
                }
            }
            if (this.myActionPanel != null) {
                int expandWidth = this.myExpandAction == null || this.myLayoutData.showMinSize ? 0 : this.myExpandAction.getPreferredSize().width;
                width -= this.myLayoutData.configuration.actionGap + expandWidth;
                if (this.myActionPanel.actionLinks.size() > 2) {
                    this.myActionPanel.groupedActionsLink.setVisible(false);
                    for (LinkLabel<AnAction> link2 : this.myActionPanel.actionLinks) {
                        link2.setVisible(true);
                    }
                    this.myActionPanel.doLayout();
                    boolean keepRightmost = this.myActionPanel.collapseActionsDirection == Notification.CollapseActionsDirection.KEEP_RIGHTMOST;
                    int collapseStart = keepRightmost ? 0 : this.myActionPanel.actionLinks.size() - 1;
                    int collapseDelta = keepRightmost ? 1 : -1;
                    int collapseIndex = collapseStart;
                    if (this.myActionPanel.getPreferredSize().width > width) {
                        this.myActionPanel.groupedActionsLink.setVisible(true);
                        this.myActionPanel.actionLinks.get(collapseIndex).setVisible(false);
                        this.myActionPanel.actionLinks.get(collapseIndex += collapseDelta).setVisible(false);
                        collapseIndex += collapseDelta;
                        this.myActionPanel.doLayout();
                        while (this.myActionPanel.getPreferredSize().width > width && collapseIndex >= 0 && collapseIndex < this.myActionPanel.actionLinks.size()) {
                            this.myActionPanel.actionLinks.get(collapseIndex).setVisible(false);
                            collapseIndex += collapseDelta;
                            this.myActionPanel.doLayout();
                        }
                    }
                }
                Dimension size = this.myActionPanel.getPreferredSize();
                int y = parent.getHeight() - size.height - this.myLayoutData.configuration.bottomSpaceHeight;
                this.myActionPanel.setBounds(0, y, width, size.height);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/notification/impl/NotificationsManagerImpl$CenteredLayoutWithActions", "layoutSize"));
        }
    }

    private static final class NotificationActionPanel
    extends NonOpaquePanel {
        private final List<LinkLabel<AnAction>> actionLinks = new ArrayList<LinkLabel<AnAction>>();
        private final Notification.CollapseActionsDirection collapseActionsDirection;
        private DropDownAction groupedActionsLink;

        private NotificationActionPanel(int gap, Notification.CollapseActionsDirection direction) {
            super((LayoutManager)new HorizontalLayout(gap, 0));
            this.collapseActionsDirection = direction;
        }

        public void addGroupedActionsLink(DropDownAction action2) {
            this.add((Component)((Object)action2));
            this.groupedActionsLink = action2;
        }

        public void addActionLink(LinkLabel<AnAction> label2) {
            this.add("LEFT", (Component)label2);
            this.actionLinks.add(label2);
        }

        public void addContextHelpLabel(ContextHelpLabel label2) {
            this.add("LEFT", (Component)label2);
        }
    }

    private static final class NotificationCenterPanel
    extends NonOpaquePanel {
        private final CenteredLayoutWithActions myLayout = (CenteredLayoutWithActions)this.getLayout();
        private final BalloonLayoutData myLayoutData;

        private NotificationCenterPanel(JEditorPane text2, BalloonLayoutData layoutData) {
            super((LayoutManager)new CenteredLayoutWithActions(text2, layoutData));
            this.myLayoutData = layoutData;
        }

        public void addTitle(JLabel title) {
            this.add(title, "North");
            this.myLayout.myTitleComponent = title;
        }

        public Component getTitle() {
            return this.myLayout.getTitle();
        }

        public void addExpandAction(LinkLabel<Void> action2) {
            this.add((Component)action2, "East");
            this.myLayout.myExpandAction = action2;
        }

        public void addContent(JComponent component2) {
            this.add(component2, "Center");
            this.myLayout.myCenteredComponent = component2;
        }

        public void addActionPanel(NotificationActionPanel panel2) {
            this.add((Component)((Object)panel2), "South");
            this.myLayout.myActionPanel = panel2;
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            Component title = this.myLayout.getTitle();
            if (title != null && this.myLayoutData.showActions != null && ((Boolean)this.myLayoutData.showActions.compute()).booleanValue()) {
                int width = this.myLayoutData.configuration.allActionsOffset;
                int x = this.getWidth() - width - JBUIScale.scale((int)5);
                int y = this.myLayoutData.configuration.topSpaceHeight;
                int height = title instanceof JEditorPane ? NotificationsManagerImpl.getFirstLineHeight((JEditorPane)title) : title.getHeight();
                g.setColor(this.myLayoutData.fillColor);
                g.fillRect(x, y, width, height);
                width = this.myLayoutData.configuration.beforeGearSpace;
                ((Graphics2D)g).setPaint(new GradientPaint(x -= width, y, ColorUtil.withAlpha((Color)this.myLayoutData.fillColor, (double)0.2), x + width, y, this.myLayoutData.fillColor));
                g.fillRect(x, y, width, height);
            }
        }
    }

    static final class MyNotificationListener
    implements Notifications {
        private final Project myProject;

        MyNotificationListener() {
            this.myProject = null;
        }

        private MyNotificationListener(@Nullable Project project) {
            this.myProject = project;
        }

        public void notify(@NotNull Notification notification2) {
            if (notification2 == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            ((NotificationsManagerImpl)NotificationsManager.getNotificationsManager()).doNotify(notification2, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl$MyNotificationListener", "notify"));
        }
    }

    private static class DropDownAction
    extends LinkLabel<Void> {
        Icon myIcon = AllIcons.Ide.Notification.DropTriangle;

        DropDownAction(@NlsContexts.LinkLabel String text2, @Nullable LinkListener<Void> listener2) {
            super(text2, null, listener2);
            this.setHorizontalTextPosition(10);
            this.setIconTextGap(0);
            this.setIcon(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    IconUtil.colorize((Graphics2D)((Graphics2D)g), (Icon)myIcon, (Color)this.getTextColor()).paintIcon(c, g, x - 1, y + 1);
                }

                @Override
                public int getIconWidth() {
                    return myIcon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return myIcon.getIconHeight();
                }
            });
        }

        @NotNull
        protected Rectangle getTextBounds() {
            Rectangle bounds2 = super.getTextBounds();
            bounds2.x -= this.getIcon().getIconWidth();
            bounds2.width += 8;
            Rectangle rectangle = bounds2;
            if (rectangle == null) {
                DropDownAction.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsManagerImpl$DropDownAction", "getTextBounds"));
        }
    }

    static final class ProjectNotificationsComponent {
        ProjectNotificationsComponent(@NotNull Project project) {
            if (project == null) {
                ProjectNotificationsComponent.$$$reportNull$$$0(0);
            }
            if (NotificationsManagerImpl.isDummyEnvironment()) {
                return;
            }
            project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/impl/NotificationsManagerImpl$ProjectNotificationsComponent", "<init>"));
        }
    }

    private static final class HoverAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private final List<Pair<Component, ?>> myComponents = new ArrayList();
        private List<Component> mySources = new ArrayList<Component>();
        private Component myLastComponent;

        private HoverAdapter() {
        }

        public void addComponent(@NotNull Component component2, @NotNull Function<? super Component, ? extends Rectangle> hover) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(0);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(1);
            }
            this.myComponents.add(Pair.create((Object)component2, hover));
        }

        public void addComponent(@NotNull Component component2, @NotNull Insets hover) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(2);
            }
            if (hover == null) {
                HoverAdapter.$$$reportNull$$$0(3);
            }
            this.myComponents.add(Pair.create((Object)component2, (Object)hover));
        }

        public void addSource(@NotNull Component component2) {
            if (component2 == null) {
                HoverAdapter.$$$reportNull$$$0(4);
            }
            this.mySources.add(component2);
        }

        public void initListeners() {
            if (!this.myComponents.isEmpty()) {
                for (Component source : this.mySources) {
                    source.addMouseMotionListener(this);
                    source.addMouseListener(this);
                }
                this.mySources = null;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleEvent(e, true, false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e, false, false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e, false, true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.myLastComponent != null) {
                HoverAdapter.mouseExited(e, this.myLastComponent);
                this.myLastComponent = null;
            }
        }

        private void handleEvent(MouseEvent e, boolean pressed, boolean moved) {
            HTMLDocument document;
            AttributeSet attributes;
            JEditorPane pane2;
            int pos;
            if (e.getSource() instanceof JEditorPane && (pos = (pane2 = (JEditorPane)e.getSource()).viewToModel(e.getPoint())) >= 0 && (attributes = (document = (HTMLDocument)pane2.getDocument()).getCharacterElement(pos).getAttributes()).getAttribute(HTML.Tag.A) != null) {
                return;
            }
            for (Pair<Component, ?> p : this.myComponents) {
                Rectangle bounds2;
                Component component2 = (Component)p.first;
                if (p.second instanceof Insets) {
                    bounds2 = component2.getBounds();
                    JBInsets.addTo((Rectangle)bounds2, (Insets)((Insets)p.second));
                } else {
                    bounds2 = (Rectangle)((Function)p.second).fun((Object)component2);
                }
                if (bounds2.contains(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), component2.getParent()))) {
                    if (this.myLastComponent != null && this.myLastComponent != component2) {
                        HoverAdapter.mouseExited(e, this.myLastComponent);
                    }
                    this.myLastComponent = component2;
                    MouseEvent event = HoverAdapter.createEvent(e, component2);
                    if (moved) {
                        for (MouseMotionListener listener2 : component2.getMouseMotionListeners()) {
                            listener2.mouseMoved(event);
                        }
                    } else {
                        MouseListener[] listeners = component2.getMouseListeners();
                        if (pressed) {
                            for (MouseListener listener3 : listeners) {
                                listener3.mousePressed(event);
                            }
                        } else {
                            for (MouseListener listener4 : listeners) {
                                listener4.mouseReleased(event);
                            }
                        }
                    }
                    e.getComponent().setCursor(component2.getCursor());
                    return;
                }
                if (component2 != this.myLastComponent) continue;
                this.myLastComponent = null;
                HoverAdapter.mouseExited(e, component2);
            }
        }

        private static void mouseExited(MouseEvent e, Component component2) {
            MouseListener[] listeners;
            e.getComponent().setCursor(null);
            MouseEvent event = HoverAdapter.createEvent(e, component2);
            for (MouseListener listener2 : listeners = component2.getMouseListeners()) {
                listener2.mouseExited(event);
            }
        }

        @NotNull
        private static MouseEvent createEvent(MouseEvent e, Component c) {
            return new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), 5, 5, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hover";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/notification/impl/NotificationsManagerImpl$HoverAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

