/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.InvokeQuickListAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.BundledQuickListsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0014\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\b\u0010\u001a\u001a\u00020\u0015H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "", "()V", "allQuickLists", "", "Lcom/intellij/openapi/actionSystem/ex/QuickList;", "getAllQuickLists", "()[Lcom/intellij/openapi/actionSystem/ex/QuickList;", "myActionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "kotlin.jvm.PlatformType", "getMyActionManager", "()Lcom/intellij/openapi/actionSystem/ActionManager;", "myActionManager$delegate", "Lkotlin/Lazy;", "mySchemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "schemeManager", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "registerActions", "", "actionManager", "setQuickLists", "quickLists", "", "unregisterActions", "Companion", "QuickListActionCustomizer", "intellij.platform.ide.impl"})
public final class QuickListsManager {
    private final SchemeManager<QuickList> mySchemeManager;
    private final Lazy myActionManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)myActionManager.2.INSTANCE);
    public static final Companion Companion = new Companion(null);

    private final ActionManager getMyActionManager() {
        Lazy lazy = this.myActionManager$delegate;
        QuickListsManager quickListsManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ActionManager)lazy.getValue();
    }

    @NotNull
    public final SchemeManager<QuickList> getSchemeManager() {
        return this.mySchemeManager;
    }

    @NotNull
    public final QuickList[] getAllQuickLists() {
        Collection $this$toTypedArray$iv = this.mySchemeManager.getAllSchemes();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        QuickList[] quickListArray = thisCollection$iv.toArray(new QuickList[0]);
        if (quickListArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return quickListArray;
    }

    private final void registerActions(ActionManager actionManager) {
        HashSet<String> registeredIds = new HashSet<String>();
        for (QuickList scheme : this.mySchemeManager.getAllSchemes()) {
            String actionId;
            Intrinsics.checkNotNullExpressionValue((Object)scheme.getActionId(), (String)"scheme.actionId");
            if (!registeredIds.add(actionId)) continue;
            actionManager.registerAction(actionId, (AnAction)new InvokeQuickListAction(scheme));
        }
    }

    private final void unregisterActions() {
        ActionManager actionManager = this.getMyActionManager();
        for (String oldId : actionManager.getActionIdList("QuickList.")) {
            actionManager.unregisterAction(oldId);
        }
    }

    public final void setQuickLists(@NotNull List<? extends QuickList> quickLists) {
        Intrinsics.checkNotNullParameter(quickLists, (String)"quickLists");
        this.unregisterActions();
        SchemeManager.setSchemes$default(this.mySchemeManager, quickLists, null, null, 6, null);
        ActionManager actionManager = this.getMyActionManager();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"myActionManager");
        this.registerActions(actionManager);
    }

    public QuickListsManager() {
        this.mySchemeManager = SchemeManagerFactory.create$default(SchemeManagerFactory.Companion.getInstance(), "quicklists", new LazySchemeProcessor<QuickList, QuickList>("display"){

            @Override
            @NotNull
            public QuickList createScheme(@NotNull SchemeDataHolder<? super QuickList> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
                QuickList item = new QuickList();
                item.readExternal(dataHolder.read());
                dataHolder.updateDigest(item);
                return item;
            }
        }, IdeBundle.message((String)"quick.lists.presentable.name", (Object[])new Object[0]), null, 8, null);
        ExtensionPointName<BundledQuickListsProvider> extensionPointName = BundledQuickListsProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"BundledQuickListsProvider.EP_NAME");
        Iterator iterator2 = extensionPointName.getExtensionList().iterator();
        while (iterator2.hasNext()) {
            BundledQuickListsProvider provider2;
            BundledQuickListsProvider bundledQuickListsProvider = provider2 = (BundledQuickListsProvider)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)bundledQuickListsProvider, (String)"provider");
            String[] stringArray = bundledQuickListsProvider.getBundledListsRelativePaths();
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String path;
                String string = path = stringArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                this.mySchemeManager.loadBundledScheme(string, provider2);
            }
        }
        this.mySchemeManager.loadSchemes();
    }

    @NotNull
    public static final QuickListsManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager$QuickListActionCustomizer;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer;", "()V", "customize", "", "manager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "intellij.platform.ide.impl"})
    public static final class QuickListActionCustomizer
    implements ActionConfigurationCustomizer {
        @Override
        public void customize(@NotNull ActionManager manager) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Companion.getInstance().registerActions(manager);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager$Companion;", "", "()V", "instance", "Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "getInstance$annotations", "getInstance", "()Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final QuickListsManager getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(QuickListsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (QuickListsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

