/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.impl.FlushQueue;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTEvent;
import java.awt.event.InvocationEvent;
import java.lang.reflect.Field;
import javax.swing.RepaintManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InvocationUtil {
    @NotNull
    public static final Class<? extends Runnable> FLUSH_NOW_CLASS = FlushQueue.FlushNow.class;
    @NotNull
    public static final Class<? extends Runnable> REPAINT_PROCESSING_CLASS = InvocationUtil.findProcessingClass();
    @NotNull
    private static final Field INVOCATION_EVENT_RUNNABLE_FIELD = InvocationUtil.findRunnableField();

    private InvocationUtil() {
    }

    @Nullable
    public static Runnable extractRunnable(@NotNull AWTEvent event) {
        if (event == null) {
            InvocationUtil.$$$reportNull$$$0(0);
        }
        return event instanceof InvocationEvent ? (Runnable)ReflectionUtil.getFieldValue((Field)INVOCATION_EVENT_RUNNABLE_FIELD, (Object)event) : null;
    }

    @NotNull
    private static Class<? extends Runnable> findProcessingClass() {
        Class<Runnable> clazz;
        try {
            clazz = Class.forName("javax.swing.RepaintManager$ProcessingRunnable", false, InvocationUtil.class.getClassLoader()).asSubclass(Runnable.class);
        }
        catch (ClassNotFoundException e) {
            throw new InternalAPIChangedException(RepaintManager.class, e);
        }
        if (clazz == null) {
            InvocationUtil.$$$reportNull$$$0(1);
        }
        return clazz;
    }

    @NotNull
    private static Field findRunnableField() {
        Field field;
        try {
            field = ReflectionUtil.findAssignableField(InvocationEvent.class, Runnable.class, (String)"runnable");
        }
        catch (NoSuchFieldException e) {
            throw new InternalAPIChangedException(InvocationEvent.class, e);
        }
        if (field == null) {
            InvocationUtil.$$$reportNull$$$0(2);
        }
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/InvocationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/InvocationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findProcessingClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findRunnableField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractRunnable";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class InternalAPIChangedException
    extends RuntimeException {
        InternalAPIChangedException(@NotNull Class<?> targetClass, @Nullable ReflectiveOperationException cause) {
            if (targetClass == null) {
                InternalAPIChangedException.$$$reportNull$$$0(0);
            }
            super(targetClass + " class internal API has been changed", cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/openapi/application/impl/InvocationUtil$InternalAPIChangedException", "<init>"));
        }
    }
}

