/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.ImaginaryCaretModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImaginaryCaret
extends UserDataHolderBase
implements Caret {
    private final ImaginaryCaretModel myCaretModel;
    private int myStart;
    private int myEnd;

    ImaginaryCaret(ImaginaryCaretModel caretModel) {
        this.myCaretModel = caretModel;
    }

    public int getSelectionStart() {
        return this.myStart;
    }

    public int getSelectionEnd() {
        return this.myEnd;
    }

    public boolean hasSelection() {
        return false;
    }

    @NotNull
    public ImaginaryEditor getEditor() {
        ImaginaryEditor imaginaryEditor = this.myCaretModel.getEditor();
        if (imaginaryEditor == null) {
            ImaginaryCaret.$$$reportNull$$$0(0);
        }
        return imaginaryEditor;
    }

    @NotNull
    public CaretModel getCaretModel() {
        ImaginaryCaretModel imaginaryCaretModel = this.myCaretModel;
        if (imaginaryCaretModel == null) {
            ImaginaryCaret.$$$reportNull$$$0(1);
        }
        return imaginaryCaretModel;
    }

    public int getOffset() {
        return this.myStart;
    }

    public void moveToOffset(int offset) {
        this.myStart = this.myEnd = offset;
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.myStart = this.myEnd = offset;
    }

    private RuntimeException notImplemented() {
        return this.getEditor().notImplemented();
    }

    public boolean isValid() {
        throw this.notImplemented();
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        throw this.notImplemented();
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            ImaginaryCaret.$$$reportNull$$$0(2);
        }
        this.moveToOffset(this.getEditor().logicalPositionToOffset(pos));
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            ImaginaryCaret.$$$reportNull$$$0(3);
        }
        this.moveToOffset(this.getEditor().visualPositionToOffset(pos));
    }

    public boolean isUpToDate() {
        throw this.notImplemented();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getEditor().offsetToLogicalPosition(this.myStart);
        if (logicalPosition == null) {
            ImaginaryCaret.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        throw this.notImplemented();
    }

    public int getVisualLineStart() {
        throw this.notImplemented();
    }

    public int getVisualLineEnd() {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        throw this.notImplemented();
    }

    @Nullable
    public String getSelectedText() {
        return this.getEditor().getDocument().getText(new TextRange(this.myStart, this.myEnd));
    }

    public int getLeadSelectionOffset() {
        throw this.notImplemented();
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        throw this.notImplemented();
    }

    public void setSelection(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > endOffset) {
            throw new IllegalArgumentException();
        }
        this.myStart = startOffset;
        this.myEnd = endOffset;
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        throw this.notImplemented();
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        throw this.notImplemented();
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        throw this.notImplemented();
    }

    public void removeSelection() {
        this.myStart = this.myEnd;
    }

    public void selectLineAtCaret() {
        throw this.notImplemented();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        throw this.notImplemented();
    }

    @Nullable
    public Caret clone(boolean above) {
        throw this.notImplemented();
    }

    public boolean isAtRtlLocation() {
        throw this.notImplemented();
    }

    public boolean isAtBidiRunBoundary() {
        throw this.notImplemented();
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        throw this.notImplemented();
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            ImaginaryCaret.$$$reportNull$$$0(5);
        }
        throw this.notImplemented();
    }

    public void dispose() {
        throw this.notImplemented();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ImaginaryCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ImaginaryCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVisualAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

