/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IntPair;
import com.intellij.util.Processor;
import gnu.trove.TIntArrayList;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class EditorSizeManager
implements PrioritizedDocumentListener,
Disposable,
FoldingListener,
InlayModel.Listener,
Dumpable {
    private static final Logger LOG = Logger.getInstance(EditorSizeManager.class);
    private static final int UNKNOWN_WIDTH = Integer.MAX_VALUE;
    private static final int SPECIFIC_LINES_RECALC_THRESHOLD = 2;
    private final EditorView myView;
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final TIntArrayList myLineWidths = new TIntArrayList();
    private boolean myWidthIsValid = true;
    private int myWidthInPixels;
    private int myWidthDefiningLineNumber;
    private int myStartInvalidLine = Integer.MAX_VALUE;
    private int myEndInvalidLine = 0;
    private int myMaxLineWithExtensionWidth;
    private int myWidestLineWithExtension;
    private int myDocumentChangeStartOffset;
    private int myDocumentChangeEndOffset;
    private int myFoldingChangeStartOffset = Integer.MAX_VALUE;
    private int myFoldingChangeEndOffset = Integer.MIN_VALUE;
    private int myVirtualPageHeight;
    private boolean myDuringDocumentUpdate;
    private boolean myDirty;
    private boolean myAfterLineEndInlayUpdated;
    private final List<TextRange> myDeferredRanges = new ArrayList<TextRange>();
    private boolean myWidestBlockInlayValid;
    private Inlay<?> myWidestBlockInlay;
    private final SoftWrapAwareDocumentParsingListenerAdapter mySoftWrapChangeListener = new SoftWrapAwareDocumentParsingListenerAdapter(){

        @Override
        public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            EditorSizeManager.this.onSoftWrapRecalculationEnd(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/view/EditorSizeManager$1", "onRecalculationEnd"));
        }
    };

    EditorSizeManager(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
        this.myDocument = this.myEditor.getDocument();
        this.myDocument.addDocumentListener(this, this);
        this.myEditor.getFoldingModel().addListener(this, this);
        this.myEditor.getSoftWrapModel().getApplianceManager().addListener(this.mySoftWrapChangeListener);
        this.myEditor.getInlayModel().addListener(this, this);
    }

    public void dispose() {
        this.myEditor.getSoftWrapModel().getApplianceManager().removeListener(this.mySoftWrapChangeListener);
        this.invalidateCachedBlockInlayWidth();
    }

    @Override
    public int getPriority() {
        return 110;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorSizeManager.$$$reportNull$$$0(0);
        }
        this.assertValidState();
        this.myAfterLineEndInlayUpdated = false;
        this.myDuringDocumentUpdate = true;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        int offset = event.getOffset();
        int moveOffset = DocumentEventUtil.isMoveInsertion(event) ? event.getMoveOffset() : offset;
        int length = event.getNewLength();
        this.myDocumentChangeStartOffset = Math.min(offset, moveOffset);
        this.myDocumentChangeEndOffset = Math.max(offset, moveOffset) + length;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorSizeManager.$$$reportNull$$$0(1);
        }
        this.myDuringDocumentUpdate = false;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.doInvalidateRange(this.myDocumentChangeStartOffset, this.myDocumentChangeEndOffset);
        if (this.myAfterLineEndInlayUpdated) {
            int lineEndOffset = DocumentUtil.getLineEndOffset(this.myDocumentChangeEndOffset, this.myDocument);
            this.doInvalidateRange(lineEndOffset, lineEndOffset);
        }
        this.assertValidState();
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            EditorSizeManager.$$$reportNull$$$0(2);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (region.isValid()) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, region.getStartOffset());
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, region.getEndOffset());
        }
    }

    @Override
    public void onFoldProcessingEnd() {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myFoldingChangeStartOffset <= this.myFoldingChangeEndOffset) {
            this.doInvalidateRange(this.myFoldingChangeStartOffset, this.myFoldingChangeEndOffset);
        }
        this.myFoldingChangeStartOffset = Integer.MAX_VALUE;
        this.myFoldingChangeEndOffset = Integer.MIN_VALUE;
        for (TextRange range2 : this.myDeferredRanges) {
            this.onTextLayoutPerformed(range2.getStartOffset(), range2.getEndOffset());
        }
        this.myDeferredRanges.clear();
        this.invalidateCachedBlockInlayWidth();
        this.assertValidState();
    }

    public void onAdded(@NotNull Inlay inlay) {
        if (inlay == null) {
            EditorSizeManager.$$$reportNull$$$0(3);
        }
        if (this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode()) {
            return;
        }
        if (inlay.getPlacement() == Inlay.Placement.INLINE || inlay.getPlacement() == Inlay.Placement.AFTER_LINE_END) {
            this.onLineInlayUpdate(inlay);
        } else if (this.myWidestBlockInlayValid && inlay.getWidthInPixels() > this.getCachedWidestBlockInlayWidth() && !EditorUtil.isInlayFolded(inlay)) {
            this.myWidestBlockInlay = inlay;
        }
    }

    public void onRemoved(@NotNull Inlay inlay) {
        if (inlay == null) {
            EditorSizeManager.$$$reportNull$$$0(4);
        }
        if (this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode()) {
            return;
        }
        if (inlay.getPlacement() == Inlay.Placement.INLINE || inlay.getPlacement() == Inlay.Placement.AFTER_LINE_END) {
            this.onLineInlayUpdate(inlay);
        } else if (inlay == this.myWidestBlockInlay) {
            this.invalidateCachedBlockInlayWidth();
        }
    }

    public void onUpdated(@NotNull Inlay inlay, int changeFlags) {
        if (inlay == null) {
            EditorSizeManager.$$$reportNull$$$0(5);
        }
        if (this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode() || (changeFlags & 1) == 0) {
            return;
        }
        if (inlay.getPlacement() == Inlay.Placement.INLINE || inlay.getPlacement() == Inlay.Placement.AFTER_LINE_END) {
            this.onLineInlayUpdate(inlay);
        } else if (this.myWidestBlockInlayValid && (inlay == this.myWidestBlockInlay || inlay.getWidthInPixels() > this.getCachedWidestBlockInlayWidth() && !EditorUtil.isInlayFolded(inlay))) {
            if (inlay == this.myWidestBlockInlay) {
                this.invalidateCachedBlockInlayWidth();
            } else {
                this.myWidestBlockInlay = inlay;
            }
        }
    }

    public void onBatchModeStart(@NotNull Editor editor) {
        if (editor == null) {
            EditorSizeManager.$$$reportNull$$$0(6);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.getPreferredSize();
    }

    public void onBatchModeFinish(@NotNull Editor editor) {
        if (editor == null) {
            EditorSizeManager.$$$reportNull$$$0(7);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.reset();
    }

    private void onLineInlayUpdate(@NotNull Inlay<?> inlay) {
        if (inlay == null) {
            EditorSizeManager.$$$reportNull$$$0(8);
        }
        if (this.myDuringDocumentUpdate) {
            if (inlay.getPlacement() == Inlay.Placement.AFTER_LINE_END) {
                this.myAfterLineEndInlayUpdated = true;
            }
            return;
        }
        int offset = inlay.getOffset();
        if (inlay.getPlacement() == Inlay.Placement.AFTER_LINE_END) {
            offset = DocumentUtil.getLineEndOffset(offset, this.myDocument);
        }
        this.doInvalidateRange(offset, offset);
    }

    private void onSoftWrapRecalculationEnd(IncrementalCacheUpdateEvent event) {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        boolean invalidate = true;
        if (this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, event.getStartOffset());
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, event.getActualEndOffset());
            invalidate = false;
        }
        if (this.myDuringDocumentUpdate) {
            this.myDocumentChangeStartOffset = Math.min(this.myDocumentChangeStartOffset, event.getStartOffset());
            this.myDocumentChangeEndOffset = Math.max(this.myDocumentChangeEndOffset, event.getActualEndOffset());
            invalidate = false;
        }
        if (invalidate) {
            this.doInvalidateRange(event.getStartOffset(), event.getActualEndOffset());
        }
    }

    Dimension getPreferredSize() {
        int widthWithoutCaret;
        Insets insets = this.myView.getInsets();
        int width = widthWithoutCaret = this.getTextPreferredWidth() + insets.left;
        if (!this.myDocument.isInBulkUpdate() && !this.myEditor.getInlayModel().isInBatchMode() && !this.myEditor.isRightAligned() && this.myEditor.getSettings().isVirtualSpace()) {
            CaretModelImpl caretModel = this.myEditor.getCaretModel();
            int caretMaxX = (caretModel.isIteratingOverCarets() ? Stream.of(caretModel.getCurrentCaret()) : caretModel.getAllCarets().stream()).filter(caret -> caret.isUpToDate() && ((CaretImpl)((Object)caret)).isInVirtualSpace()).mapToInt(c -> (int)this.myView.visualPositionToXY(c.getVisualPosition()).getX()).max().orElse(0);
            width = Math.max(width, caretMaxX);
        }
        width = Math.max(width, insets.left + this.getMaximumVisibleBlockInlayWidth());
        if (this.shouldRespectAdditionalColumns(widthWithoutCaret)) {
            width = (int)((float)width + (float)this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth());
        }
        return new Dimension(width + insets.right, this.getPreferredHeight());
    }

    int getPreferredWidth(int beginLine, int endLine) {
        int widthWithoutCaret;
        Insets insets = this.myView.getInsets();
        int width = widthWithoutCaret = this.getTextPreferredWidthWithoutCaret(beginLine, endLine) + insets.left;
        if (!(this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode() || this.myEditor.isRightAligned())) {
            CaretModelImpl caretModel = this.myEditor.getCaretModel();
            int caretMaxX = (caretModel.isIteratingOverCarets() ? Stream.of(caretModel.getCurrentCaret()) : caretModel.getAllCarets().stream()).filter(Caret::isUpToDate).filter(caret -> caret.getVisualPosition().line >= beginLine && caret.getVisualPosition().line < endLine).mapToInt(c -> (int)this.myView.visualPositionToXY(c.getVisualPosition()).getX()).max().orElse(0);
            width = Math.max(width, caretMaxX);
        }
        if (this.shouldRespectAdditionalColumns(widthWithoutCaret)) {
            width = (int)((float)width + (float)this.myEditor.getSettings().getAdditionalColumnsCount() * this.myView.getPlainSpaceWidth());
        }
        return width + insets.right;
    }

    int getPreferredHeight() {
        int lineHeight = this.myView.getLineHeight();
        if (this.myEditor.isOneLineMode()) {
            return lineHeight;
        }
        int size = this.myView.visualLineToY(this.myEditor.getVisibleLineCount());
        EditorSettings settings = this.myEditor.getSettings();
        if (settings.isAdditionalPageAtBottom()) {
            int visibleAreaHeight = this.myEditor.getScrollingModel().getVisibleArea().height;
            if (visibleAreaHeight > 0 || this.myVirtualPageHeight <= 0) {
                this.myVirtualPageHeight = Math.max(visibleAreaHeight - 2 * lineHeight, lineHeight);
            }
            size += Math.max(this.myVirtualPageHeight, 0);
        } else {
            size += settings.getAdditionalLinesCount() * lineHeight;
        }
        Insets insets = this.myView.getInsets();
        return size + insets.top + insets.bottom;
    }

    private boolean shouldRespectAdditionalColumns(int widthWithoutCaret) {
        return !this.myEditor.getSoftWrapModel().isSoftWrappingEnabled() || this.myEditor.getSoftWrapModel().isRespectAdditionalColumns() || (double)widthWithoutCaret > this.myEditor.getScrollingModel().getVisibleArea().getWidth();
    }

    private int getTextPreferredWidth() {
        if (!this.myWidthIsValid) {
            IntPair pair;
            assert (!this.myDocument.isInBulkUpdate());
            assert (!this.myEditor.getInlayModel().isInBatchMode());
            boolean needFullScan = true;
            if (this.myStartInvalidLine <= this.myEndInvalidLine && this.myEndInvalidLine - this.myStartInvalidLine < 2) {
                pair = this.calculateTextPreferredWidth(this.myStartInvalidLine, this.myEndInvalidLine);
                boolean bl = needFullScan = pair.first < this.myWidthInPixels && this.myStartInvalidLine <= this.myWidthDefiningLineNumber && this.myWidthDefiningLineNumber <= this.myEndInvalidLine;
                if (pair.first >= this.myWidthInPixels) {
                    this.myWidthInPixels = pair.first;
                    this.myWidthDefiningLineNumber = pair.second;
                }
            }
            if (needFullScan) {
                pair = this.calculateTextPreferredWidth(0, Integer.MAX_VALUE);
                this.myWidthInPixels = pair.first;
                this.myWidthDefiningLineNumber = pair.second;
            }
            this.myWidthIsValid = true;
            this.myStartInvalidLine = Integer.MAX_VALUE;
            this.myEndInvalidLine = 0;
        }
        this.validateMaxLineWithExtension();
        return Math.max(this.myWidthInPixels, this.myMaxLineWithExtensionWidth);
    }

    private int getTextPreferredWidthWithoutCaret(int beginLine, int endLine) {
        if (!this.myWidthIsValid) {
            assert (!this.myDocument.isInBulkUpdate());
            assert (!this.myEditor.getInlayModel().isInBatchMode());
            this.calculateTextPreferredWidth(0, Integer.MAX_VALUE);
        }
        int maxWidth = beginLine == 0 && endLine == 0 ? (int)this.myView.getPrefixTextWidthInPixels() : 0;
        for (int i2 = beginLine; i2 < endLine && i2 < this.myLineWidths.size(); ++i2) {
            maxWidth = Math.max(maxWidth, Math.abs(this.myLineWidths.get(i2)));
        }
        this.validateMaxLineWithExtension();
        return Math.max(maxWidth, this.myMaxLineWithExtensionWidth);
    }

    private void validateMaxLineWithExtension() {
        boolean hasNoExtensions;
        if (this.myMaxLineWithExtensionWidth > 0 && (hasNoExtensions = this.myEditor.processLineExtensions(this.myWidestLineWithExtension, (Processor<? super LineExtensionInfo>)((Processor)info -> false)))) {
            this.myMaxLineWithExtensionWidth = 0;
        }
    }

    private IntPair calculateTextPreferredWidth(int startVisualLine, int endVisualLine) {
        if (this.checkDirty()) {
            return new IntPair(1, 0);
        }
        this.assertValidState();
        VisualLinesIterator iterator2 = new VisualLinesIterator(this.myEditor, startVisualLine);
        int maxWidth = 0;
        int largestLineNumber = 0;
        while (!iterator2.atEnd()) {
            int width = this.getVisualLineWidth(iterator2, true);
            if (width > maxWidth) {
                maxWidth = width;
                largestLineNumber = iterator2.getVisualLine();
            }
            if (iterator2.getVisualLine() >= endVisualLine) break;
            iterator2.advance();
        }
        return new IntPair(maxWidth, largestLineNumber);
    }

    int getVisualLineWidth(VisualLinesIterator visualLinesIterator, boolean allowQuickCalculation) {
        int cached;
        assert (!visualLinesIterator.atEnd());
        int visualLine = visualLinesIterator.getVisualLine();
        boolean useCache = this.shouldUseLineWidthCache();
        int n = cached = useCache ? this.myLineWidths.get(visualLine) : Integer.MAX_VALUE;
        if (cached != Integer.MAX_VALUE && (cached >= 0 || allowQuickCalculation)) {
            return Math.abs(cached);
        }
        Ref evaluatedQuick = Ref.create((Object)Boolean.FALSE);
        int width = this.calculateLineWidth(visualLinesIterator, allowQuickCalculation ? () -> evaluatedQuick.set((Object)Boolean.TRUE) : null);
        if (useCache) {
            this.myLineWidths.set(visualLine, (Boolean)evaluatedQuick.get() != false ? -width : width);
        }
        return width;
    }

    private int calculateLineWidth(@NotNull VisualLinesIterator iterator2, @Nullable Runnable quickEvaluationListener) {
        if (iterator2 == null) {
            EditorSizeManager.$$$reportNull$$$0(9);
        }
        int visualLine = iterator2.getVisualLine();
        FoldRegion[] topLevelRegions = this.myEditor.getFoldingModel().fetchTopLevel();
        if (!(quickEvaluationListener == null || topLevelRegions != null && topLevelRegions.length != 0 || !this.myEditor.getSoftWrapModel().getRegisteredSoftWraps().isEmpty() || this.myDocument.getLineCount() != 0 && this.myView.getTextLayoutCache().hasCachedLayoutFor(visualLine) || this.myEditor.getInlayModel().hasInlineElements() || this.myEditor.getInlayModel().hasAfterLineEndElements() || visualLine <= 0 && this.myView.getPrefixTextWidthInPixels() != 0.0f)) {
            quickEvaluationListener.run();
            return (int)((float)this.myView.getLogicalPositionCache().offsetToLogicalColumn(visualLine, this.myDocument.getLineEndOffset(visualLine) - this.myDocument.getLineStartOffset(visualLine)) * this.myView.getMaxCharWidth());
        }
        float x = visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
        int maxOffset = iterator2.getVisualLineStartOffset();
        int leftInset = this.myView.getInsets().left;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, iterator2, quickEvaluationListener, false)) {
            x = fragment.getEndX() - (float)leftInset;
            maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
        }
        if (this.myEditor.getSoftWrapModel().getSoftWrap(maxOffset) != null) {
            x += (float)this.myEditor.getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        } else {
            List<Inlay<?>> inlays = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(iterator2.getEndLogicalLine());
            if (!inlays.isEmpty()) {
                x += this.myView.getPlainSpaceWidth();
                for (Inlay<?> inlay : inlays) {
                    x += (float)inlay.getWidthInPixels();
                }
            }
        }
        return (int)x;
    }

    void reset() {
        assert (!this.myDocument.isInBulkUpdate());
        assert (!this.myEditor.getInlayModel().isInBatchMode());
        this.doInvalidateRange(0, this.myDocument.getTextLength());
        this.invalidateCachedBlockInlayWidth();
    }

    void invalidateRange(int startOffset, int endOffset) {
        if (this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode()) {
            return;
        }
        if (this.myDuringDocumentUpdate) {
            this.myDocumentChangeStartOffset = Math.min(this.myDocumentChangeStartOffset, startOffset);
            this.myDocumentChangeEndOffset = Math.max(this.myDocumentChangeEndOffset, endOffset);
        } else if (this.myFoldingChangeEndOffset != Integer.MIN_VALUE) {
            this.myFoldingChangeStartOffset = Math.min(this.myFoldingChangeStartOffset, startOffset);
            this.myFoldingChangeEndOffset = Math.max(this.myFoldingChangeEndOffset, endOffset);
        } else {
            this.doInvalidateRange(startOffset, endOffset);
        }
    }

    private boolean shouldUseLineWidthCache() {
        FoldRegion[] regions;
        if (this.myView.getEditor().isPurePaintingMode()) {
            return false;
        }
        FoldingModelImpl model2 = this.myView.getEditor().getFoldingModel();
        if (model2.isFoldingEnabled()) {
            return true;
        }
        model2.setFoldingEnabled(true);
        try {
            regions = model2.fetchTopLevel();
        }
        finally {
            model2.setFoldingEnabled(false);
        }
        return regions == null || regions.length == 0;
    }

    private void doInvalidateRange(int startOffset, int endOffset) {
        if (this.checkDirty()) {
            return;
        }
        int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
        int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
        int lineDiff = this.myEditor.getVisibleLineCount() - this.myLineWidths.size();
        this.invalidateWidth(lineDiff == 0 && startVisualLine == endVisualLine, startVisualLine);
        if (lineDiff > 0) {
            int[] newEntries = new int[lineDiff];
            this.myLineWidths.insert(startVisualLine, newEntries);
        } else if (lineDiff < 0) {
            this.myLineWidths.remove(startVisualLine, -lineDiff);
        }
        for (int i2 = startVisualLine; i2 <= endVisualLine && i2 < this.myLineWidths.size(); ++i2) {
            this.myLineWidths.set(i2, Integer.MAX_VALUE);
        }
    }

    int getMaxLineWithExtensionWidth() {
        return this.myMaxLineWithExtensionWidth;
    }

    void setMaxLineWithExtensionWidth(int lineNumber, int width) {
        this.myWidestLineWithExtension = lineNumber;
        this.myMaxLineWithExtensionWidth = width;
    }

    private int getMaximumVisibleBlockInlayWidth() {
        if (!this.myWidestBlockInlayValid) {
            this.myWidestBlockInlayValid = true;
            this.myWidestBlockInlay = null;
            this.myEditor.getInlayModel().getBlockElementsInRange(0, this.myDocument.getTextLength()).forEach(inlay -> {
                if (inlay.getWidthInPixels() > this.getCachedWidestBlockInlayWidth() && !EditorUtil.isInlayFolded(inlay)) {
                    this.myWidestBlockInlay = inlay;
                }
            });
        }
        return this.getCachedWidestBlockInlayWidth();
    }

    private int getCachedWidestBlockInlayWidth() {
        return this.myWidestBlockInlay == null ? 0 : this.myWidestBlockInlay.getWidthInPixels();
    }

    private void invalidateCachedBlockInlayWidth() {
        this.myWidestBlockInlayValid = false;
        this.myWidestBlockInlay = null;
    }

    void textLayoutPerformed(int startOffset, int endOffset) {
        assert (0 <= startOffset && startOffset < endOffset && endOffset <= this.myDocument.getTextLength()) : "startOffset=" + startOffset + ", endOffset=" + endOffset;
        if (this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode()) {
            return;
        }
        if (this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            this.myDeferredRanges.add(new TextRange(startOffset, endOffset));
        } else {
            this.onTextLayoutPerformed(startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTextLayoutPerformed(int startOffset, int endOffset) {
        if (this.checkDirty()) {
            return;
        }
        boolean purePaintingMode = this.myEditor.isPurePaintingMode();
        boolean foldingEnabled = this.myEditor.getFoldingModel().isFoldingEnabled();
        this.myEditor.setPurePaintingMode(false);
        this.myEditor.getFoldingModel().setFoldingEnabled(true);
        try {
            int startVisualLine = this.myView.offsetToVisualLine(startOffset, false);
            int endVisualLine = this.myView.offsetToVisualLine(endOffset, true);
            boolean sizeInvalidated = false;
            for (int i2 = startVisualLine; i2 <= endVisualLine; ++i2) {
                if (this.myLineWidths.get(i2) >= 0) continue;
                this.myLineWidths.set(i2, Integer.MAX_VALUE);
                sizeInvalidated = true;
            }
            if (sizeInvalidated) {
                this.invalidateWidth(startVisualLine == endVisualLine, startVisualLine);
                this.myEditor.getContentComponent().revalidate();
            }
        }
        finally {
            this.myEditor.setPurePaintingMode(purePaintingMode);
            this.myEditor.getFoldingModel().setFoldingEnabled(foldingEnabled);
        }
    }

    private void invalidateWidth(boolean invalidateOneLine, int invalidVisualLine) {
        this.myWidthIsValid = false;
        if (invalidateOneLine) {
            this.myStartInvalidLine = Math.min(this.myStartInvalidLine, invalidVisualLine);
            this.myEndInvalidLine = Math.max(this.myEndInvalidLine, invalidVisualLine);
        } else {
            this.myStartInvalidLine = 0;
            this.myEndInvalidLine = Integer.MAX_VALUE;
        }
    }

    private boolean checkDirty() {
        if (this.myEditor.getSoftWrapModel().isDirty()) {
            this.myDirty = true;
            return true;
        }
        if (this.myDirty) {
            int visibleLineCount = this.myEditor.getVisibleLineCount();
            int lineDiff = visibleLineCount - this.myLineWidths.size();
            if (lineDiff > 0) {
                this.myLineWidths.add(new int[lineDiff]);
            } else if (lineDiff < 0) {
                this.myLineWidths.remove(visibleLineCount, -lineDiff);
            }
            for (int i2 = 0; i2 < visibleLineCount; ++i2) {
                this.myLineWidths.set(i2, Integer.MAX_VALUE);
            }
            this.myDirty = false;
        }
        return false;
    }

    @NotNull
    public String dumpState() {
        String string = "[cached width: " + this.myWidthInPixels + ", longest visual line: " + this.myWidthDefiningLineNumber + ", cached width is valid: " + this.myWidthIsValid + ", widest block inlay: " + this.myWidestBlockInlay + ", widest block inlay is valid: " + this.myWidestBlockInlayValid + ", invalid visual lines: [" + this.myStartInvalidLine + ", " + this.myEndInvalidLine + "], max line with extension width: " + this.myMaxLineWithExtensionWidth + ", line widths: " + this.myLineWidths + "]";
        if (string == null) {
            EditorSizeManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void assertValidState() {
        if (this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode() || this.myDirty) {
            return;
        }
        if (this.myEditor.getVisibleLineCount() != this.myLineWidths.size()) {
            LOG.error("Inconsistent state", new Attachment[]{new Attachment("editor.txt", this.myEditor.dumpState())});
            this.reset();
            assert (this.myEditor.getVisibleLineCount() == this.myLineWidths.size());
        }
    }

    private void assertCorrectCachedWidths() {
        if (this.myDocument.isInBulkUpdate() || this.myEditor.getInlayModel().isInBatchMode() || this.myDirty) {
            return;
        }
        for (int visualLine = 0; visualLine < this.myLineWidths.size(); ++visualLine) {
            int cachedWidth = this.myLineWidths.get(visualLine);
            if (cachedWidth < 0 || cachedWidth == Integer.MAX_VALUE) continue;
            Ref quickEvaluation = new Ref();
            int actualWidth = this.calculateLineWidth(new VisualLinesIterator(this.myEditor, visualLine), () -> quickEvaluation.set((Object)Boolean.TRUE));
            assert (!quickEvaluation.isNull() || actualWidth == cachedWidth) : "Wrong cached width for visual line " + visualLine + ", cached: " + cachedWidth + ", actual: " + actualWidth;
        }
    }

    @TestOnly
    void validateState() {
        this.assertValidState();
        this.assertCorrectCachedWidths();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorSizeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorSizeManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onFoldRegionStateChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onAdded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onRemoved";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onUpdated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onBatchModeStart";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onBatchModeFinish";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onLineInlayUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateLineWidth";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

