/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class StatusBarProgress
extends ProgressIndicatorBase {
    private final Map<StatusBar, Pair<@NlsContexts.StatusBarText String, @NlsContexts.StatusBarText String>> myStatusBar2SavedText = new HashMap<StatusBar, Pair<String, String>>();
    private boolean myScheduledStatusBarTextSave;

    public StatusBarProgress() {
        super(true);
    }

    @Override
    public void start() {
        this.myScheduledStatusBarTextSave = false;
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.myScheduledStatusBarTextSave) {
            SwingUtilities.invokeLater(() -> {
                for (StatusBar statusBar : this.myStatusBar2SavedText.keySet()) {
                    String textToRestore = this.updateRestoreText(statusBar);
                    statusBar.setInfo(textToRestore);
                }
                this.myStatusBar2SavedText.clear();
            });
        }
    }

    @Override
    public void setText(String text2) {
        super.setText(text2);
        this.update();
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.update();
    }

    private void update() {
        Object text2;
        if (!this.isRunning()) {
            text2 = "";
        } else {
            text2 = this.getText();
            double fraction = this.getFraction();
            if (fraction > 0.0) {
                text2 = (String)text2 + " " + (int)(fraction * 100.0 + 0.5) + "%";
            }
        }
        String _text = text2;
        if (!this.myScheduledStatusBarTextSave) {
            this.myScheduledStatusBarTextSave = true;
            SwingUtilities.invokeLater(() -> {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    return;
                }
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length == 0) {
                    projects = new Project[]{null};
                }
                for (Project project : projects) {
                    StatusBar statusBar = windowManager.getStatusBar(project);
                    if (statusBar == null) continue;
                    String info = (String)ObjectUtils.notNull((Object)statusBar.getInfo(), (Object)"");
                    this.myStatusBar2SavedText.put(statusBar, (Pair<String, String>)Pair.pair((Object)info, (Object)info));
                }
            });
        }
        SwingUtilities.invokeLater(() -> {
            for (StatusBar statusBarEx : this.myStatusBar2SavedText.keySet()) {
                this.setStatusBarText(statusBarEx, _text);
            }
        });
    }

    private void setStatusBarText(StatusBar statusBar, @NlsContexts.StatusBarText String text2) {
        this.updateRestoreText(statusBar);
        Pair<@NlsContexts.StatusBarText String, @NlsContexts.StatusBarText String> textsPair = this.myStatusBar2SavedText.get(statusBar);
        this.myStatusBar2SavedText.put(statusBar, (Pair<String, String>)Pair.pair((Object)((String)textsPair.first), (Object)text2));
        statusBar.setInfo(text2);
    }

    @NlsContexts.StatusBarText
    private String updateRestoreText(StatusBar statusBar) {
        Pair<@NlsContexts.StatusBarText String, @NlsContexts.StatusBarText String> textsPair = this.myStatusBar2SavedText.get(statusBar);
        String info = (String)ObjectUtils.notNull((Object)statusBar.getInfo(), (Object)"");
        if (!((String)textsPair.second).equals(info)) {
            this.myStatusBar2SavedText.put(statusBar, (Pair<String, String>)Pair.pair((Object)info, (Object)((String)textsPair.second)));
        }
        return (String)textsPair.first;
    }
}

